/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.systemTray.peer.EntryPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.jna.linux.GObject;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkEventDispatch;
import java.io.File;

abstract class GtkBaseMenuItem
implements EntryPeer {
    private static final File transparentIcon = ImageResizeUtil.getTransparentImage();
    private volatile boolean hasLegitImage = false;
    private volatile Pointer spacerImage;
    protected final Pointer _native;

    GtkBaseMenuItem(Pointer _native) {
        this._native = _native;
    }

    public boolean hasImage() {
        return this.hasLegitImage;
    }

    void setLegitImage(boolean isLegit) {
        this.hasLegitImage = isLegit;
    }

    protected void removeSpacerImage() {
        if (this.spacerImage != null) {
            Gtk.Gtk2.gtk_container_remove(this._native, this.spacerImage);
            this.spacerImage = null;
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        }
    }

    protected void addSpacerImage() {
        if (this.spacerImage == null) {
            this.spacerImage = Gtk.Gtk2.gtk_image_new_from_file(transparentIcon.getAbsolutePath());
            Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.spacerImage);
            Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
        }
    }

    public void setSpacerImage(boolean everyoneElseHasImages) {
        if (this.hasLegitImage) {
            return;
        }
        this.removeSpacerImage();
        if (everyoneElseHasImages) {
            this.addSpacerImage();
        }
        Gtk.Gtk2.gtk_widget_show_all(this._native);
    }

    void onDeleteMenu(Pointer parentNative) {
        GObject.g_object_force_floating(this._native);
        Gtk.Gtk2.gtk_container_remove(parentNative, this._native);
    }

    void onCreateMenu(Pointer parentNative, boolean hasImagesInMenu) {
        this.setSpacerImage(hasImagesInMenu);
        Gtk.Gtk2.gtk_menu_shell_append(parentNative, this._native);
        GObject.g_object_ref_sink(this._native);
        Gtk.Gtk2.gtk_widget_show_all(this._native);
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                if (GtkBaseMenuItem.this.spacerImage != null) {
                    Gtk.Gtk2.gtk_container_remove(GtkBaseMenuItem.this._native, GtkBaseMenuItem.this.spacerImage);
                    GtkBaseMenuItem.this.spacerImage = null;
                }
            }
        });
    }
}

