/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.stream.ImageInputStream;

public class MenuItem
extends Entry {
    private static boolean alreadyEmittedTooltipWarning = false;
    private volatile String text;
    private volatile File imageFile;
    private volatile ActionListener callback;
    private volatile boolean enabled = true;
    private volatile char mnemonicKey;
    private volatile String tooltip;

    public MenuItem() {
        this(null, null, null, false);
    }

    public MenuItem(String text) {
        this(text, null, null, false);
    }

    public MenuItem(String text, ActionListener callback) {
        this(text, null, callback, false);
    }

    public MenuItem(String text, String imagePath) {
        this(text, imagePath, null);
    }

    public MenuItem(String text, File imageFile) {
        this(text, imageFile, null);
    }

    public MenuItem(String text, URL imageUrl) {
        this(text, imageUrl, null);
    }

    public MenuItem(String text, InputStream imageStream) {
        this(text, imageStream, null);
    }

    public MenuItem(String text, Image image) {
        this(text, image, null);
    }

    public MenuItem(String text, String imagePath, ActionListener callback) {
        this(text, ImageResizeUtil.shouldResizeOrCache(false, imagePath), callback, false);
    }

    public MenuItem(String text, File imageFile, ActionListener callback) {
        this(text, ImageResizeUtil.shouldResizeOrCache(false, imageFile), callback, false);
    }

    public MenuItem(String text, URL imageUrl, ActionListener callback) {
        this(text, ImageResizeUtil.shouldResizeOrCache(false, imageUrl), callback, false);
    }

    public MenuItem(String text, InputStream imageStream, ActionListener callback) {
        this(text, ImageResizeUtil.shouldResizeOrCache(false, imageStream), callback, false);
    }

    public MenuItem(String text, Image image, ActionListener callback) {
        this(text, ImageResizeUtil.shouldResizeOrCache(false, image), callback, false);
    }

    public MenuItem(String text, ImageInputStream imageStream, ActionListener callback) {
        this(text, ImageResizeUtil.shouldResizeOrCache(false, imageStream), callback, false);
    }

    private MenuItem(String text, File imageFile, ActionListener callback, boolean unused) {
        this.text = text;
        this.imageFile = imageFile;
        this.callback = callback;
    }

    public void bind(MenuItemPeer peer, Menu parent, SystemTray systemTray) {
        super.bind(peer, parent, systemTray);
        peer.setImage(this);
        peer.setEnabled(this);
        peer.setText(this);
        peer.setCallback(this);
        peer.setShortcut(this);
        peer.setTooltip(this);
    }

    protected void setImage_(File imageFile) {
        this.imageFile = imageFile;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public File getImage() {
        return this.imageFile;
    }

    public ActionListener getCallback() {
        return this.callback;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setText(this);
        }
    }

    public void setImage(File imageFile) {
        this.setImage_(ImageResizeUtil.shouldResizeOrCache(false, imageFile));
    }

    public void setImage(String imagePath) {
        this.setImage_(ImageResizeUtil.shouldResizeOrCache(false, imagePath));
    }

    public void setImage(URL imageUrl) {
        this.setImage_(ImageResizeUtil.shouldResizeOrCache(false, imageUrl));
    }

    public void setImage(InputStream imageStream) {
        this.setImage_(ImageResizeUtil.shouldResizeOrCache(false, imageStream));
    }

    public void setImage(Image image) {
        this.setImage_(ImageResizeUtil.shouldResizeOrCache(false, image));
    }

    public void setImage(ImageInputStream imageStream) {
        this.setImage_(ImageResizeUtil.shouldResizeOrCache(false, imageStream));
    }

    public boolean hasImage() {
        return this.imageFile != null;
    }

    public void setCallback(ActionListener callback) {
        this.callback = callback;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setCallback(this);
        }
    }

    public char getShortcut() {
        return this.mnemonicKey;
    }

    public void setShortcut(char key) {
        this.mnemonicKey = key;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setShortcut(this);
        }
    }

    public void setShortcut(int key) {
        this.mnemonicKey = SwingUtil.getFromVirtualKey(key);
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setShortcut(this);
        }
    }

    public void setTooltip(String tooltipText) {
        if (tooltipText != null) {
            if (tooltipText.length() > 64) {
                throw new RuntimeException("Tooltip text cannot be longer than 64 characters.");
            }
            if (!alreadyEmittedTooltipWarning) {
                alreadyEmittedTooltipWarning = true;
                SystemTray.logger.warn("Tooltips are not consistent across all platforms and tray types.");
            }
        }
        this.tooltip = tooltipText;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setTooltip(this);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }
}

