/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.model;

import com.docusign.maestro.model.WorkflowDefinitionMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Returns a list of workflow definitions' metadata (0 or more).")
public class WorkflowDefinitionList
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="count")
    private BigDecimal count = null;
    @JsonProperty(value="value")
    private List<WorkflowDefinitionMetadata> value = null;

    public WorkflowDefinitionList count(BigDecimal count) {
        this.count = count;
        return this;
    }

    @Schema(example="1.0", description="Total number of definitions returned")
    public BigDecimal getCount() {
        return this.count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public WorkflowDefinitionList value(List<WorkflowDefinitionMetadata> value) {
        this.value = value;
        return this;
    }

    public WorkflowDefinitionList addValueItem(WorkflowDefinitionMetadata valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<WorkflowDefinitionMetadata>();
        }
        this.value.add(valueItem);
        return this;
    }

    @Schema(description="Array of workflow definition metadata")
    public List<WorkflowDefinitionMetadata> getValue() {
        return this.value;
    }

    public void setValue(List<WorkflowDefinitionMetadata> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDefinitionList workflowDefinitionList = (WorkflowDefinitionList)o;
        return Objects.equals(this.count, workflowDefinitionList.count) && Objects.equals(this.value, workflowDefinitionList.value);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowDefinitionList {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

