package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** EnvelopeTemplateResult */
public class EnvelopeTemplateResult {
  @JsonProperty("allowMarkup")
  private String allowMarkup = null;

  @JsonProperty("allowReassign")
  private String allowReassign = null;

  @JsonProperty("allowViewHistory")
  private String allowViewHistory = null;

  @JsonProperty("asynchronous")
  private String asynchronous = null;

  @JsonProperty("attachmentsUri")
  private String attachmentsUri = null;

  @JsonProperty("authoritativeCopy")
  private String authoritativeCopy = null;

  @JsonProperty("authoritativeCopyDefault")
  private String authoritativeCopyDefault = null;

  @JsonProperty("autoNavigation")
  private String autoNavigation = null;

  @JsonProperty("brandId")
  private String brandId = null;

  @JsonProperty("brandLock")
  private String brandLock = null;

  @JsonProperty("certificateUri")
  private String certificateUri = null;

  @JsonProperty("completedDateTime")
  private String completedDateTime = null;

  @JsonProperty("created")
  private String created = null;

  @JsonProperty("createdDateTime")
  private String createdDateTime = null;

  @JsonProperty("customFields")
  private CustomFields customFields = null;

  @JsonProperty("customFieldsUri")
  private String customFieldsUri = null;

  @JsonProperty("declinedDateTime")
  private String declinedDateTime = null;

  @JsonProperty("deletedDateTime")
  private String deletedDateTime = null;

  @JsonProperty("deliveredDateTime")
  private String deliveredDateTime = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("documents")
  private java.util.List<Document> documents = new java.util.ArrayList<Document>();

  @JsonProperty("documentsCombinedUri")
  private String documentsCombinedUri = null;

  @JsonProperty("documentsUri")
  private String documentsUri = null;

  @JsonProperty("emailBlurb")
  private String emailBlurb = null;

  @JsonProperty("emailSettings")
  private EmailSettings emailSettings = null;

  @JsonProperty("emailSubject")
  private String emailSubject = null;

  @JsonProperty("enableWetSign")
  private String enableWetSign = null;

  @JsonProperty("enforceSignerVisibility")
  private String enforceSignerVisibility = null;

  @JsonProperty("envelopeId")
  private String envelopeId = null;

  @JsonProperty("envelopeIdStamping")
  private String envelopeIdStamping = null;

  @JsonProperty("envelopeUri")
  private String envelopeUri = null;

  @JsonProperty("folderId")
  private String folderId = null;

  @JsonProperty("folderName")
  private String folderName = null;

  @JsonProperty("folderUri")
  private String folderUri = null;

  @JsonProperty("initialSentDateTime")
  private String initialSentDateTime = null;

  @JsonProperty("is21CFRPart11")
  private String is21CFRPart11 = null;

  @JsonProperty("isSignatureProviderEnvelope")
  private String isSignatureProviderEnvelope = null;

  @JsonProperty("lastModified")
  private String lastModified = null;

  @JsonProperty("lastModifiedDateTime")
  private String lastModifiedDateTime = null;

  @JsonProperty("lockInformation")
  private LockInformation lockInformation = null;

  @JsonProperty("messageLock")
  private String messageLock = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("notification")
  private Notification notification = null;

  @JsonProperty("notificationUri")
  private String notificationUri = null;

  @JsonProperty("owner")
  private UserInfo owner = null;

  @JsonProperty("pageCount")
  private Integer pageCount = null;

  @JsonProperty("parentFolderUri")
  private String parentFolderUri = null;

  @JsonProperty("password")
  private String password = null;

  @JsonProperty("purgeState")
  private String purgeState = null;

  @JsonProperty("recipients")
  private Recipients recipients = null;

  @JsonProperty("recipientsLock")
  private String recipientsLock = null;

  @JsonProperty("recipientsUri")
  private String recipientsUri = null;

  @JsonProperty("sentDateTime")
  private String sentDateTime = null;

  @JsonProperty("shared")
  private String shared = null;

  @JsonProperty("signerCanSignOnMobile")
  private String signerCanSignOnMobile = null;

  @JsonProperty("signingLocation")
  private String signingLocation = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("statusChangedDateTime")
  private String statusChangedDateTime = null;

  @JsonProperty("templateId")
  private String templateId = null;

  @JsonProperty("templatesUri")
  private String templatesUri = null;

  @JsonProperty("transactionId")
  private String transactionId = null;

  @JsonProperty("uri")
  private String uri = null;

  @JsonProperty("useDisclosure")
  private String useDisclosure = null;

  @JsonProperty("voidedDateTime")
  private String voidedDateTime = null;

  @JsonProperty("voidedReason")
  private String voidedReason = null;

  public EnvelopeTemplateResult allowMarkup(String allowMarkup) {
    this.allowMarkup = allowMarkup;
    return this;
  }

  /**
   * When set to **true**, Document Markup is enabled for envelope. Account must have Document
   * Markup enabled to use this
   *
   * @return allowMarkup
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this")
  public String getAllowMarkup() {
    return allowMarkup;
  }

  public void setAllowMarkup(String allowMarkup) {
    this.allowMarkup = allowMarkup;
  }

  public EnvelopeTemplateResult allowReassign(String allowReassign) {
    this.allowReassign = allowReassign;
    return this;
  }

  /**
   * When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.
   *
   * @return allowReassign
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.")
  public String getAllowReassign() {
    return allowReassign;
  }

  public void setAllowReassign(String allowReassign) {
    this.allowReassign = allowReassign;
  }

  public EnvelopeTemplateResult allowViewHistory(String allowViewHistory) {
    this.allowViewHistory = allowViewHistory;
    return this;
  }

  /** @return allowViewHistory */
  @Schema(example = "null", description = "")
  public String getAllowViewHistory() {
    return allowViewHistory;
  }

  public void setAllowViewHistory(String allowViewHistory) {
    this.allowViewHistory = allowViewHistory;
  }

  public EnvelopeTemplateResult asynchronous(String asynchronous) {
    this.asynchronous = asynchronous;
    return this;
  }

  /**
   * When set to **true**, the envelope is queued for processing and the value of the `status`
   * property is set to 'Processing'. Additionally, get status calls return 'Processing' until
   * completed.
   *
   * @return asynchronous
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.")
  public String getAsynchronous() {
    return asynchronous;
  }

  public void setAsynchronous(String asynchronous) {
    this.asynchronous = asynchronous;
  }

  public EnvelopeTemplateResult attachmentsUri(String attachmentsUri) {
    this.attachmentsUri = attachmentsUri;
    return this;
  }

  /** @return attachmentsUri */
  @Schema(example = "null", description = "")
  public String getAttachmentsUri() {
    return attachmentsUri;
  }

  public void setAttachmentsUri(String attachmentsUri) {
    this.attachmentsUri = attachmentsUri;
  }

  public EnvelopeTemplateResult authoritativeCopy(String authoritativeCopy) {
    this.authoritativeCopy = authoritativeCopy;
    return this;
  }

  /**
   * Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is
   * enabled.
   *
   * @return authoritativeCopy
   */
  @Schema(
      example = "null",
      description =
          "Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.")
  public String getAuthoritativeCopy() {
    return authoritativeCopy;
  }

  public void setAuthoritativeCopy(String authoritativeCopy) {
    this.authoritativeCopy = authoritativeCopy;
  }

  public EnvelopeTemplateResult authoritativeCopyDefault(String authoritativeCopyDefault) {
    this.authoritativeCopyDefault = authoritativeCopyDefault;
    return this;
  }

  /** @return authoritativeCopyDefault */
  @Schema(example = "null", description = "")
  public String getAuthoritativeCopyDefault() {
    return authoritativeCopyDefault;
  }

  public void setAuthoritativeCopyDefault(String authoritativeCopyDefault) {
    this.authoritativeCopyDefault = authoritativeCopyDefault;
  }

  public EnvelopeTemplateResult autoNavigation(String autoNavigation) {
    this.autoNavigation = autoNavigation;
    return this;
  }

  /** @return autoNavigation */
  @Schema(example = "null", description = "")
  public String getAutoNavigation() {
    return autoNavigation;
  }

  public void setAutoNavigation(String autoNavigation) {
    this.autoNavigation = autoNavigation;
  }

  public EnvelopeTemplateResult brandId(String brandId) {
    this.brandId = brandId;
    return this;
  }

  /** @return brandId */
  @Schema(example = "null", description = "")
  public String getBrandId() {
    return brandId;
  }

  public void setBrandId(String brandId) {
    this.brandId = brandId;
  }

  public EnvelopeTemplateResult brandLock(String brandLock) {
    this.brandLock = brandLock;
    return this;
  }

  /** @return brandLock */
  @Schema(example = "null", description = "")
  public String getBrandLock() {
    return brandLock;
  }

  public void setBrandLock(String brandLock) {
    this.brandLock = brandLock;
  }

  public EnvelopeTemplateResult certificateUri(String certificateUri) {
    this.certificateUri = certificateUri;
    return this;
  }

  /**
   * Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.
   *
   * @return certificateUri
   */
  @Schema(
      example = "null",
      description =
          "Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.")
  public String getCertificateUri() {
    return certificateUri;
  }

  public void setCertificateUri(String certificateUri) {
    this.certificateUri = certificateUri;
  }

  public EnvelopeTemplateResult completedDateTime(String completedDateTime) {
    this.completedDateTime = completedDateTime;
    return this;
  }

  /**
   * Specifies the date and time this item was completed.
   *
   * @return completedDateTime
   */
  @Schema(example = "null", description = "Specifies the date and time this item was completed.")
  public String getCompletedDateTime() {
    return completedDateTime;
  }

  public void setCompletedDateTime(String completedDateTime) {
    this.completedDateTime = completedDateTime;
  }

  public EnvelopeTemplateResult created(String created) {
    this.created = created;
    return this;
  }

  /** @return created */
  @Schema(example = "null", description = "")
  public String getCreated() {
    return created;
  }

  public void setCreated(String created) {
    this.created = created;
  }

  public EnvelopeTemplateResult createdDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
    return this;
  }

  /**
   * Indicates the date and time the item was created.
   *
   * @return createdDateTime
   */
  @Schema(example = "null", description = "Indicates the date and time the item was created.")
  public String getCreatedDateTime() {
    return createdDateTime;
  }

  public void setCreatedDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
  }

  public EnvelopeTemplateResult customFields(CustomFields customFields) {
    this.customFields = customFields;
    return this;
  }

  /**
   * Get customFields
   *
   * @return customFields
   */
  @Schema(example = "null", description = "")
  public CustomFields getCustomFields() {
    return customFields;
  }

  public void setCustomFields(CustomFields customFields) {
    this.customFields = customFields;
  }

  public EnvelopeTemplateResult customFieldsUri(String customFieldsUri) {
    this.customFieldsUri = customFieldsUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint that you can use to retrieve the custom fields.
   *
   * @return customFieldsUri
   */
  @Schema(
      example = "null",
      description =
          "Contains a URI for an endpoint that you can use to retrieve the custom fields.")
  public String getCustomFieldsUri() {
    return customFieldsUri;
  }

  public void setCustomFieldsUri(String customFieldsUri) {
    this.customFieldsUri = customFieldsUri;
  }

  public EnvelopeTemplateResult declinedDateTime(String declinedDateTime) {
    this.declinedDateTime = declinedDateTime;
    return this;
  }

  /**
   * The date and time the recipient declined the document.
   *
   * @return declinedDateTime
   */
  @Schema(example = "null", description = "The date and time the recipient declined the document.")
  public String getDeclinedDateTime() {
    return declinedDateTime;
  }

  public void setDeclinedDateTime(String declinedDateTime) {
    this.declinedDateTime = declinedDateTime;
  }

  public EnvelopeTemplateResult deletedDateTime(String deletedDateTime) {
    this.deletedDateTime = deletedDateTime;
    return this;
  }

  /**
   * Specifies the data and time the item was deleted.
   *
   * @return deletedDateTime
   */
  @Schema(example = "null", description = "Specifies the data and time the item was deleted.")
  public String getDeletedDateTime() {
    return deletedDateTime;
  }

  public void setDeletedDateTime(String deletedDateTime) {
    this.deletedDateTime = deletedDateTime;
  }

  public EnvelopeTemplateResult deliveredDateTime(String deliveredDateTime) {
    this.deliveredDateTime = deliveredDateTime;
    return this;
  }

  /**
   * Reserved: For DocuSign use only.
   *
   * @return deliveredDateTime
   */
  @Schema(example = "null", description = "Reserved: For DocuSign use only.")
  public String getDeliveredDateTime() {
    return deliveredDateTime;
  }

  public void setDeliveredDateTime(String deliveredDateTime) {
    this.deliveredDateTime = deliveredDateTime;
  }

  public EnvelopeTemplateResult description(String description) {
    this.description = description;
    return this;
  }

  /** @return description */
  @Schema(example = "null", description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public EnvelopeTemplateResult documents(java.util.List<Document> documents) {
    this.documents = documents;
    return this;
  }

  public EnvelopeTemplateResult addDocumentsItem(Document documentsItem) {
    this.documents.add(documentsItem);
    return this;
  }

  /**
   * Complex element contains the details on the documents in the envelope.
   *
   * @return documents
   */
  @Schema(
      example = "null",
      description = "Complex element contains the details on the documents in the envelope.")
  public java.util.List<Document> getDocuments() {
    return documents;
  }

  public void setDocuments(java.util.List<Document> documents) {
    this.documents = documents;
  }

  public EnvelopeTemplateResult documentsCombinedUri(String documentsCombinedUri) {
    this.documentsCombinedUri = documentsCombinedUri;
    return this;
  }

  /** @return documentsCombinedUri */
  @Schema(example = "null", description = "")
  public String getDocumentsCombinedUri() {
    return documentsCombinedUri;
  }

  public void setDocumentsCombinedUri(String documentsCombinedUri) {
    this.documentsCombinedUri = documentsCombinedUri;
  }

  public EnvelopeTemplateResult documentsUri(String documentsUri) {
    this.documentsUri = documentsUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint that you can use to retrieve the documents.
   *
   * @return documentsUri
   */
  @Schema(
      example = "null",
      description = "Contains a URI for an endpoint that you can use to retrieve the documents.")
  public String getDocumentsUri() {
    return documentsUri;
  }

  public void setDocumentsUri(String documentsUri) {
    this.documentsUri = documentsUri;
  }

  public EnvelopeTemplateResult emailBlurb(String emailBlurb) {
    this.emailBlurb = emailBlurb;
    return this;
  }

  /** @return emailBlurb */
  @Schema(example = "null", description = "")
  public String getEmailBlurb() {
    return emailBlurb;
  }

  public void setEmailBlurb(String emailBlurb) {
    this.emailBlurb = emailBlurb;
  }

  public EnvelopeTemplateResult emailSettings(EmailSettings emailSettings) {
    this.emailSettings = emailSettings;
    return this;
  }

  /**
   * Get emailSettings
   *
   * @return emailSettings
   */
  @Schema(example = "null", description = "")
  public EmailSettings getEmailSettings() {
    return emailSettings;
  }

  public void setEmailSettings(EmailSettings emailSettings) {
    this.emailSettings = emailSettings;
  }

  public EnvelopeTemplateResult emailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
    return this;
  }

  /**
   * Specifies the subject of the email that is sent to all recipients. See [ML:Template Email
   * Subject Merge Fields] for information about adding merge field information to the email
   * subject.
   *
   * @return emailSubject
   */
  @Schema(
      example = "null",
      description =
          "Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.")
  public String getEmailSubject() {
    return emailSubject;
  }

  public void setEmailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
  }

  public EnvelopeTemplateResult enableWetSign(String enableWetSign) {
    this.enableWetSign = enableWetSign;
    return this;
  }

  /**
   * When set to **true**, the signer is allowed to print the document and sign it on paper.
   *
   * @return enableWetSign
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, the signer is allowed to print the document and sign it on paper.")
  public String getEnableWetSign() {
    return enableWetSign;
  }

  public void setEnableWetSign(String enableWetSign) {
    this.enableWetSign = enableWetSign;
  }

  public EnvelopeTemplateResult enforceSignerVisibility(String enforceSignerVisibility) {
    this.enforceSignerVisibility = enforceSignerVisibility;
    return this;
  }

  /**
   * When set to **true**, documents with tabs can only be viewed by signers that have a tab on that
   * document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or
   * informational role (Certified Deliveries or Carbon Copies) can always see all the documents in
   * an envelope, unless they are specifically excluded using this setting when an envelope is sent.
   * Documents that do not have tabs are always visible to all recipients, unless they are
   * specifically excluded using this setting when an envelope is sent. Your account must have
   * Document Visibility enabled to use this.
   *
   * @return enforceSignerVisibility
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.")
  public String getEnforceSignerVisibility() {
    return enforceSignerVisibility;
  }

  public void setEnforceSignerVisibility(String enforceSignerVisibility) {
    this.enforceSignerVisibility = enforceSignerVisibility;
  }

  public EnvelopeTemplateResult envelopeId(String envelopeId) {
    this.envelopeId = envelopeId;
    return this;
  }

  /**
   * The envelope ID of the envelope status that failed to post.
   *
   * @return envelopeId
   */
  @Schema(
      example = "null",
      description = "The envelope ID of the envelope status that failed to post.")
  public String getEnvelopeId() {
    return envelopeId;
  }

  public void setEnvelopeId(String envelopeId) {
    this.envelopeId = envelopeId;
  }

  public EnvelopeTemplateResult envelopeIdStamping(String envelopeIdStamping) {
    this.envelopeIdStamping = envelopeIdStamping;
    return this;
  }

  /**
   * When set to **true**, Envelope ID Stamping is enabled.
   *
   * @return envelopeIdStamping
   */
  @Schema(example = "null", description = "When set to **true**, Envelope ID Stamping is enabled.")
  public String getEnvelopeIdStamping() {
    return envelopeIdStamping;
  }

  public void setEnvelopeIdStamping(String envelopeIdStamping) {
    this.envelopeIdStamping = envelopeIdStamping;
  }

  public EnvelopeTemplateResult envelopeUri(String envelopeUri) {
    this.envelopeUri = envelopeUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.
   *
   * @return envelopeUri
   */
  @Schema(
      example = "null",
      description =
          "Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.")
  public String getEnvelopeUri() {
    return envelopeUri;
  }

  public void setEnvelopeUri(String envelopeUri) {
    this.envelopeUri = envelopeUri;
  }

  public EnvelopeTemplateResult folderId(String folderId) {
    this.folderId = folderId;
    return this;
  }

  /** @return folderId */
  @Schema(example = "null", description = "")
  public String getFolderId() {
    return folderId;
  }

  public void setFolderId(String folderId) {
    this.folderId = folderId;
  }

  public EnvelopeTemplateResult folderName(String folderName) {
    this.folderName = folderName;
    return this;
  }

  /** @return folderName */
  @Schema(example = "null", description = "")
  public String getFolderName() {
    return folderName;
  }

  public void setFolderName(String folderName) {
    this.folderName = folderName;
  }

  public EnvelopeTemplateResult folderUri(String folderUri) {
    this.folderUri = folderUri;
    return this;
  }

  /** @return folderUri */
  @Schema(example = "null", description = "")
  public String getFolderUri() {
    return folderUri;
  }

  public void setFolderUri(String folderUri) {
    this.folderUri = folderUri;
  }

  public EnvelopeTemplateResult initialSentDateTime(String initialSentDateTime) {
    this.initialSentDateTime = initialSentDateTime;
    return this;
  }

  /** @return initialSentDateTime */
  @Schema(example = "null", description = "")
  public String getInitialSentDateTime() {
    return initialSentDateTime;
  }

  public void setInitialSentDateTime(String initialSentDateTime) {
    this.initialSentDateTime = initialSentDateTime;
  }

  public EnvelopeTemplateResult is21CFRPart11(String is21CFRPart11) {
    this.is21CFRPart11 = is21CFRPart11;
    return this;
  }

  /**
   * When set to **true**, indicates that this module is enabled on the account.
   *
   * @return is21CFRPart11
   */
  @Schema(
      example = "null",
      description = "When set to **true**, indicates that this module is enabled on the account.")
  public String getIs21CFRPart11() {
    return is21CFRPart11;
  }

  public void setIs21CFRPart11(String is21CFRPart11) {
    this.is21CFRPart11 = is21CFRPart11;
  }

  public EnvelopeTemplateResult isSignatureProviderEnvelope(String isSignatureProviderEnvelope) {
    this.isSignatureProviderEnvelope = isSignatureProviderEnvelope;
    return this;
  }

  /** @return isSignatureProviderEnvelope */
  @Schema(example = "null", description = "")
  public String getIsSignatureProviderEnvelope() {
    return isSignatureProviderEnvelope;
  }

  public void setIsSignatureProviderEnvelope(String isSignatureProviderEnvelope) {
    this.isSignatureProviderEnvelope = isSignatureProviderEnvelope;
  }

  public EnvelopeTemplateResult lastModified(String lastModified) {
    this.lastModified = lastModified;
    return this;
  }

  /** @return lastModified */
  @Schema(example = "null", description = "")
  public String getLastModified() {
    return lastModified;
  }

  public void setLastModified(String lastModified) {
    this.lastModified = lastModified;
  }

  public EnvelopeTemplateResult lastModifiedDateTime(String lastModifiedDateTime) {
    this.lastModifiedDateTime = lastModifiedDateTime;
    return this;
  }

  /**
   * The date and time the item was last modified.
   *
   * @return lastModifiedDateTime
   */
  @Schema(example = "null", description = "The date and time the item was last modified.")
  public String getLastModifiedDateTime() {
    return lastModifiedDateTime;
  }

  public void setLastModifiedDateTime(String lastModifiedDateTime) {
    this.lastModifiedDateTime = lastModifiedDateTime;
  }

  public EnvelopeTemplateResult lockInformation(LockInformation lockInformation) {
    this.lockInformation = lockInformation;
    return this;
  }

  /**
   * Get lockInformation
   *
   * @return lockInformation
   */
  @Schema(example = "null", description = "")
  public LockInformation getLockInformation() {
    return lockInformation;
  }

  public void setLockInformation(LockInformation lockInformation) {
    this.lockInformation = lockInformation;
  }

  public EnvelopeTemplateResult messageLock(String messageLock) {
    this.messageLock = messageLock;
    return this;
  }

  /**
   * When set to **true**, prevents senders from changing the contents of `emailBlurb` and
   * `emailSubject` properties for the envelope. Additionally, this prevents users from making
   * changes to the contents of `emailBlurb` and `emailSubject` properties when correcting
   * envelopes. However, if the `messageLock` node is set to true**** and the `emailSubject`
   * property is empty, senders and correctors are able to add a subject to the envelope.
   *
   * @return messageLock
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.")
  public String getMessageLock() {
    return messageLock;
  }

  public void setMessageLock(String messageLock) {
    this.messageLock = messageLock;
  }

  public EnvelopeTemplateResult name(String name) {
    this.name = name;
    return this;
  }

  /** @return name */
  @Schema(example = "null", description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public EnvelopeTemplateResult notification(Notification notification) {
    this.notification = notification;
    return this;
  }

  /**
   * Get notification
   *
   * @return notification
   */
  @Schema(example = "null", description = "")
  public Notification getNotification() {
    return notification;
  }

  public void setNotification(Notification notification) {
    this.notification = notification;
  }

  public EnvelopeTemplateResult notificationUri(String notificationUri) {
    this.notificationUri = notificationUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint that you can use to retrieve the notifications.
   *
   * @return notificationUri
   */
  @Schema(
      example = "null",
      description =
          "Contains a URI for an endpoint that you can use to retrieve the notifications.")
  public String getNotificationUri() {
    return notificationUri;
  }

  public void setNotificationUri(String notificationUri) {
    this.notificationUri = notificationUri;
  }

  public EnvelopeTemplateResult owner(UserInfo owner) {
    this.owner = owner;
    return this;
  }

  /**
   * Get owner
   *
   * @return owner
   */
  @Schema(example = "null", description = "")
  public UserInfo getOwner() {
    return owner;
  }

  public void setOwner(UserInfo owner) {
    this.owner = owner;
  }

  public EnvelopeTemplateResult pageCount(Integer pageCount) {
    this.pageCount = pageCount;
    return this;
  }

  /** @return pageCount */
  @Schema(example = "null", description = "")
  public Integer getPageCount() {
    return pageCount;
  }

  public void setPageCount(Integer pageCount) {
    this.pageCount = pageCount;
  }

  public EnvelopeTemplateResult parentFolderUri(String parentFolderUri) {
    this.parentFolderUri = parentFolderUri;
    return this;
  }

  /** @return parentFolderUri */
  @Schema(example = "null", description = "")
  public String getParentFolderUri() {
    return parentFolderUri;
  }

  public void setParentFolderUri(String parentFolderUri) {
    this.parentFolderUri = parentFolderUri;
  }

  public EnvelopeTemplateResult password(String password) {
    this.password = password;
    return this;
  }

  /** @return password */
  @Schema(example = "null", description = "")
  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public EnvelopeTemplateResult purgeState(String purgeState) {
    this.purgeState = purgeState;
    return this;
  }

  /** @return purgeState */
  @Schema(example = "null", description = "")
  public String getPurgeState() {
    return purgeState;
  }

  public void setPurgeState(String purgeState) {
    this.purgeState = purgeState;
  }

  public EnvelopeTemplateResult recipients(Recipients recipients) {
    this.recipients = recipients;
    return this;
  }

  /**
   * Get recipients
   *
   * @return recipients
   */
  @Schema(example = "null", description = "")
  public Recipients getRecipients() {
    return recipients;
  }

  public void setRecipients(Recipients recipients) {
    this.recipients = recipients;
  }

  public EnvelopeTemplateResult recipientsLock(String recipientsLock) {
    this.recipientsLock = recipientsLock;
    return this;
  }

  /**
   * When set to **true**, prevents senders from changing, correcting, or deleting the recipient
   * information for the envelope.
   *
   * @return recipientsLock
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.")
  public String getRecipientsLock() {
    return recipientsLock;
  }

  public void setRecipientsLock(String recipientsLock) {
    this.recipientsLock = recipientsLock;
  }

  public EnvelopeTemplateResult recipientsUri(String recipientsUri) {
    this.recipientsUri = recipientsUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint that you can use to retrieve the recipients.
   *
   * @return recipientsUri
   */
  @Schema(
      example = "null",
      description = "Contains a URI for an endpoint that you can use to retrieve the recipients.")
  public String getRecipientsUri() {
    return recipientsUri;
  }

  public void setRecipientsUri(String recipientsUri) {
    this.recipientsUri = recipientsUri;
  }

  public EnvelopeTemplateResult sentDateTime(String sentDateTime) {
    this.sentDateTime = sentDateTime;
    return this;
  }

  /**
   * The date and time the envelope was sent.
   *
   * @return sentDateTime
   */
  @Schema(example = "null", description = "The date and time the envelope was sent.")
  public String getSentDateTime() {
    return sentDateTime;
  }

  public void setSentDateTime(String sentDateTime) {
    this.sentDateTime = sentDateTime;
  }

  public EnvelopeTemplateResult shared(String shared) {
    this.shared = shared;
    return this;
  }

  /**
   * When set to **true**, this custom tab is shared.
   *
   * @return shared
   */
  @Schema(example = "null", description = "When set to **true**, this custom tab is shared.")
  public String getShared() {
    return shared;
  }

  public void setShared(String shared) {
    this.shared = shared;
  }

  public EnvelopeTemplateResult signerCanSignOnMobile(String signerCanSignOnMobile) {
    this.signerCanSignOnMobile = signerCanSignOnMobile;
    return this;
  }

  /** @return signerCanSignOnMobile */
  @Schema(example = "null", description = "")
  public String getSignerCanSignOnMobile() {
    return signerCanSignOnMobile;
  }

  public void setSignerCanSignOnMobile(String signerCanSignOnMobile) {
    this.signerCanSignOnMobile = signerCanSignOnMobile;
  }

  public EnvelopeTemplateResult signingLocation(String signingLocation) {
    this.signingLocation = signingLocation;
    return this;
  }

  /**
   * Specifies the physical location where the signing takes place. It can have two enumeration
   * values; InPerson and Online. The default value is Online.
   *
   * @return signingLocation
   */
  @Schema(
      example = "null",
      description =
          "Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.")
  public String getSigningLocation() {
    return signingLocation;
  }

  public void setSigningLocation(String signingLocation) {
    this.signingLocation = signingLocation;
  }

  public EnvelopeTemplateResult status(String status) {
    this.status = status;
    return this;
  }

  /**
   * Indicates the envelope status. Valid values are: * sent - The envelope is sent to the
   * recipients. * created - The envelope is saved as a draft and can be modified and sent later.
   *
   * @return status
   */
  @Schema(
      example = "null",
      description =
          "Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public EnvelopeTemplateResult statusChangedDateTime(String statusChangedDateTime) {
    this.statusChangedDateTime = statusChangedDateTime;
    return this;
  }

  /**
   * The data and time the status changed.
   *
   * @return statusChangedDateTime
   */
  @Schema(example = "null", description = "The data and time the status changed.")
  public String getStatusChangedDateTime() {
    return statusChangedDateTime;
  }

  public void setStatusChangedDateTime(String statusChangedDateTime) {
    this.statusChangedDateTime = statusChangedDateTime;
  }

  public EnvelopeTemplateResult templateId(String templateId) {
    this.templateId = templateId;
    return this;
  }

  /**
   * The unique identifier of the template. If this is not provided, DocuSign will generate a value.
   *
   * @return templateId
   */
  @Schema(
      example = "null",
      description =
          "The unique identifier of the template. If this is not provided, DocuSign will generate a value. ")
  public String getTemplateId() {
    return templateId;
  }

  public void setTemplateId(String templateId) {
    this.templateId = templateId;
  }

  public EnvelopeTemplateResult templatesUri(String templatesUri) {
    this.templatesUri = templatesUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint which you can use to retrieve the templates.
   *
   * @return templatesUri
   */
  @Schema(
      example = "null",
      description = "Contains a URI for an endpoint which you can use to retrieve the templates.")
  public String getTemplatesUri() {
    return templatesUri;
  }

  public void setTemplatesUri(String templatesUri) {
    this.templatesUri = templatesUri;
  }

  public EnvelopeTemplateResult transactionId(String transactionId) {
    this.transactionId = transactionId;
    return this;
  }

  /**
   * Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign
   * system for 7 days. It is recommended that a transaction ID is used for offline signing to
   * ensure that an envelope is not sent multiple times. The `transactionId` property can be used
   * determine an envelope's status (i.e. was it created or not) in cases where the internet
   * connection was lost before the envelope status was returned.
   *
   * @return transactionId
   */
  @Schema(
      example = "null",
      description =
          " Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.")
  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public EnvelopeTemplateResult uri(String uri) {
    this.uri = uri;
    return this;
  }

  /** @return uri */
  @Schema(example = "null", description = "")
  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  public EnvelopeTemplateResult useDisclosure(String useDisclosure) {
    this.useDisclosure = useDisclosure;
    return this;
  }

  /**
   * When set to **true**, the disclosure is shown to recipients in accordance with the account's
   * Electronic Record and Signature Disclosure frequency setting. When set to **false**, the
   * Electronic Record and Signature Disclosure is not shown to any envelope recipients. If the
   * `useDisclosure` property is not set, then the account's normal disclosure setting is used and
   * the value of the `useDisclosure` property is not returned in responses when getting envelope
   * information.
   *
   * @return useDisclosure
   */
  @Schema(
      example = "null",
      description =
          "When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.")
  public String getUseDisclosure() {
    return useDisclosure;
  }

  public void setUseDisclosure(String useDisclosure) {
    this.useDisclosure = useDisclosure;
  }

  public EnvelopeTemplateResult voidedDateTime(String voidedDateTime) {
    this.voidedDateTime = voidedDateTime;
    return this;
  }

  /**
   * The date and time the envelope or template was voided.
   *
   * @return voidedDateTime
   */
  @Schema(example = "null", description = "The date and time the envelope or template was voided.")
  public String getVoidedDateTime() {
    return voidedDateTime;
  }

  public void setVoidedDateTime(String voidedDateTime) {
    this.voidedDateTime = voidedDateTime;
  }

  public EnvelopeTemplateResult voidedReason(String voidedReason) {
    this.voidedReason = voidedReason;
    return this;
  }

  /**
   * The reason the envelope or template was voided.
   *
   * @return voidedReason
   */
  @Schema(example = "null", description = "The reason the envelope or template was voided.")
  public String getVoidedReason() {
    return voidedReason;
  }

  public void setVoidedReason(String voidedReason) {
    this.voidedReason = voidedReason;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnvelopeTemplateResult envelopeTemplateResult = (EnvelopeTemplateResult) o;
    return Objects.equals(this.allowMarkup, envelopeTemplateResult.allowMarkup)
        && Objects.equals(this.allowReassign, envelopeTemplateResult.allowReassign)
        && Objects.equals(this.allowViewHistory, envelopeTemplateResult.allowViewHistory)
        && Objects.equals(this.asynchronous, envelopeTemplateResult.asynchronous)
        && Objects.equals(this.attachmentsUri, envelopeTemplateResult.attachmentsUri)
        && Objects.equals(this.authoritativeCopy, envelopeTemplateResult.authoritativeCopy)
        && Objects.equals(
            this.authoritativeCopyDefault, envelopeTemplateResult.authoritativeCopyDefault)
        && Objects.equals(this.autoNavigation, envelopeTemplateResult.autoNavigation)
        && Objects.equals(this.brandId, envelopeTemplateResult.brandId)
        && Objects.equals(this.brandLock, envelopeTemplateResult.brandLock)
        && Objects.equals(this.certificateUri, envelopeTemplateResult.certificateUri)
        && Objects.equals(this.completedDateTime, envelopeTemplateResult.completedDateTime)
        && Objects.equals(this.created, envelopeTemplateResult.created)
        && Objects.equals(this.createdDateTime, envelopeTemplateResult.createdDateTime)
        && Objects.equals(this.customFields, envelopeTemplateResult.customFields)
        && Objects.equals(this.customFieldsUri, envelopeTemplateResult.customFieldsUri)
        && Objects.equals(this.declinedDateTime, envelopeTemplateResult.declinedDateTime)
        && Objects.equals(this.deletedDateTime, envelopeTemplateResult.deletedDateTime)
        && Objects.equals(this.deliveredDateTime, envelopeTemplateResult.deliveredDateTime)
        && Objects.equals(this.description, envelopeTemplateResult.description)
        && Objects.equals(this.documents, envelopeTemplateResult.documents)
        && Objects.equals(this.documentsCombinedUri, envelopeTemplateResult.documentsCombinedUri)
        && Objects.equals(this.documentsUri, envelopeTemplateResult.documentsUri)
        && Objects.equals(this.emailBlurb, envelopeTemplateResult.emailBlurb)
        && Objects.equals(this.emailSettings, envelopeTemplateResult.emailSettings)
        && Objects.equals(this.emailSubject, envelopeTemplateResult.emailSubject)
        && Objects.equals(this.enableWetSign, envelopeTemplateResult.enableWetSign)
        && Objects.equals(
            this.enforceSignerVisibility, envelopeTemplateResult.enforceSignerVisibility)
        && Objects.equals(this.envelopeId, envelopeTemplateResult.envelopeId)
        && Objects.equals(this.envelopeIdStamping, envelopeTemplateResult.envelopeIdStamping)
        && Objects.equals(this.envelopeUri, envelopeTemplateResult.envelopeUri)
        && Objects.equals(this.folderId, envelopeTemplateResult.folderId)
        && Objects.equals(this.folderName, envelopeTemplateResult.folderName)
        && Objects.equals(this.folderUri, envelopeTemplateResult.folderUri)
        && Objects.equals(this.initialSentDateTime, envelopeTemplateResult.initialSentDateTime)
        && Objects.equals(this.is21CFRPart11, envelopeTemplateResult.is21CFRPart11)
        && Objects.equals(
            this.isSignatureProviderEnvelope, envelopeTemplateResult.isSignatureProviderEnvelope)
        && Objects.equals(this.lastModified, envelopeTemplateResult.lastModified)
        && Objects.equals(this.lastModifiedDateTime, envelopeTemplateResult.lastModifiedDateTime)
        && Objects.equals(this.lockInformation, envelopeTemplateResult.lockInformation)
        && Objects.equals(this.messageLock, envelopeTemplateResult.messageLock)
        && Objects.equals(this.name, envelopeTemplateResult.name)
        && Objects.equals(this.notification, envelopeTemplateResult.notification)
        && Objects.equals(this.notificationUri, envelopeTemplateResult.notificationUri)
        && Objects.equals(this.owner, envelopeTemplateResult.owner)
        && Objects.equals(this.pageCount, envelopeTemplateResult.pageCount)
        && Objects.equals(this.parentFolderUri, envelopeTemplateResult.parentFolderUri)
        && Objects.equals(this.password, envelopeTemplateResult.password)
        && Objects.equals(this.purgeState, envelopeTemplateResult.purgeState)
        && Objects.equals(this.recipients, envelopeTemplateResult.recipients)
        && Objects.equals(this.recipientsLock, envelopeTemplateResult.recipientsLock)
        && Objects.equals(this.recipientsUri, envelopeTemplateResult.recipientsUri)
        && Objects.equals(this.sentDateTime, envelopeTemplateResult.sentDateTime)
        && Objects.equals(this.shared, envelopeTemplateResult.shared)
        && Objects.equals(this.signerCanSignOnMobile, envelopeTemplateResult.signerCanSignOnMobile)
        && Objects.equals(this.signingLocation, envelopeTemplateResult.signingLocation)
        && Objects.equals(this.status, envelopeTemplateResult.status)
        && Objects.equals(this.statusChangedDateTime, envelopeTemplateResult.statusChangedDateTime)
        && Objects.equals(this.templateId, envelopeTemplateResult.templateId)
        && Objects.equals(this.templatesUri, envelopeTemplateResult.templatesUri)
        && Objects.equals(this.transactionId, envelopeTemplateResult.transactionId)
        && Objects.equals(this.uri, envelopeTemplateResult.uri)
        && Objects.equals(this.useDisclosure, envelopeTemplateResult.useDisclosure)
        && Objects.equals(this.voidedDateTime, envelopeTemplateResult.voidedDateTime)
        && Objects.equals(this.voidedReason, envelopeTemplateResult.voidedReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        allowMarkup,
        allowReassign,
        allowViewHistory,
        asynchronous,
        attachmentsUri,
        authoritativeCopy,
        authoritativeCopyDefault,
        autoNavigation,
        brandId,
        brandLock,
        certificateUri,
        completedDateTime,
        created,
        createdDateTime,
        customFields,
        customFieldsUri,
        declinedDateTime,
        deletedDateTime,
        deliveredDateTime,
        description,
        documents,
        documentsCombinedUri,
        documentsUri,
        emailBlurb,
        emailSettings,
        emailSubject,
        enableWetSign,
        enforceSignerVisibility,
        envelopeId,
        envelopeIdStamping,
        envelopeUri,
        folderId,
        folderName,
        folderUri,
        initialSentDateTime,
        is21CFRPart11,
        isSignatureProviderEnvelope,
        lastModified,
        lastModifiedDateTime,
        lockInformation,
        messageLock,
        name,
        notification,
        notificationUri,
        owner,
        pageCount,
        parentFolderUri,
        password,
        purgeState,
        recipients,
        recipientsLock,
        recipientsUri,
        sentDateTime,
        shared,
        signerCanSignOnMobile,
        signingLocation,
        status,
        statusChangedDateTime,
        templateId,
        templatesUri,
        transactionId,
        uri,
        useDisclosure,
        voidedDateTime,
        voidedReason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnvelopeTemplateResult {\n");

    sb.append("    allowMarkup: ").append(toIndentedString(allowMarkup)).append("\n");
    sb.append("    allowReassign: ").append(toIndentedString(allowReassign)).append("\n");
    sb.append("    allowViewHistory: ").append(toIndentedString(allowViewHistory)).append("\n");
    sb.append("    asynchronous: ").append(toIndentedString(asynchronous)).append("\n");
    sb.append("    attachmentsUri: ").append(toIndentedString(attachmentsUri)).append("\n");
    sb.append("    authoritativeCopy: ").append(toIndentedString(authoritativeCopy)).append("\n");
    sb.append("    authoritativeCopyDefault: ")
        .append(toIndentedString(authoritativeCopyDefault))
        .append("\n");
    sb.append("    autoNavigation: ").append(toIndentedString(autoNavigation)).append("\n");
    sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
    sb.append("    brandLock: ").append(toIndentedString(brandLock)).append("\n");
    sb.append("    certificateUri: ").append(toIndentedString(certificateUri)).append("\n");
    sb.append("    completedDateTime: ").append(toIndentedString(completedDateTime)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    createdDateTime: ").append(toIndentedString(createdDateTime)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    customFieldsUri: ").append(toIndentedString(customFieldsUri)).append("\n");
    sb.append("    declinedDateTime: ").append(toIndentedString(declinedDateTime)).append("\n");
    sb.append("    deletedDateTime: ").append(toIndentedString(deletedDateTime)).append("\n");
    sb.append("    deliveredDateTime: ").append(toIndentedString(deliveredDateTime)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("    documentsCombinedUri: ")
        .append(toIndentedString(documentsCombinedUri))
        .append("\n");
    sb.append("    documentsUri: ").append(toIndentedString(documentsUri)).append("\n");
    sb.append("    emailBlurb: ").append(toIndentedString(emailBlurb)).append("\n");
    sb.append("    emailSettings: ").append(toIndentedString(emailSettings)).append("\n");
    sb.append("    emailSubject: ").append(toIndentedString(emailSubject)).append("\n");
    sb.append("    enableWetSign: ").append(toIndentedString(enableWetSign)).append("\n");
    sb.append("    enforceSignerVisibility: ")
        .append(toIndentedString(enforceSignerVisibility))
        .append("\n");
    sb.append("    envelopeId: ").append(toIndentedString(envelopeId)).append("\n");
    sb.append("    envelopeIdStamping: ").append(toIndentedString(envelopeIdStamping)).append("\n");
    sb.append("    envelopeUri: ").append(toIndentedString(envelopeUri)).append("\n");
    sb.append("    folderId: ").append(toIndentedString(folderId)).append("\n");
    sb.append("    folderName: ").append(toIndentedString(folderName)).append("\n");
    sb.append("    folderUri: ").append(toIndentedString(folderUri)).append("\n");
    sb.append("    initialSentDateTime: ")
        .append(toIndentedString(initialSentDateTime))
        .append("\n");
    sb.append("    is21CFRPart11: ").append(toIndentedString(is21CFRPart11)).append("\n");
    sb.append("    isSignatureProviderEnvelope: ")
        .append(toIndentedString(isSignatureProviderEnvelope))
        .append("\n");
    sb.append("    lastModified: ").append(toIndentedString(lastModified)).append("\n");
    sb.append("    lastModifiedDateTime: ")
        .append(toIndentedString(lastModifiedDateTime))
        .append("\n");
    sb.append("    lockInformation: ").append(toIndentedString(lockInformation)).append("\n");
    sb.append("    messageLock: ").append(toIndentedString(messageLock)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    notification: ").append(toIndentedString(notification)).append("\n");
    sb.append("    notificationUri: ").append(toIndentedString(notificationUri)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    pageCount: ").append(toIndentedString(pageCount)).append("\n");
    sb.append("    parentFolderUri: ").append(toIndentedString(parentFolderUri)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    purgeState: ").append(toIndentedString(purgeState)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    recipientsLock: ").append(toIndentedString(recipientsLock)).append("\n");
    sb.append("    recipientsUri: ").append(toIndentedString(recipientsUri)).append("\n");
    sb.append("    sentDateTime: ").append(toIndentedString(sentDateTime)).append("\n");
    sb.append("    shared: ").append(toIndentedString(shared)).append("\n");
    sb.append("    signerCanSignOnMobile: ")
        .append(toIndentedString(signerCanSignOnMobile))
        .append("\n");
    sb.append("    signingLocation: ").append(toIndentedString(signingLocation)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusChangedDateTime: ")
        .append(toIndentedString(statusChangedDateTime))
        .append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("    templatesUri: ").append(toIndentedString(templatesUri)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    useDisclosure: ").append(toIndentedString(useDisclosure)).append("\n");
    sb.append("    voidedDateTime: ").append(toIndentedString(voidedDateTime)).append("\n");
    sb.append("    voidedReason: ").append(toIndentedString(voidedReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
