/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.sharding;

import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;

public final class ShardingNode {
    public static final String ROOT = "sharding";
    static final String INSTANCE_APPENDIX = "instance";
    public static final String INSTANCE = "sharding/%s/instance";
    static final String RUNNING_APPENDIX = "running";
    static final String RUNNING = "sharding/%s/running";
    static final String MISFIRE = "sharding/%s/misfire";
    static final String DISABLED = "sharding/%s/disabled";
    static final String LEADER_ROOT = "leader/sharding";
    static final String NECESSARY = "leader/sharding/necessary";
    static final String PROCESSING = "leader/sharding/processing";
    private final JobNodePath jobNodePath;

    public ShardingNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    public static String getInstanceNode(int item) {
        return String.format(INSTANCE, item);
    }

    public static String getRunningNode(int item) {
        return String.format(RUNNING, item);
    }

    static String getMisfireNode(int item) {
        return String.format(MISFIRE, item);
    }

    static String getDisabledNode(int item) {
        return String.format(DISABLED, item);
    }

    public Integer getItemByRunningItemPath(String path) {
        if (!this.isRunningItemPath(path)) {
            return null;
        }
        return Integer.parseInt(path.substring(this.jobNodePath.getFullPath(ROOT).length() + 1, path.lastIndexOf(RUNNING_APPENDIX) - 1));
    }

    private boolean isRunningItemPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(RUNNING_APPENDIX);
    }
}

