/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.sharding;

import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceNode;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.server.ServerNode;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class ShardingListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ConfigurationNode configNode;
    private final InstanceNode instanceNode;
    private final ServerNode serverNode;
    private final ShardingService shardingService;

    public ShardingListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configNode = new ConfigurationNode(jobName);
        this.instanceNode = new InstanceNode(jobName);
        this.serverNode = new ServerNode(jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new ShardingTotalCountChangedJobListener());
        this.addDataListener(new ListenServersChangedJobListener());
    }

    class ListenServersChangedJobListener
    extends AbstractJobListener {
        ListenServersChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (!JobRegistry.getInstance().isShutdown(ShardingListenerManager.this.jobName) && (this.isInstanceChange(eventType, path) || this.isServerChange(path))) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
            }
        }

        private boolean isInstanceChange(TreeCacheEvent.Type eventType, String path) {
            return ShardingListenerManager.this.instanceNode.isInstancePath(path) && TreeCacheEvent.Type.NODE_UPDATED != eventType;
        }

        private boolean isServerChange(String path) {
            return ShardingListenerManager.this.serverNode.isServerPath(path);
        }
    }

    class ShardingTotalCountChangedJobListener
    extends AbstractJobListener {
        ShardingTotalCountChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            int newShardingTotalCount;
            if (ShardingListenerManager.this.configNode.isConfigPath(path) && 0 != JobRegistry.getInstance().getCurrentShardingTotalCount(ShardingListenerManager.this.jobName) && (newShardingTotalCount = LiteJobConfigurationGsonFactory.fromJson(data).getTypeConfig().getCoreConfig().getShardingTotalCount()) != JobRegistry.getInstance().getCurrentShardingTotalCount(ShardingListenerManager.this.jobName)) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
                JobRegistry.getInstance().setCurrentShardingTotalCount(ShardingListenerManager.this.jobName, newShardingTotalCount);
            }
        }
    }
}

