/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.schedule;

import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.election.LeaderService;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceService;
import com.dangdang.ddframe.job.lite.internal.listener.ListenerManager;
import com.dangdang.ddframe.job.lite.internal.monitor.MonitorService;
import com.dangdang.ddframe.job.lite.internal.reconcile.ReconcileService;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobTriggerListener;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public final class SchedulerFacade {
    private final String jobName;
    private final ConfigurationService configService;
    private final LeaderService leaderService;
    private final ServerService serverService;
    private final InstanceService instanceService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;
    private final MonitorService monitorService;
    private final ReconcileService reconcileService;
    private ListenerManager listenerManager;

    public SchedulerFacade(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.configService = new ConfigurationService(regCenter, jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.monitorService = new MonitorService(regCenter, jobName);
        this.reconcileService = new ReconcileService(regCenter, jobName);
    }

    public SchedulerFacade(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners) {
        this.jobName = jobName;
        this.configService = new ConfigurationService(regCenter, jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.monitorService = new MonitorService(regCenter, jobName);
        this.reconcileService = new ReconcileService(regCenter, jobName);
        this.listenerManager = new ListenerManager(regCenter, jobName, elasticJobListeners);
    }

    public JobTriggerListener newJobTriggerListener() {
        return new JobTriggerListener(this.executionService, this.shardingService);
    }

    public LiteJobConfiguration updateJobConfiguration(LiteJobConfiguration liteJobConfig) {
        this.configService.persist(liteJobConfig);
        return this.configService.load(false);
    }

    public void registerStartUpInfo(boolean enabled) {
        this.listenerManager.startAllListeners();
        this.leaderService.electLeader();
        this.serverService.persistOnline(enabled);
        this.instanceService.persistOnline();
        this.shardingService.setReshardingFlag();
        this.monitorService.listen();
        if (!this.reconcileService.isRunning()) {
            this.reconcileService.startAsync();
        }
    }

    public void shutdownInstance() {
        if (this.leaderService.isLeader()) {
            this.leaderService.removeLeader();
        }
        this.monitorService.close();
        if (this.reconcileService.isRunning()) {
            this.reconcileService.stopAsync();
        }
        JobRegistry.getInstance().shutdown(this.jobName);
    }
}

