/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.executor.type;

import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.config.script.ScriptJobConfiguration;
import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.dangdang.ddframe.job.executor.AbstractElasticJobExecutor;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.util.json.GsonFactory;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;

public final class ScriptJobExecutor
extends AbstractElasticJobExecutor {
    public ScriptJobExecutor(JobFacade jobFacade) {
        super(jobFacade);
    }

    @Override
    protected void process(ShardingContext shardingContext) {
        String scriptCommandLine = ((ScriptJobConfiguration)this.getJobRootConfig().getTypeConfig()).getScriptCommandLine();
        if (Strings.isNullOrEmpty((String)scriptCommandLine)) {
            throw new JobConfigurationException("Cannot find script command line for job '%s', job is not executed.", shardingContext.getJobName());
        }
        this.executeScript(shardingContext, scriptCommandLine);
    }

    private void executeScript(ShardingContext shardingContext, String scriptCommandLine) {
        CommandLine commandLine = CommandLine.parse((String)scriptCommandLine);
        commandLine.addArgument(GsonFactory.getGson().toJson((Object)shardingContext), false);
        try {
            new DefaultExecutor().execute(commandLine);
        }
        catch (IOException ex) {
            throw new JobConfigurationException("Execute script failure.", new Object[]{ex});
        }
    }
}

