/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelPackage;
import info.leadinglight.umljavadoclet.model.ModelRel;
import info.leadinglight.umljavadoclet.printer.Printer;

public class ModelPrinter
extends Printer {
    private final Model _model;

    public ModelPrinter(Model model) {
        this._model = model;
    }

    public void generate() {
        this.printClasses();
        this.printPackages();
    }

    private void printClasses() {
        for (ModelClass modelClass : this._model.classes()) {
            if (!modelClass.isInternal()) continue;
            this.printClass(modelClass);
            for (ModelRel rel : modelClass.relationships()) {
                this.printRel(modelClass, rel);
            }
        }
    }

    private void printClass(ModelClass modelClass) {
        this.println("Class: " + modelClass.fullName());
    }

    private void printRel(ModelClass modelClass, ModelRel rel) {
        this.indent(1);
        boolean fromSource = rel.source() == modelClass;
        this.printKind(rel.kind(), fromSource);
        this.print(": ");
        this.print(fromSource ? rel.destination().fullName() : rel.source().fullName());
        if (rel.destinationRole() != null) {
            this.print(" " + rel.destinationRole());
        }
        if (rel.destinationCardinality() != null) {
            this.print(" ");
            this.printMultiplicity(rel.destinationCardinality());
        }
        if (rel.destinationVisibility() != null) {
            this.print(" ");
            this.printVisibility(rel.destinationVisibility());
        }
        this.newline();
    }

    private void printKind(ModelRel.Kind kind, boolean fromSource) {
        switch (kind) {
            case GENERALIZATION: {
                this.print(fromSource ? "extends" : "extended by");
                return;
            }
            case REALIZATION: {
                this.print(fromSource ? "implements" : "implemented by");
                return;
            }
            case DIRECTED_ASSOCIATION: {
                this.print(fromSource ? "has" : "had by");
                return;
            }
            case DEPENDENCY: {
                this.print(fromSource ? "uses" : "used by");
            }
        }
    }

    private void printMultiplicity(ModelRel.Multiplicity mult) {
        switch (mult) {
            case ONE: {
                this.print("one");
                return;
            }
            case ZERO_OR_ONE: {
                this.print("zero or one");
                return;
            }
            case MANY: {
                this.print("many");
            }
        }
    }

    private void printVisibility(ModelRel.Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                this.print("public");
                return;
            }
            case PROTECTED: {
                this.print("protected");
                return;
            }
            case PACKAGE: {
                this.print("package");
                return;
            }
            case PRIVATE: {
                this.print("private");
            }
        }
    }

    private void printPackages() {
        for (ModelPackage modelPackage : this._model.packages()) {
            this.printPackage(modelPackage);
        }
    }

    private void printPackage(ModelPackage modelPackage) {
        this.println("Package: " + modelPackage.fullName());
        for (ModelPackage dependency : modelPackage.dependencies()) {
            this.println(1, "depends on: " + dependency.fullName());
        }
        for (ModelPackage dependent : modelPackage.dependents()) {
            this.println(1, "is dependency for: " + dependent.fullName());
        }
        for (ModelClass modelClass : modelPackage.classes()) {
            this.indent(1);
            this.printClass(modelClass);
        }
    }
}

