/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

public class DiagramOptions {
    private LineType _lineType = LineType.ORTHO;
    private static final String OPTION_LINE_TYPE = "-linetype";
    private static final String OPTION_LINE_TYPE_ORTHO = "ortho";
    private static final String OPTION_LINE_TYPE_POLYLINE = "polyline";
    private static final String OPTION_LINE_TYPE_SPLINE = "spline";
    private Visibility _dependenciesVisibility = Visibility.PUBLIC;
    private static final String OPTION_DEPENDENCIES = "-dependencies";
    private static final String OPTION_DEPENDENCIES_PUBLIC = "public";
    private static final String OPTION_DEPENDENCIES_PROTECTED = "protected";
    private static final String OPTION_DEPENDENCIES_PACKAGE = "package";
    private static final String OPTION_DEPENDENCIES_PRIVATE = "private";

    public LineType getLineType() {
        return this._lineType;
    }

    public void setLineType(LineType lineType) {
        this._lineType = lineType;
    }

    public void setLineType(String[] option) {
        if (option[0].equals(OPTION_LINE_TYPE)) {
            if (option[1].equals(OPTION_LINE_TYPE_ORTHO)) {
                this.setLineType(LineType.ORTHO);
            } else if (option[1].equals(OPTION_LINE_TYPE_POLYLINE)) {
                this.setLineType(LineType.POLYLINE);
            } else if (option[1].equals(OPTION_LINE_TYPE_SPLINE)) {
                this.setLineType(LineType.SPLINE);
            }
        }
    }

    public static String checkLineType(String[] option) {
        if (option[0].equals(OPTION_LINE_TYPE) && !option[1].equals(OPTION_LINE_TYPE_ORTHO) && !option[1].equals(OPTION_LINE_TYPE_POLYLINE) && !option[1].equals(OPTION_LINE_TYPE_SPLINE)) {
            return "Invalid line type: ortho (default), polyline, or spline).";
        }
        return null;
    }

    public Visibility getDependenciesVisibility() {
        return this._dependenciesVisibility;
    }

    public void setDependenciesVisibility(Visibility visibility) {
        this._dependenciesVisibility = visibility;
    }

    public void setDependenciesVisibility(String[] option) {
        if (option[0].equals(OPTION_DEPENDENCIES)) {
            if (option[1].equals(OPTION_DEPENDENCIES_PUBLIC)) {
                this.setDependenciesVisibility(Visibility.PUBLIC);
            } else if (option[1].equals(OPTION_DEPENDENCIES_PROTECTED)) {
                this.setDependenciesVisibility(Visibility.PROTECTED);
            } else if (option[1].equals(OPTION_DEPENDENCIES_PACKAGE)) {
                this.setDependenciesVisibility(Visibility.PACKAGE);
            } else if (option[1].equals(OPTION_DEPENDENCIES_PRIVATE)) {
                this.setDependenciesVisibility(Visibility.PRIVATE);
            }
        }
    }

    public static String checkDependenciesVisibility(String[] option) {
        if (!(!option[0].equals(OPTION_DEPENDENCIES) || option[1].equals(OPTION_DEPENDENCIES_PUBLIC) || option[1].equals(OPTION_DEPENDENCIES_PROTECTED) || option[1].equals(OPTION_DEPENDENCIES_PACKAGE) || option[1].equals(OPTION_DEPENDENCIES_PRIVATE))) {
            return "Invalid dependencies: public (default), protected, package, or private.";
        }
        return null;
    }

    public void set(String[][] options) {
        for (String[] option : options) {
            this.setLineType(option);
            this.setDependenciesVisibility(option);
        }
    }

    public static boolean isValidOption(String option) {
        return option.equals(OPTION_LINE_TYPE) || option.equals(OPTION_DEPENDENCIES);
    }

    public static int getOptionLength(String option) {
        if (option.equals(OPTION_LINE_TYPE)) {
            return 2;
        }
        if (option.equals(OPTION_DEPENDENCIES)) {
            return 2;
        }
        return 0;
    }

    public static String checkOption(String[] option) {
        String error = DiagramOptions.checkLineType(option);
        if (error != null && error.length() > 0) {
            return error;
        }
        return null;
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;

    }

    public static enum LineType {
        SPLINE,
        POLYLINE,
        ORTHO;

    }
}

