/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelRel;
import info.leadinglight.umljavadoclet.printer.DiagramOptions;
import info.leadinglight.umljavadoclet.printer.PumlDiagramPrinter;
import java.util.ArrayList;
import java.util.List;

public class ContextDiagramPrinter
extends PumlDiagramPrinter {
    private final ModelClass _contextClass;
    private final List<ModelClass> _classes = new ArrayList<ModelClass>();

    public ContextDiagramPrinter(Model model, ModelClass contextClass, DiagramOptions options) {
        super(model, options);
        this._contextClass = contextClass;
    }

    public void generate() {
        this.start();
        this.noPackagesOption();
        this.addContextClass(this._contextClass);
        for (ModelRel rel : this._contextClass.relationships()) {
            this.addRelationship(rel);
            this.newline();
        }
        this.end();
    }

    private void addContextClass(ModelClass modelClass) {
        String filepath = this.classFilepath(modelClass, modelClass);
        this.classDefinition(modelClass, true, filepath, null, true, true, true, false, true);
        this._classes.add(modelClass);
    }

    private void addRelationship(ModelRel rel) {
        ModelClass otherClass;
        ModelClass modelClass = otherClass = rel.source() != this._contextClass ? rel.source() : rel.destination();
        if (!otherClass.fullName().startsWith("java.util.") && this.isRelationshipVisible(rel)) {
            if (!this._classes.contains(otherClass)) {
                String filepath = null;
                if (otherClass.modelPackage() != null) {
                    filepath = this.classFilepath(this._contextClass, otherClass);
                }
                if (otherClass.modelPackage() == this._contextClass.modelPackage()) {
                    this.classDefinitionNoDetail(otherClass, true, filepath, null);
                } else if (otherClass.isInternal()) {
                    this.classDefinitionNoDetail(otherClass, true, filepath, "white");
                } else {
                    this.classDefinitionNoDetail(otherClass, true, filepath, "lightgrey");
                }
                this._classes.add(otherClass);
            }
            this.relationship(rel);
        }
    }
}

