/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.model;

import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelRel;
import java.util.ArrayList;
import java.util.List;

public class RelFilter {
    private final List<ModelRel> _rels;

    public RelFilter() {
        this._rels = new ArrayList<ModelRel>();
    }

    public RelFilter(List<ModelRel> rels) {
        this._rels = rels;
    }

    public boolean isEmpty() {
        return this._rels.isEmpty();
    }

    public List<ModelRel> all() {
        return this._rels;
    }

    public ModelRel first() {
        return this._rels.size() > 0 ? this._rels.get(0) : null;
    }

    public List<ModelClass> sourceClasses() {
        ArrayList<ModelClass> classes = new ArrayList<ModelClass>();
        for (ModelRel rel : this._rels) {
            classes.add(rel.source());
        }
        return classes;
    }

    public List<ModelClass> destinationClasses() {
        ArrayList<ModelClass> classes = new ArrayList<ModelClass>();
        for (ModelRel rel : this._rels) {
            classes.add(rel.destination());
        }
        return classes;
    }

    public void add(ModelRel rel) {
        this._rels.add(rel);
    }

    public RelFilter source(ModelClass source) {
        RelFilter filter = new RelFilter();
        for (ModelRel rel : this._rels) {
            if (rel.source() != source) continue;
            filter.add(rel);
        }
        return filter;
    }

    public RelFilter destination(ModelClass dest) {
        RelFilter filter = new RelFilter();
        for (ModelRel rel : this._rels) {
            if (rel.destination() != dest) continue;
            filter.add(rel);
        }
        return filter;
    }

    public RelFilter kind(ModelRel.Kind kind) {
        RelFilter filter = new RelFilter();
        for (ModelRel rel : this._rels) {
            if (rel.kind() != kind) continue;
            filter.add(rel);
        }
        return filter;
    }

    public RelFilter between(ModelClass source, ModelClass dest) {
        return this.source(source).destination(dest);
    }
}

