/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.model;

import info.leadinglight.umljavadoclet.model.ModelClass;

public class ModelRel {
    private final Kind _kind;
    private final ModelClass _src;
    private final ModelClass _dest;
    private final String _srcRole;
    private final Multiplicity _srcCardinality;
    private Visibility _srcVisibility;

    public ModelRel(Kind kind, ModelClass src, ModelClass dest) {
        this._kind = kind;
        this._src = src;
        this._dest = dest;
        this._srcRole = null;
        this._srcCardinality = null;
        this._srcVisibility = null;
    }

    public ModelRel(Kind kind, ModelClass src, ModelClass dest, Visibility srcVisibility) {
        this._kind = kind;
        this._src = src;
        this._dest = dest;
        this._srcRole = null;
        this._srcCardinality = null;
        this._srcVisibility = srcVisibility;
    }

    public ModelRel(Kind kind, ModelClass src, ModelClass dest, String srcRole) {
        this._kind = kind;
        this._src = src;
        this._dest = dest;
        this._srcRole = srcRole;
        this._srcCardinality = null;
        this._srcVisibility = null;
    }

    public ModelRel(Kind kind, ModelClass src, ModelClass dest, String srcRole, Multiplicity srcCardinality) {
        this._kind = kind;
        this._src = src;
        this._dest = dest;
        this._srcRole = srcRole;
        this._srcCardinality = srcCardinality;
        this._srcVisibility = null;
    }

    public Kind kind() {
        return this._kind;
    }

    public ModelClass source() {
        return this._src;
    }

    public ModelClass destination() {
        return this._dest;
    }

    public String destinationRole() {
        return this._srcRole;
    }

    public Multiplicity destinationCardinality() {
        return this._srcCardinality;
    }

    public Visibility destinationVisibility() {
        return this._srcVisibility;
    }

    public void changeVisibility(Visibility visibility) {
        this._srcVisibility = visibility;
    }

    public boolean isVisible(Visibility visibility) {
        if (this._srcVisibility == null) {
            return true;
        }
        if (visibility == Visibility.PUBLIC && this._srcVisibility == Visibility.PUBLIC) {
            return true;
        }
        if (visibility == Visibility.PROTECTED && (this._srcVisibility == Visibility.PUBLIC || this._srcVisibility == Visibility.PROTECTED)) {
            return true;
        }
        if (visibility == Visibility.PACKAGE && (this._srcVisibility == Visibility.PUBLIC || this._srcVisibility == Visibility.PROTECTED || this._srcVisibility == Visibility.PACKAGE)) {
            return true;
        }
        return visibility == Visibility.PRIVATE;
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;

    }

    public static enum Multiplicity {
        ZERO_OR_ONE,
        ONE,
        MANY;

    }

    public static enum Kind {
        DIRECTED_ASSOCIATION,
        GENERALIZATION,
        REALIZATION,
        DEPENDENCY;

    }
}

