/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.model;

import com.sun.javadoc.PackageDoc;
import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelRel;
import java.util.ArrayList;
import java.util.List;

public class ModelPackage {
    private final Model _model;
    private final PackageDoc _packageDoc;
    private final List<ModelClass> _classes = new ArrayList<ModelClass>();
    private final List<ModelPackage> _dependentPackages = new ArrayList<ModelPackage>();
    private final List<ModelPackage> _dependencyPackages = new ArrayList<ModelPackage>();

    public ModelPackage(Model model, PackageDoc packageDoc) {
        this._model = model;
        this._packageDoc = packageDoc;
    }

    public void map() {
        this.mapRelationships();
    }

    public String fullName() {
        return ModelPackage.fullName(this._packageDoc);
    }

    public String qualifiedName() {
        return ModelPackage.fullName(this._packageDoc);
    }

    public List<ModelClass> classes() {
        return this._classes;
    }

    public List<ModelPackage> dependencies() {
        return this._dependencyPackages;
    }

    public List<ModelPackage> dependents() {
        return this._dependentPackages;
    }

    public static String fullName(PackageDoc packageDoc) {
        return packageDoc.name();
    }

    public boolean isChildPackage(ModelPackage parentPackage) {
        if (parentPackage != this) {
            if (this.qualifiedName().startsWith(parentPackage.qualifiedName())) {
                String thisPath = this.qualifiedName().substring(parentPackage.qualifiedName().length() + 1);
                return !thisPath.contains(".");
            }
            return false;
        }
        return false;
    }

    public String parentPackageFullName() {
        return this.qualifiedName().substring(0, this.qualifiedName().lastIndexOf("."));
    }

    public void addClass(ModelClass modelClass) {
        if (!this._classes.contains(modelClass)) {
            this._classes.add(modelClass);
        }
    }

    private void mapRelationships() {
        for (ModelClass modelClass : this._classes) {
            for (ModelRel rel : modelClass.relationships()) {
                if (rel.source() == modelClass) {
                    ModelClass dest = rel.destination();
                    ModelPackage destPackage = dest.modelPackage();
                    if (destPackage == null || destPackage == this || this._dependencyPackages.contains(destPackage)) continue;
                    this._dependencyPackages.add(destPackage);
                    continue;
                }
                ModelClass src = rel.source();
                ModelPackage srcPackage = src.modelPackage();
                if (srcPackage == null || srcPackage == this || this._dependentPackages.contains(srcPackage)) continue;
                this._dependentPackages.add(srcPackage);
            }
        }
    }
}

