/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.model;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelPackage;
import info.leadinglight.umljavadoclet.model.ModelRel;
import info.leadinglight.umljavadoclet.model.RelFilter;
import java.util.ArrayList;
import java.util.List;

public class ModelClass {
    private final Model _model;
    private final Type _type;
    private final ClassDoc _classDoc;
    private final List<ModelClass> _params = new ArrayList<ModelClass>();
    private final List<ModelRel> _rels = new ArrayList<ModelRel>();
    private final List<Field> _fields = new ArrayList<Field>();
    private final List<Constructor> _constructors = new ArrayList<Constructor>();
    private final List<Method> _methods = new ArrayList<Method>();
    private final boolean _isInternal;

    public ModelClass(Model model, Type type, boolean isInternal) {
        this._model = model;
        this._type = type;
        this._isInternal = isInternal;
        this._classDoc = this._type.asClassDoc();
    }

    public void map() {
        this.mapParameters();
        if (this.isInternal()) {
            this.mapInternals();
            this.mapRelationships();
        }
    }

    public String fullName() {
        return ModelClass.fullName(this._type);
    }

    public String fullNameWithoutParameters() {
        return ModelClass.fullNameWithoutParameters(this._type);
    }

    public String shortName() {
        return ModelClass.shortName(this._type);
    }

    public String shortNameWithoutParameters() {
        return ModelClass.shortNameWithoutParameters(this._type);
    }

    public String packageName() {
        return this._classDoc.containingPackage().name();
    }

    public static String fullName(Type type) {
        String fullName = ModelClass.fullNameWithoutParameters(type);
        String params = ModelClass.buildParameterString(type);
        if (params != null && params.length() > 0) {
            fullName = fullName + "<" + params + ">";
        }
        return fullName;
    }

    public static String fullNameWithoutParameters(Type type) {
        String fullName = "";
        ClassDoc classDoc = type.asClassDoc();
        fullName = classDoc != null ? classDoc.containingPackage().name() + "." + ModelClass.shortNameWithoutParameters(type) : type.qualifiedTypeName();
        return fullName;
    }

    public static String shortName(Type type) {
        String shortName = ModelClass.shortNameWithoutParameters(type);
        String params = ModelClass.buildParameterString(type);
        if (params != null && params.length() > 0) {
            shortName = shortName + "<" + params + ">";
        }
        return shortName;
    }

    public static String shortNameWithoutParameters(Type type) {
        ClassDoc classDoc = type.asClassDoc();
        if (classDoc != null) {
            if (ModelClass.isInnerClass(classDoc)) {
                return classDoc.containingClass().simpleTypeName() + "." + type.simpleTypeName();
            }
            return classDoc.simpleTypeName();
        }
        return type.simpleTypeName();
    }

    public ClassType type() {
        if (this._classDoc.isInterface()) {
            return ClassType.INTERFACE;
        }
        if (this._classDoc.isEnum()) {
            return ClassType.ENUM;
        }
        return ClassType.CLASS;
    }

    public List<String> annotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        for (AnnotationDesc annotation : this._classDoc.annotations()) {
            annotations.add(annotation.annotationType().simpleTypeName());
        }
        return annotations;
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public boolean isExternal() {
        return !this.isInternal();
    }

    public boolean isParameterized() {
        return this._type.asParameterizedType() != null;
    }

    public boolean isInnerClass() {
        return ModelClass.isInnerClass(this._classDoc);
    }

    public static boolean isInnerClass(ClassDoc classDoc) {
        return classDoc.containingClass() != null;
    }

    public List<String> parameters() {
        return ModelClass.buildParameters(this._type);
    }

    public List<ModelClass> parameterClasses() {
        return this._params;
    }

    public boolean isCollectionClass() {
        return this._type.qualifiedTypeName().equals("java.util.List") || this._type.qualifiedTypeName().equals("java.util.Map");
    }

    public ModelPackage modelPackage() {
        String packageName = this._classDoc.containingPackage().name();
        ModelPackage modelPackage = this._model.modelPackage(packageName);
        return modelPackage;
    }

    public List<ModelRel> relationships() {
        return this._rels;
    }

    public RelFilter relationshipsFilter() {
        return new RelFilter(this._rels);
    }

    public ModelClass superclass() {
        ModelRel rel = this.relationshipsFilter().source(this).kind(ModelRel.Kind.GENERALIZATION).first();
        return rel != null ? rel.destination() : null;
    }

    public List<ModelClass> interfaces() {
        return this.relationshipsFilter().source(this).kind(ModelRel.Kind.REALIZATION).destinationClasses();
    }

    public List<ModelRel> sourceAssociations() {
        return this.relationshipsFilter().source(this).kind(ModelRel.Kind.DIRECTED_ASSOCIATION).all();
    }

    public List<ModelRel> destinationAssociations() {
        return this.relationshipsFilter().destination(this).kind(ModelRel.Kind.DIRECTED_ASSOCIATION).all();
    }

    public List<ModelClass> dependencies() {
        return this.relationshipsFilter().source(this).kind(ModelRel.Kind.DEPENDENCY).destinationClasses();
    }

    public List<ModelClass> dependents() {
        return this.relationshipsFilter().destination(this).kind(ModelRel.Kind.DEPENDENCY).sourceClasses();
    }

    public boolean hasRelationshipWith(ModelClass dest) {
        return this.relationshipsFilter().source(this).destination(dest).first() != null;
    }

    public ModelRel dependencyWith(ModelClass dest) {
        return this.relationshipsFilter().source(this).destination(dest).kind(ModelRel.Kind.DEPENDENCY).first();
    }

    public boolean hasDependencyWith(ModelClass dest) {
        return this.dependencyWith(dest) != null;
    }

    public List<Field> fields() {
        return this._fields;
    }

    public List<Constructor> constructors() {
        return this._constructors;
    }

    public List<Method> methods() {
        return this._methods;
    }

    public void addRelationship(ModelRel rel) {
        this._rels.add(rel);
    }

    private void mapInternals() {
        this.mapFields();
        this.mapConstructors();
        this.mapMethods();
    }

    private void mapRelationships() {
        this.mapFieldAssociations();
        this.mapSuperclass();
        this.mapInterfaces();
        this.mapConstructorDependencies();
        this.mapMethodDependencies();
    }

    private void mapParameters() {
        ParameterizedType paramType = this._type.asParameterizedType();
        if (paramType != null) {
            for (Type type : paramType.typeArguments()) {
                String typeName = type.qualifiedTypeName();
                if (typeName.startsWith("java.lang.") || type.isPrimitive()) continue;
                ModelClass param = this._model.createClassIfNotExists(type);
                this._params.add(param);
            }
        }
    }

    private void mapSuperclass() {
        String superclassName;
        Type superclassType = this._classDoc.superclassType();
        if (superclassType != null && !(superclassName = superclassType.qualifiedTypeName()).equals("java.lang.Object") && !superclassName.equals("java.lang.Enum")) {
            ModelClass dest = this._model.createClassIfNotExists(superclassType);
            ModelRel rel = new ModelRel(ModelRel.Kind.GENERALIZATION, this, dest);
            this.mapSourceRel(rel);
            this.mapParamDependencies(dest);
        }
    }

    private void mapInterfaces() {
        for (Type interfaceType : this._classDoc.interfaceTypes()) {
            ModelClass dest = this._model.createClassIfNotExists(interfaceType);
            ModelRel.Kind kind = this._classDoc.isInterface() ? ModelRel.Kind.GENERALIZATION : ModelRel.Kind.REALIZATION;
            ModelRel rel = new ModelRel(kind, this, dest);
            this.mapSourceRel(rel);
            this.mapParamDependencies(dest);
        }
    }

    private void mapFieldAssociations() {
        for (FieldDoc fieldDoc : this._classDoc.fields(false)) {
            Type type = fieldDoc.type();
            String typeName = type.qualifiedTypeName();
            if (type.simpleTypeName().equals("void") || typeName.startsWith("java.lang.") || type.isPrimitive()) continue;
            ModelClass dest = this._model.createClassIfNotExists(type);
            ModelRel rel = new ModelRel(ModelRel.Kind.DIRECTED_ASSOCIATION, this, dest, fieldDoc.name());
            this.mapSourceRel(rel);
            this.mapParamAssociations(fieldDoc, dest);
            this.mapParamDependencies(dest);
        }
    }

    private void mapParamAssociations(FieldDoc fieldDoc, ModelClass modelClass) {
        if (modelClass.isParameterized() && modelClass.isCollectionClass()) {
            for (ModelClass param : modelClass.parameterClasses()) {
                ModelRel rel = new ModelRel(ModelRel.Kind.DIRECTED_ASSOCIATION, this, param, fieldDoc.name(), ModelRel.Multiplicity.MANY);
                this.mapSourceRel(rel);
            }
        }
    }

    private void mapConstructorDependencies() {
        for (ConstructorDoc constructorDoc : this._classDoc.constructors(false)) {
            for (Parameter param : constructorDoc.parameters()) {
                Type type = param.type();
                this.mapTypeDependency(type, constructorDoc.isPublic(), constructorDoc.isProtected(), constructorDoc.isPackagePrivate(), constructorDoc.isPrivate());
            }
        }
    }

    private void mapMethodDependencies() {
        for (MethodDoc methodDoc : this._classDoc.methods(false)) {
            for (Parameter param : methodDoc.parameters()) {
                Type type = param.type();
                this.mapTypeDependency(type, methodDoc.isPublic(), methodDoc.isProtected(), methodDoc.isPackagePrivate(), methodDoc.isPrivate());
            }
            Type returnType = methodDoc.returnType();
            this.mapTypeDependency(returnType, methodDoc.isPublic(), methodDoc.isProtected(), methodDoc.isPackagePrivate(), methodDoc.isPrivate());
        }
    }

    private void mapTypeDependency(Type type, boolean isPublic, boolean isProtected, boolean isPackage, boolean isPrivate) {
        String typeName = type.qualifiedTypeName();
        if (!(type.simpleTypeName().equals("void") || typeName.startsWith("java.lang.") || type.isPrimitive())) {
            ModelClass dest = this._model.createClassIfNotExists(type);
            ModelRel.Visibility visibility = null;
            if (isPublic) {
                visibility = ModelRel.Visibility.PUBLIC;
            } else if (isProtected) {
                visibility = ModelRel.Visibility.PROTECTED;
            } else if (isPackage) {
                visibility = ModelRel.Visibility.PACKAGE;
            } else if (isPrivate) {
                visibility = ModelRel.Visibility.PRIVATE;
            }
            if (this != dest && visibility != null && this.hasDependencyWith(dest)) {
                ModelRel depedencyWith = this.dependencyWith(dest);
                if (visibility == ModelRel.Visibility.PUBLIC) {
                    depedencyWith.changeVisibility(visibility);
                } else if (visibility == ModelRel.Visibility.PROTECTED) {
                    if (depedencyWith.destinationVisibility() != ModelRel.Visibility.PUBLIC) {
                        depedencyWith.changeVisibility(visibility);
                    }
                } else if (visibility == ModelRel.Visibility.PACKAGE && depedencyWith.destinationVisibility() != ModelRel.Visibility.PUBLIC && depedencyWith.destinationVisibility() != ModelRel.Visibility.PROTECTED) {
                    depedencyWith.changeVisibility(visibility);
                }
            }
            if (this != dest && !this.hasRelationshipWith(dest)) {
                ModelRel rel = new ModelRel(ModelRel.Kind.DEPENDENCY, this, dest, visibility);
                this.mapSourceRel(rel);
            }
            this.mapParamDependencies(dest);
        }
    }

    private void mapParamDependencies(ModelClass modelClass) {
        if (modelClass.isParameterized()) {
            for (ModelClass param : modelClass.parameterClasses()) {
                if (this.hasRelationshipWith(param)) continue;
                ModelRel paramRel = new ModelRel(ModelRel.Kind.DEPENDENCY, this, param);
                this.mapSourceRel(paramRel);
            }
        }
    }

    private void mapFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldDoc fieldDoc : this._classDoc.fields(false)) {
            Field mappedField = new Field(fieldDoc.name(), ModelClass.shortName(fieldDoc.type()), this.mapVisibility((ProgramElementDoc)fieldDoc), fieldDoc.isStatic());
            fields.add(mappedField);
        }
        this.orderVisibility(fields, this._fields);
    }

    private void mapConstructors() {
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        for (ConstructorDoc consDoc : this._classDoc.constructors(false)) {
            ArrayList<MethodParameter> params = new ArrayList<MethodParameter>();
            for (Parameter param : consDoc.parameters()) {
                params.add(new MethodParameter(ModelClass.shortName(param.type()), param.name()));
            }
            Constructor constructor = new Constructor(consDoc.name(), params, this.mapVisibility((ProgramElementDoc)consDoc));
            constructors.add(constructor);
        }
        this.orderVisibility(constructors, this._constructors);
    }

    private void mapMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (MethodDoc methodDoc : this._classDoc.methods(false)) {
            ArrayList<MethodParameter> params = new ArrayList<MethodParameter>();
            for (Parameter param : methodDoc.parameters()) {
                params.add(new MethodParameter(ModelClass.shortName(param.type()), param.name()));
            }
            Method method = new Method(methodDoc.name(), params, ModelClass.shortName(methodDoc.returnType()), this.mapVisibility((ProgramElementDoc)methodDoc), methodDoc.isAbstract(), methodDoc.isStatic());
            methods.add(method);
        }
        this.orderVisibility(methods, this._methods);
    }

    private void mapSourceRel(ModelRel rel) {
        this._rels.add(rel);
        ModelClass dest = rel.destination();
        if (this != dest) {
            dest.addRelationship(rel);
        }
    }

    private Visibility mapVisibility(ProgramElementDoc doc) {
        if (doc.isPublic()) {
            return Visibility.PUBLIC;
        }
        if (doc.isProtected()) {
            return Visibility.PROTECTED;
        }
        if (doc.isPrivate()) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE_PRIVATE;
    }

    private void orderVisibility(List<? extends VisibilityItem> items, List<? extends VisibilityItem> filteredItems) {
        this.filterVisibility(items, filteredItems, Visibility.PUBLIC);
        this.filterVisibility(items, filteredItems, Visibility.PROTECTED);
        this.filterVisibility(items, filteredItems, Visibility.PACKAGE_PRIVATE);
        this.filterVisibility(items, filteredItems, Visibility.PRIVATE);
    }

    private void filterVisibility(List<? extends VisibilityItem> items, List<? extends VisibilityItem> filteredItems, Visibility visibility) {
        for (VisibilityItem visibilityItem : items) {
            if (visibilityItem.visibility != visibility) continue;
            filteredItems.add(visibilityItem);
        }
    }

    private static List<String> buildParameters(Type type) {
        ArrayList<String> params = new ArrayList<String>();
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            for (Type param : paramType.typeArguments()) {
                String name = ModelClass.shortName(param);
                params.add(name);
            }
        }
        return params;
    }

    private static String buildParameterString(Type type) {
        StringBuilder sb = new StringBuilder();
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            String sep = "";
            for (Type param : paramType.typeArguments()) {
                sb.append(sep);
                sb.append(param.simpleTypeName());
                sep = ", ";
            }
        }
        return sb.toString();
    }

    public static class MethodParameter {
        public String type;
        public String name;

        public MethodParameter(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class Method
    extends VisibilityItem {
        public String name;
        public List<MethodParameter> parameters;
        public String returnType;
        public boolean isAbstract;
        public boolean isStatic;

        public Method(String name, List<MethodParameter> parameters, String returnType, Visibility visibility, boolean isAbstract, boolean isStatic) {
            super(visibility);
            this.name = name;
            this.parameters = parameters;
            this.returnType = returnType;
            this.isAbstract = isAbstract;
            this.isStatic = isStatic;
        }
    }

    public static class Constructor
    extends VisibilityItem {
        public String name;
        public List<MethodParameter> parameters;

        public Constructor(String name, List<MethodParameter> parameters, Visibility visibility) {
            super(visibility);
            this.name = name;
            this.parameters = parameters;
        }
    }

    public static class Field
    extends VisibilityItem {
        public String name;
        public String type;
        public boolean isStatic;

        public Field(String name, String type, Visibility visibility, boolean isStatic) {
            super(visibility);
            this.name = name;
            this.type = type;
            this.isStatic = isStatic;
        }
    }

    public static class VisibilityItem {
        public Visibility visibility;

        public VisibilityItem(Visibility visibility) {
            this.visibility = visibility;
        }
    }

    public static enum ClassType {
        INTERFACE,
        ENUM,
        CLASS;

    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        PACKAGE_PRIVATE;

    }
}

