/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelPackage;
import info.leadinglight.umljavadoclet.printer.ContextDiagramPrinter;
import info.leadinglight.umljavadoclet.printer.DiagramOptions;
import info.leadinglight.umljavadoclet.printer.OverviewDiagramPrinter;
import info.leadinglight.umljavadoclet.printer.PackageDiagramPrinter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.version.Version;

public class UmlJavaDoclet
extends Standard {
    private static final String UML_DIV_TAG = "<div align=\"center\"><object type=\"image/svg+xml\" data=\"%1$s.svg\" alt=\"Package class diagram package %1$s\" border=0></object></div>";
    private static String javaDocDir;

    public static boolean start(RootDoc root) {
        System.out.println("Generating Javadocs...");
        System.out.println("Using arguments:");
        int idx = -1;
        for (int i = 0; i < root.options().length; ++i) {
            for (int j = 0; j < root.options()[i].length; ++j) {
                String s = root.options()[i][j];
                System.out.print(s + " ");
                if (!s.trim().equalsIgnoreCase("-d")) continue;
                idx = i;
            }
            System.out.println("");
        }
        javaDocDir = idx != -1 && root.options()[idx].length == 2 ? root.options()[idx][1] : ".";
        System.out.println("Using java doc dir: " + javaDocDir);
        UmlJavaDoclet.generateJavadoc(root);
        DiagramOptions options = new DiagramOptions();
        options.set(root.options());
        Model model = new Model(root);
        model.map();
        System.out.println("Using PlantUML version " + Version.versionString());
        System.out.println("Generating diagrams...");
        UmlJavaDoclet.generateContextDiagrams(model, options);
        UmlJavaDoclet.generatePackageDiagrams(model, options);
        UmlJavaDoclet.generateOverviewDiagram(model, options);
        return true;
    }

    public static LanguageVersion languageVersion() {
        return Standard.languageVersion();
    }

    public static int optionLength(String option) {
        if (DiagramOptions.isValidOption(option)) {
            return DiagramOptions.getOptionLength(option);
        }
        return Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        ArrayList<String[]> standardOptions = new ArrayList<String[]>();
        for (String[] option : options) {
            String name = option[0];
            if (DiagramOptions.isValidOption(name)) {
                String error = DiagramOptions.checkOption(option);
                if (error == null || error.length() <= 0) continue;
                reporter.printError(error);
                continue;
            }
            standardOptions.add(option);
        }
        return Standard.validOptions((String[][])((String[][])standardOptions.toArray((T[])new String[0][])), (DocErrorReporter)reporter);
    }

    private static void generateJavadoc(RootDoc rootDoc) {
        Standard.start((RootDoc)rootDoc);
    }

    private static void generateContextDiagrams(Model model, DiagramOptions options) {
        for (ModelClass modelClass : model.classes()) {
            if (!modelClass.isInternal()) continue;
            UmlJavaDoclet.generateContextDiagram(model, modelClass, options);
        }
    }

    private static void generateContextDiagram(Model model, ModelClass modelClass, DiagramOptions options) {
        ContextDiagramPrinter generator = new ContextDiagramPrinter(model, modelClass, options);
        generator.generate();
        File file = UmlJavaDoclet.createFile(modelClass.packageName(), modelClass.shortNameWithoutParameters(), "puml");
        boolean success = generator.toFile(file);
        if (success && UmlJavaDoclet.executePlantUML(modelClass.packageName(), modelClass.shortNameWithoutParameters(), generator.stringBuilder())) {
            if (UmlJavaDoclet.updateHtml(UmlJavaDoclet.fileForName(modelClass.packageName()), modelClass.shortNameWithoutParameters(), Pattern.compile(".*(Class|Interface|Enum) " + modelClass.shortNameWithoutParameters() + ".*"))) {
                System.out.println("Generated diagram for class " + modelClass.fullName());
            } else {
                System.out.println("ERROR: Could not update html page for class " + modelClass.fullName());
            }
        } else {
            System.out.println("ERROR: Could not generate diagram for class " + modelClass.fullName());
        }
    }

    private static void generatePackageDiagrams(Model model, DiagramOptions options) {
        for (ModelPackage modelPackage : model.packages()) {
            UmlJavaDoclet.generatePackageDiagram(model, modelPackage, options);
        }
    }

    private static void generatePackageDiagram(Model model, ModelPackage modelPackage, DiagramOptions options) {
        PackageDiagramPrinter generator = new PackageDiagramPrinter(model, modelPackage, options);
        generator.generate();
        File file = UmlJavaDoclet.createFile(modelPackage.fullName(), "package-summary", "puml");
        boolean success = generator.toFile(file);
        if (success && UmlJavaDoclet.executePlantUML(modelPackage.fullName(), "package-summary", generator.stringBuilder())) {
            if (UmlJavaDoclet.updateHtml(UmlJavaDoclet.fileForName(modelPackage.fullName()), "package-summary", Pattern.compile("(</[Hh]2>)|(<h1 title=\"Package\").*"))) {
                System.out.println("Generated diagram for package " + modelPackage.fullName());
            } else {
                System.out.println("ERROR: Could not update html page for package " + modelPackage.fullName());
            }
        } else {
            System.out.println("ERROR: Could not generate diagram for package " + modelPackage.fullName());
        }
    }

    private static void generateOverviewDiagram(Model model, DiagramOptions options) {
        OverviewDiagramPrinter generator = new OverviewDiagramPrinter(model, options);
        generator.generate();
        File file = UmlJavaDoclet.createFile("", "overview-summary", "puml");
        boolean success = generator.toFile(file);
        if (success && UmlJavaDoclet.executePlantUML("", "overview-summary", generator.stringBuilder())) {
            if (UmlJavaDoclet.updateHtml(UmlJavaDoclet.fileForName(""), "overview-summary", Pattern.compile("<div class=\"contentContainer\">"))) {
                System.out.println("Generated overview diagram");
            } else {
                System.out.println("ERROR: Could not update html page for overview diagram");
            }
        } else {
            System.out.println("ERROR: Could not generate overview diagram");
        }
    }

    private static boolean executePlantUML(String name, String baseName, StringBuilder content) {
        File file = UmlJavaDoclet.createFile(name, baseName, "svg");
        try {
            BufferedOutputStream imageOutput = new BufferedOutputStream(new FileOutputStream(file));
            SourceStringReader reader = new SourceStringReader(content.toString());
            reader.generateImage((OutputStream)imageOutput, new FileFormatOption(FileFormat.SVG).withSvgLinkTarget("_parent"));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static File createFile(String name, String baseName, String extension) {
        try {
            File file;
            File dir = UmlJavaDoclet.fileForName(name);
            if ((dir.exists() || dir.mkdirs()) && ((file = new File(dir, baseName + "." + extension)).exists() || file.createNewFile())) {
                return file;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File fileForName(String name) {
        File file = new File(javaDocDir);
        for (String part : name.split("\\.")) {
            if (part.trim().length() <= 0) continue;
            file = new File(file, part);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateHtml(File directory, String baseName, Pattern insertPointPattern) {
        File htmlFile = new File(directory, baseName + ".html");
        if (!htmlFile.exists()) {
            System.out.println("ERROR: Could not find html file " + htmlFile.getName());
            return false;
        }
        File svgFile = new File(directory, baseName + ".svg");
        if (!svgFile.exists()) {
            System.out.println("ERROR: Could not find svg file " + svgFile.getName());
            return false;
        }
        File updatedHtml = new File(directory, baseName + ".uml");
        boolean matched = false;
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(updatedHtml), "UTF-8"));
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(htmlFile), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
                if (matched || !insertPointPattern.matcher(line).matches()) continue;
                matched = true;
                String tag = String.format(UML_DIV_TAG, baseName);
                writer.newLine();
                writer.write(tag);
                writer.newLine();
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        if (matched) {
            htmlFile.delete();
            updatedHtml.renameTo(htmlFile);
            return true;
        }
        System.out.println("ERROR: Could not insert diagram into HTML file " + htmlFile.getName());
        htmlFile.delete();
        return false;
    }
}

