/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.filter.AdaptiveFacetFilter;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.FacetFilter;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.facets.impl.GroupByFacetCountCollector;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.FacetScoreable;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;

public class SimpleFacetHandler
extends FacetHandler<FacetDataCache>
implements FacetScoreable {
    private static Logger logger = Logger.getLogger(SimpleFacetHandler.class);
    protected TermListFactory _termListFactory;
    protected final String _indexFieldName;

    public SimpleFacetHandler(String name, String indexFieldName, TermListFactory termListFactory, Set<String> dependsOn) {
        super(name, dependsOn);
        this._indexFieldName = indexFieldName;
        this._termListFactory = termListFactory;
    }

    public SimpleFacetHandler(String name, TermListFactory termListFactory, Set<String> dependsOn) {
        this(name, name, termListFactory, dependsOn);
    }

    public SimpleFacetHandler(String name, String indexFieldName, TermListFactory termListFactory) {
        this(name, indexFieldName, termListFactory, null);
    }

    public SimpleFacetHandler(String name, TermListFactory termListFactory) {
        this(name, name, termListFactory);
    }

    public SimpleFacetHandler(String name) {
        this(name, name, null);
    }

    public SimpleFacetHandler(String name, String indexFieldName) {
        this(name, indexFieldName, null);
    }

    @Override
    public int getNumItems(BoboIndexReader reader, int id) {
        FacetDataCache data = (FacetDataCache)this.getFacetData(reader);
        if (data == null) {
            return 0;
        }
        return data.getNumItems(id);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new FacetDataCache.FacetDocComparatorSource(this);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        if (dataCache != null) {
            return new String[]{dataCache.valArray.get(dataCache.orderArray.get(id))};
        }
        return new String[0];
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        if (dataCache != null) {
            return new Object[]{dataCache.valArray.getRawValue(dataCache.orderArray.get(id))};
        }
        return new String[0];
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        FacetFilter f = new FacetFilter(this, value);
        AdaptiveFacetFilter af = new AdaptiveFacetFilter(new AdaptiveFacetFilter.FacetDataCacheBuilder(){

            @Override
            public FacetDataCache build(BoboIndexReader reader) {
                return (FacetDataCache)SimpleFacetHandler.this.getFacetData(reader);
            }

            @Override
            public String getName() {
                return SimpleFacetHandler.this.getName();
            }

            @Override
            public String getIndexFieldName() {
                return SimpleFacetHandler.this._indexFieldName;
            }
        }, f, new String[]{value}, false);
        return af;
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        if (vals.length > 1) {
            return EmptyFilter.getInstance();
        }
        return this.buildRandomAccessFilter(vals[0], prop);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        RandomAccessFilter filter = null;
        if (vals.length > 1) {
            FacetOrFilter f = new FacetOrFilter(this, vals, false);
            filter = new AdaptiveFacetFilter(new AdaptiveFacetFilter.FacetDataCacheBuilder(){

                @Override
                public FacetDataCache build(BoboIndexReader reader) {
                    return (FacetDataCache)SimpleFacetHandler.this.getFacetData(reader);
                }

                @Override
                public String getName() {
                    return SimpleFacetHandler.this.getName();
                }

                @Override
                public String getIndexFieldName() {
                    return SimpleFacetHandler.this._indexFieldName;
                }
            }, f, vals, isNot);
        } else {
            filter = vals.length == 1 ? this.buildRandomAccessFilter(vals[0], prop) : EmptyFilter.getInstance();
        }
        if (isNot) {
            filter = new RandomAccessNotFilter(filter);
        }
        return filter;
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, FacetSpec ospec) {
        return this.getFacetCountCollectorSource(sel, ospec, false);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec ospec, boolean groupMode) {
        if (groupMode) {
            return new FacetCountCollectorSource(){

                @Override
                public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                    FacetDataCache dataCache = (FacetDataCache)SimpleFacetHandler.this.getFacetData(reader);
                    return new SimpleGroupByFacetCountCollector(SimpleFacetHandler.this._name, dataCache, docBase, sel, ospec);
                }
            };
        }
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)SimpleFacetHandler.this.getFacetData(reader);
                return new SimpleFacetCountCollector(SimpleFacetHandler.this._name, dataCache, docBase, sel, ospec);
            }
        };
    }

    @Override
    public FacetDataCache load(BoboIndexReader reader) throws IOException {
        FacetDataCache dataCache = new FacetDataCache();
        dataCache.load(this._indexFieldName, (IndexReader)reader, this._termListFactory);
        return dataCache;
    }

    @Override
    public BoboDocScorer getDocScorer(BoboIndexReader reader, FacetTermScoringFunctionFactory scoringFunctionFactory, Map<String, Float> boostMap) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        float[] boostList = BoboDocScorer.buildBoostList(dataCache.valArray, boostMap);
        return new SimpleBoboDocScorer(dataCache, scoringFunctionFactory, boostList);
    }

    public static final class SimpleBoboDocScorer
    extends BoboDocScorer {
        protected final FacetDataCache _dataCache;

        public SimpleBoboDocScorer(FacetDataCache dataCache, FacetTermScoringFunctionFactory scoreFunctionFactory, float[] boostList) {
            super(scoreFunctionFactory.getFacetTermScoringFunction(dataCache.valArray.size(), dataCache.orderArray.size()), boostList);
            this._dataCache = dataCache;
        }

        @Override
        public Explanation explain(int doc) {
            int idx = this._dataCache.orderArray.get(doc);
            return this._function.explain(this._dataCache.freqs[idx], this._boostList[idx]);
        }

        @Override
        public final float score(int docid) {
            int idx = this._dataCache.orderArray.get(docid);
            return this._function.score(this._dataCache.freqs[idx], this._boostList[idx]);
        }
    }

    public static final class SimpleGroupByFacetCountCollector
    extends GroupByFacetCountCollector {
        protected int _totalGroups = 0;

        public SimpleGroupByFacetCountCollector(String name, FacetDataCache dataCache, int docBase, BrowseSelection sel, FacetSpec ospec) {
            super(name, dataCache, docBase, sel, ospec);
        }

        @Override
        public final void collect(int docid) {
            int n = this._array.get(docid);
            this._count[n] = this._count[n] + 1;
            if (this._count[n] <= 1) {
                ++this._totalGroups;
            }
        }

        @Override
        public final void collectAll() {
            this._count = this._dataCache.freqs;
            this._totalGroups = -1;
        }

        @Override
        public final int getTotalGroups() {
            if (this._totalGroups >= 0) {
                return this._totalGroups;
            }
            this._totalGroups = 0;
            for (int c : this._count) {
                if (c <= 0) continue;
                ++this._totalGroups;
            }
            return this._totalGroups;
        }
    }

    public static final class SimpleFacetCountCollector
    extends DefaultFacetCountCollector {
        public SimpleFacetCountCollector(String name, FacetDataCache dataCache, int docBase, BrowseSelection sel, FacetSpec ospec) {
            super(name, dataCache, docBase, sel, ospec);
        }

        @Override
        public final void collect(int docid) {
            int n = this._array.get(docid);
            this._count[n] = this._count[n] + 1;
        }

        @Override
        public final void collectAll() {
            this._count = this._dataCache.freqs;
        }
    }
}

