/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.FacetRangeFilter;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;

public class FacetRangeOrFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    protected final FacetHandler<FacetDataCache> _facetHandler;
    protected final String[] _vals;
    private final boolean _takeCompliment;
    private final FacetValueConverter _valueConverter;

    public FacetRangeOrFilter(FacetHandler<FacetDataCache> facetHandler, String[] vals) {
        this(facetHandler, vals, false);
    }

    public FacetRangeOrFilter(FacetHandler<FacetDataCache> facetHandler, String[] vals, boolean takeCompliment) {
        this(facetHandler, vals, takeCompliment, FacetValueConverter.DEFAULT);
    }

    public FacetRangeOrFilter(FacetHandler<FacetDataCache> facetHandler, String[] vals, boolean takeCompliment, FacetValueConverter valueConverter) {
        this._facetHandler = facetHandler;
        this._vals = vals;
        this._takeCompliment = takeCompliment;
        this._valueConverter = valueConverter;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = 0.0;
        FacetDataCache dataCache = this._facetHandler.getFacetData(reader);
        int accumFreq = 0;
        for (String val : this._vals) {
            int[] range = FacetRangeFilter.parse(dataCache, val);
            if (range == null) continue;
            for (int idx = range[0]; idx <= range[1]; ++idx) {
                accumFreq += dataCache.freqs[idx];
            }
        }
        int total = reader.maxDoc();
        selectivity = (double)accumFreq / (double)total;
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        if (this._vals.length == 0) {
            final EmptyDocIdSet empty = EmptyDocIdSet.getInstance();
            return new RandomAccessDocIdSet(){

                @Override
                public boolean get(int docId) {
                    return false;
                }

                public DocIdSetIterator iterator() throws IOException {
                    return empty.iterator();
                }
            };
        }
        return new FacetOrRandomAccessDocIdSet(this._facetHandler, reader, this._vals, this._valueConverter, this._takeCompliment);
    }

    public static class FacetOrDocIdSetIterator
    extends DocIdSetIterator {
        protected int _doc;
        protected final FacetDataCache _dataCache;
        protected final int[] _index;
        protected int _maxID;
        protected final OpenBitSet _bitset;
        protected final BigSegmentedArray _orderArray;

        public FacetOrDocIdSetIterator(FacetDataCache dataCache, int[] index, OpenBitSet bitset) {
            this._dataCache = dataCache;
            this._index = index;
            this._orderArray = dataCache.orderArray;
            this._bitset = bitset;
            this._doc = Integer.MAX_VALUE;
            this._maxID = -1;
            int size = this._dataCache.valArray.size();
            for (int i = 0; i < size; ++i) {
                if (!bitset.fastGet(i)) continue;
                if (this._doc > this._dataCache.minIDs[i]) {
                    this._doc = this._dataCache.minIDs[i];
                }
                if (this._maxID >= this._dataCache.maxIDs[i]) continue;
                this._maxID = this._dataCache.maxIDs[i];
            }
            --this._doc;
            if (this._doc < 0) {
                this._doc = -1;
            }
        }

        public final int docID() {
            return this._doc;
        }

        public int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._orderArray.findValues(this._bitset, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        public int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._orderArray.findValues(this._bitset, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }
    }

    public static class FacetOrRandomAccessDocIdSet
    extends RandomAccessDocIdSet {
        private OpenBitSet _bitset;
        private final BigSegmentedArray _orderArray;
        private final FacetDataCache _dataCache;
        private final int[] _index;

        FacetOrRandomAccessDocIdSet(FacetHandler<FacetDataCache> facetHandler, BoboIndexReader reader, String[] vals, FacetValueConverter valConverter, boolean takeCompliment) {
            this._dataCache = facetHandler.getFacetData(reader);
            this._orderArray = this._dataCache.orderArray;
            this._index = valConverter.convert(this._dataCache, vals);
            int size = this._dataCache.valArray.size();
            this._bitset = new OpenBitSet((long)size);
            for (int i : this._index) {
                this._bitset.fastSet(i);
            }
            if (takeCompliment) {
                for (int i = 0; i < size; ++i) {
                    this._bitset.fastFlip(i);
                }
            }
        }

        @Override
        public boolean get(int docId) {
            return this._bitset.fastGet(this._orderArray.get(docId));
        }

        public DocIdSetIterator iterator() throws IOException {
            return new FacetOrDocIdSetIterator(this._dataCache, this._index, this._bitset);
        }
    }
}

