/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Explanation;

public class BrowseHit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float score;
    private int docid;
    private Map<String, String[]> _fieldValues;
    private Map<String, Object[]> _rawFieldValues;
    private transient Comparable<?> _comparable;
    private Document _storedFields;
    private String _groupValue;
    private Object _rawGroupValue;
    private int _groupHitsCount;
    private BrowseHit[] _groupHits;
    private Explanation _explanation;
    private Map<String, TermFrequencyVector> _termFreqMap = new HashMap<String, TermFrequencyVector>();

    public float getScore() {
        return this.score;
    }

    public String[] getFields(String field) {
        return this._fieldValues != null ? this._fieldValues.get(field) : null;
    }

    public Object[] getRawFields(String field) {
        return this._rawFieldValues != null ? this._rawFieldValues.get(field) : null;
    }

    public String getField(String field) {
        String[] fields = this.getFields(field);
        if (fields != null && fields.length > 0) {
            return fields[0];
        }
        return null;
    }

    public Object getRawField(String field) {
        Object[] fields = this.getRawFields(field);
        if (fields != null && fields.length > 0) {
            return fields[0];
        }
        return null;
    }

    public Map<String, TermFrequencyVector> getTermFreqMap() {
        return this._termFreqMap;
    }

    public BrowseHit setTermFreqMap(Map<String, TermFrequencyVector> termFreqMap) {
        this._termFreqMap = termFreqMap;
        return this;
    }

    public String getGroupValue() {
        return this._groupValue;
    }

    public BrowseHit setGroupValue(String group) {
        this._groupValue = group;
        return this;
    }

    public Object getRawGroupValue() {
        return this._rawGroupValue;
    }

    public BrowseHit setRawGroupValue(Object group) {
        this._rawGroupValue = group;
        return this;
    }

    public int getGroupHitsCount() {
        return this._groupHitsCount;
    }

    public BrowseHit setGroupHitsCount(int count) {
        this._groupHitsCount = count;
        return this;
    }

    public BrowseHit[] getGroupHits() {
        return this._groupHits;
    }

    public BrowseHit setGroupHits(BrowseHit[] hits) {
        this._groupHits = hits;
        return this;
    }

    public Explanation getExplanation() {
        return this._explanation;
    }

    public BrowseHit setExplanation(Explanation explanation) {
        this._explanation = explanation;
        return this;
    }

    public BrowseHit setComparable(Comparable<?> comparable) {
        this._comparable = comparable;
        return this;
    }

    public Comparable<?> getComparable() {
        return this._comparable;
    }

    public int getDocid() {
        return this.docid;
    }

    public BrowseHit setDocid(int docid) {
        this.docid = docid;
        return this;
    }

    public Map<String, String[]> getFieldValues() {
        return this._fieldValues;
    }

    public BrowseHit setRawFieldValues(Map<String, Object[]> rawFieldValues) {
        this._rawFieldValues = rawFieldValues;
        return this;
    }

    public Map<String, Object[]> getRawFieldValues() {
        return this._rawFieldValues;
    }

    public BrowseHit setFieldValues(Map<String, String[]> fieldValues) {
        this._fieldValues = fieldValues;
        return this;
    }

    public BrowseHit setScore(float score) {
        this.score = score;
        return this;
    }

    public BrowseHit setStoredFields(Document doc) {
        this._storedFields = doc;
        return this;
    }

    public Document getStoredFields() {
        return this._storedFields;
    }

    public String toString(Map<String, String[]> map) {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<String, String[]>> set = map.entrySet();
        Iterator<Map.Entry<String, String[]>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> e = iterator.next();
            buffer.append(e.getKey());
            buffer.append(":");
            Object[] vals = e.getValue();
            buffer.append(vals == null ? null : Arrays.toString(vals));
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("docid: ").append(this.docid);
        buffer.append("score: ").append(this.score).append('\n');
        buffer.append("field values: ").append(this.toString(this._fieldValues)).append('\n');
        return buffer.toString();
    }

    public static class TermFrequencyVector
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String[] terms;
        public final int[] freqs;

        public TermFrequencyVector(String[] terms, int[] freqs) {
            this.terms = terms;
            this.freqs = freqs;
        }
    }
}

