/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.api.BoboCustomSortField;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.sort.MultiDocIdComparatorSource;
import com.browseengine.bobo.sort.ReverseDocComparatorSource;
import com.browseengine.bobo.sort.SortCollectorImpl;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public abstract class SortCollector
extends Collector {
    protected Collector _collector = null;
    protected final SortField[] _sortFields;
    protected final boolean _fetchStoredFields;

    protected SortCollector(SortField[] sortFields, boolean fetchStoredFields) {
        this._sortFields = sortFields;
        this._fetchStoredFields = fetchStoredFields;
    }

    public abstract BrowseHit[] topDocs() throws IOException;

    public abstract int getTotalHits();

    private static DocComparatorSource getNonFacetComparatorSource(SortField sf) {
        String fieldname = sf.getField();
        Locale locale = sf.getLocale();
        if (locale != null) {
            return new DocComparatorSource.StringLocaleComparatorSource(fieldname, locale);
        }
        int type = sf.getType();
        switch (type) {
            case 4: {
                return new DocComparatorSource.IntDocComparatorSource(fieldname);
            }
            case 5: {
                return new DocComparatorSource.FloatDocComparatorSource(fieldname);
            }
            case 6: {
                return new DocComparatorSource.LongDocComparatorSource(fieldname);
            }
            case 7: {
                return new DocComparatorSource.LongDocComparatorSource(fieldname);
            }
            case 10: {
                return new DocComparatorSource.ByteDocComparatorSource(fieldname);
            }
            case 8: {
                return new DocComparatorSource.ShortDocComparatorSource(fieldname);
            }
            case 9: {
                throw new IllegalArgumentException("lucene custom sort no longer supported");
            }
            case 3: {
                return new DocComparatorSource.StringOrdComparatorSource(fieldname);
            }
            case 11: {
                return new DocComparatorSource.StringValComparatorSource(fieldname);
            }
        }
        throw new IllegalStateException("Illegal sort type: " + type);
    }

    private static DocComparatorSource getComparatorSource(Browsable browser, SortField sf) {
        DocComparatorSource compSource = null;
        if (SortField.FIELD_DOC.equals((Object)sf)) {
            compSource = new DocComparatorSource.DocIdDocComparatorSource();
        } else if (SortField.FIELD_SCORE.equals((Object)sf) || sf.getType() == 0) {
            compSource = new ReverseDocComparatorSource(new DocComparatorSource.RelevanceDocComparatorSource());
        } else if (sf instanceof BoboCustomSortField) {
            BoboCustomSortField custField = (BoboCustomSortField)sf;
            DocComparatorSource src = custField.getCustomComparatorSource();
            assert (src != null);
            compSource = src;
        } else {
            String sortName;
            Set<String> facetNames = browser.getFacetNames();
            if (facetNames.contains(sortName = sf.getField())) {
                FacetHandler<?> handler = browser.getFacetHandler(sortName);
                assert (handler != null);
                compSource = handler.getDocComparatorSource();
            } else {
                compSource = SortCollector.getNonFacetComparatorSource(sf);
            }
        }
        boolean reverse = sf.getReverse();
        if (reverse) {
            compSource = new ReverseDocComparatorSource(compSource);
        }
        compSource.setReverse(reverse);
        return compSource;
    }

    private static SortField convert(Browsable browser, SortField sort) {
        String field = sort.getField();
        FacetHandler<?> facetHandler = browser.getFacetHandler(field);
        if (facetHandler != null) {
            browser.getFacetHandler(field);
            BoboCustomSortField sortField = new BoboCustomSortField(field, sort.getReverse(), facetHandler.getDocComparatorSource());
            return sortField;
        }
        return sort;
    }

    public static SortCollector buildSortCollector(Browsable browser, Query q, SortField[] sort, int offset, int count, boolean forceScoring, boolean fetchStoredFields) {
        DocComparatorSource compSource;
        boolean doScoring = forceScoring;
        if (!(sort != null && sort.length != 0 || q == null || q instanceof MatchAllDocsQuery)) {
            sort = new SortField[]{SortField.FIELD_SCORE};
        }
        if (sort == null || sort.length == 0) {
            sort = new SortField[]{SortField.FIELD_DOC};
        }
        Set<String> facetNames = browser.getFacetNames();
        for (SortField sf : sort) {
            if (sf.getType() != 0) continue;
            doScoring = true;
            break;
        }
        if (sort.length == 1) {
            SortField sf = SortCollector.convert(browser, sort[0]);
            compSource = SortCollector.getComparatorSource(browser, sf);
        } else {
            DocComparatorSource[] compSources = new DocComparatorSource[sort.length];
            for (int i = 0; i < sort.length; ++i) {
                compSources[i] = SortCollector.getComparatorSource(browser, SortCollector.convert(browser, sort[i]));
            }
            compSource = new MultiDocIdComparatorSource(compSources);
        }
        return new SortCollectorImpl(compSource, sort, browser, offset, count, doScoring, fetchStoredFields);
    }

    public void setCollector(Collector collector) {
        this._collector = collector;
    }

    public Collector getCollector() {
        return this._collector;
    }
}

