/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.Base64;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileUploadSession;
import com.box.sdk.BoxFileUploadSessionPart;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.LargeFileUploadTask;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class LargeFileUpload {
    private static final String DIGEST_ALGORITHM_SHA1 = "SHA1";
    private static final int DEFAULT_CONNECTIONS = 3;
    private static final int DEFAULT_TIMEOUT = 1;
    private static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.HOURS;
    private static final int THREAD_POOL_WAIT_TIME_IN_MILLIS = 1000;
    private final ThreadPoolExecutor executorService;
    private final long timeout;
    private final TimeUnit timeUnit;

    public LargeFileUpload(int nParallelConnections, long timeOut, TimeUnit unit) {
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(nParallelConnections);
        this.timeout = timeOut;
        this.timeUnit = unit;
    }

    public LargeFileUpload() {
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(3);
        this.timeout = 1L;
        this.timeUnit = DEFAULT_TIMEUNIT;
    }

    private static byte[] getBytesFromStream(InputStream stream, int numBytes) {
        int bytesNeeded = numBytes;
        int offset = 0;
        byte[] bytes = new byte[numBytes];
        while (bytesNeeded > 0) {
            int bytesRead;
            try {
                bytesRead = stream.read(bytes, offset, bytesNeeded);
            }
            catch (IOException ioe) {
                throw new BoxAPIException("Reading data from stream failed.", ioe);
            }
            if (bytesRead == -1) {
                throw new BoxAPIException("Stream ended while upload was progressing");
            }
            bytesNeeded -= bytesRead;
            offset += bytesRead;
        }
        return bytes;
    }

    private BoxFileUploadSession.Info createUploadSession(BoxAPIConnection boxApi, String folderId, URL url, String fileName, long fileSize) {
        BoxJSONRequest request = new BoxJSONRequest(boxApi, url, HttpMethod.POST);
        JsonObject body = new JsonObject();
        body.add("folder_id", folderId);
        body.add("file_name", fileName);
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFileUploadSession session;
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            String sessionId = jsonObject.get("id").asString();
            BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(boxApi, sessionId);
            boxFileUploadSession.getClass();
            BoxFileUploadSession.Info info = boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
            return info;
        }
    }

    public BoxFile.Info upload(BoxAPIConnection boxApi, String folderId, InputStream stream, URL url, String fileName, long fileSize) throws InterruptedException, IOException {
        BoxFileUploadSession.Info session = this.createUploadSession(boxApi, folderId, url, fileName, fileSize);
        return this.uploadHelper(session, stream, fileSize, null);
    }

    public BoxFile.Info upload(BoxAPIConnection boxApi, String folderId, InputStream stream, URL url, String fileName, long fileSize, Map<String, String> fileAttributes) throws InterruptedException, IOException {
        BoxFileUploadSession.Info session = this.createUploadSession(boxApi, folderId, url, fileName, fileSize);
        return this.uploadHelper(session, stream, fileSize, fileAttributes);
    }

    public BoxFile.Info upload(BoxAPIConnection boxApi, InputStream stream, URL url, long fileSize) throws InterruptedException, IOException {
        BoxFileUploadSession.Info session = this.createUploadSession(boxApi, url, fileSize);
        return this.uploadHelper(session, stream, fileSize, null);
    }

    public BoxFile.Info upload(BoxAPIConnection boxApi, InputStream stream, URL url, long fileSize, Map<String, String> fileAttributes) throws InterruptedException, IOException {
        BoxFileUploadSession.Info session = this.createUploadSession(boxApi, url, fileSize);
        return this.uploadHelper(session, stream, fileSize, fileAttributes);
    }

    private BoxFile.Info uploadHelper(BoxFileUploadSession.Info session, InputStream stream, long fileSize, Map<String, String> fileAttributes) throws InterruptedException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(DIGEST_ALGORITHM_SHA1);
        }
        catch (NoSuchAlgorithmException ae) {
            throw new BoxAPIException("Digest algorithm not found", ae);
        }
        DigestInputStream dis = new DigestInputStream(stream, digest);
        List<BoxFileUploadSessionPart> parts = this.uploadParts(session, dis, fileSize);
        byte[] digestBytes = digest.digest();
        String digestStr = Base64.encode(digestBytes);
        try {
            return session.getResource().commit(digestStr, parts, fileAttributes, null, null);
        }
        catch (Exception e) {
            session.getResource().abort();
            throw new BoxAPIException("Unable to commit the upload session", e);
        }
    }

    private BoxFileUploadSession.Info createUploadSession(BoxAPIConnection boxApi, URL url, long fileSize) {
        BoxJSONRequest request = new BoxJSONRequest(boxApi, url, HttpMethod.POST);
        JsonObject body = new JsonObject();
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFileUploadSession session;
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            String sessionId = jsonObject.get("id").asString();
            BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(boxApi, sessionId);
            boxFileUploadSession.getClass();
            BoxFileUploadSession.Info info = boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
            return info;
        }
    }

    private List<BoxFileUploadSessionPart> uploadParts(BoxFileUploadSession.Info session, InputStream stream, long fileSize) throws InterruptedException {
        ArrayList<BoxFileUploadSessionPart> parts = new ArrayList<BoxFileUploadSessionPart>();
        int partSize = session.getPartSize();
        long offset = 0L;
        long processed = 0L;
        int partPostion = 0;
        double maxQueueSizeDouble = Math.ceil((double)this.executorService.getMaximumPoolSize() * 1.5);
        int maxQueueSize = Double.valueOf(maxQueueSizeDouble).intValue();
        while (processed < fileSize) {
            long timeoutForWaitingInMillis = TimeUnit.MILLISECONDS.convert(this.timeout, this.timeUnit);
            if (this.executorService.getCorePoolSize() <= this.executorService.getActiveCount()) {
                if (timeoutForWaitingInMillis > 0L) {
                    Thread.sleep(1000L);
                    timeoutForWaitingInMillis -= 1000L;
                } else {
                    throw new BoxAPIException("Upload parts timedout");
                }
            }
            if (this.executorService.getQueue().size() >= maxQueueSize) continue;
            long diff = fileSize - processed;
            if (diff < (long)partSize) {
                partSize = (int)diff;
            }
            parts.add(null);
            byte[] bytes = LargeFileUpload.getBytesFromStream(stream, partSize);
            this.executorService.execute(new LargeFileUploadTask(session.getResource(), bytes, offset, partSize, fileSize, parts, partPostion));
            processed += (long)partSize;
            offset += (long)partSize;
            ++partPostion;
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(this.timeout, this.timeUnit);
        return parts;
    }

    public String generateDigest(InputStream stream) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(DIGEST_ALGORITHM_SHA1);
        }
        catch (NoSuchAlgorithmException ae) {
            throw new BoxAPIException("Digest algorithm not found", ae);
        }
        DigestInputStream dis = new DigestInputStream(stream, digest);
        try {
            int value = dis.read();
            while (value != -1) {
                value = dis.read();
            }
        }
        catch (IOException ioe) {
            throw new BoxAPIException("Reading the stream failed.", ioe);
        }
        byte[] digestBytes = digest.digest();
        return Base64.encode(digestBytes);
    }
}

