/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.users;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.users.CreateUserHeaders;
import com.box.sdkgen.managers.users.CreateUserQueryParams;
import com.box.sdkgen.managers.users.CreateUserRequestBody;
import com.box.sdkgen.managers.users.DeleteUserByIdHeaders;
import com.box.sdkgen.managers.users.DeleteUserByIdQueryParams;
import com.box.sdkgen.managers.users.GetUserByIdHeaders;
import com.box.sdkgen.managers.users.GetUserByIdQueryParams;
import com.box.sdkgen.managers.users.GetUserMeHeaders;
import com.box.sdkgen.managers.users.GetUserMeQueryParams;
import com.box.sdkgen.managers.users.GetUsersHeaders;
import com.box.sdkgen.managers.users.GetUsersQueryParams;
import com.box.sdkgen.managers.users.UpdateUserByIdHeaders;
import com.box.sdkgen.managers.users.UpdateUserByIdQueryParams;
import com.box.sdkgen.managers.users.UpdateUserByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.userfull.UserFull;
import com.box.sdkgen.schemas.users.Users;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class UsersManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public UsersManager() {
        this.networkSession = new NetworkSession();
    }

    protected UsersManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Users getUsers() {
        return this.getUsers(new GetUsersQueryParams(), new GetUsersHeaders());
    }

    public Users getUsers(GetUsersQueryParams queryParams) {
        return this.getUsers(queryParams, new GetUsersHeaders());
    }

    public Users getUsers(GetUsersHeaders headers) {
        return this.getUsers(new GetUsersQueryParams(), headers);
    }

    public Users getUsers(GetUsersQueryParams queryParams, GetUsersHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("filter_term", UtilsManager.convertToString(queryParams.getFilterTerm())), UtilsManager.entryOf("user_type", UtilsManager.convertToString(queryParams.getUserType())), UtilsManager.entryOf("external_app_user_id", UtilsManager.convertToString(queryParams.getExternalAppUserId())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("usemarker", UtilsManager.convertToString(queryParams.getUsemarker())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Users.class);
    }

    public UserFull createUser(CreateUserRequestBody requestBody) {
        return this.createUser(requestBody, new CreateUserQueryParams(), new CreateUserHeaders());
    }

    public UserFull createUser(CreateUserRequestBody requestBody, CreateUserQueryParams queryParams) {
        return this.createUser(requestBody, queryParams, new CreateUserHeaders());
    }

    public UserFull createUser(CreateUserRequestBody requestBody, CreateUserHeaders headers) {
        return this.createUser(requestBody, new CreateUserQueryParams(), headers);
    }

    public UserFull createUser(CreateUserRequestBody requestBody, CreateUserQueryParams queryParams, CreateUserHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UserFull.class);
    }

    public UserFull getUserMe() {
        return this.getUserMe(new GetUserMeQueryParams(), new GetUserMeHeaders());
    }

    public UserFull getUserMe(GetUserMeQueryParams queryParams) {
        return this.getUserMe(queryParams, new GetUserMeHeaders());
    }

    public UserFull getUserMe(GetUserMeHeaders headers) {
        return this.getUserMe(new GetUserMeQueryParams(), headers);
    }

    public UserFull getUserMe(GetUserMeQueryParams queryParams, GetUserMeHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/me"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UserFull.class);
    }

    public UserFull getUserById(String userId) {
        return this.getUserById(userId, new GetUserByIdQueryParams(), new GetUserByIdHeaders());
    }

    public UserFull getUserById(String userId, GetUserByIdQueryParams queryParams) {
        return this.getUserById(userId, queryParams, new GetUserByIdHeaders());
    }

    public UserFull getUserById(String userId, GetUserByIdHeaders headers) {
        return this.getUserById(userId, new GetUserByIdQueryParams(), headers);
    }

    public UserFull getUserById(String userId, GetUserByIdQueryParams queryParams, GetUserByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UserFull.class);
    }

    public UserFull updateUserById(String userId) {
        return this.updateUserById(userId, new UpdateUserByIdRequestBody(), new UpdateUserByIdQueryParams(), new UpdateUserByIdHeaders());
    }

    public UserFull updateUserById(String userId, UpdateUserByIdRequestBody requestBody) {
        return this.updateUserById(userId, requestBody, new UpdateUserByIdQueryParams(), new UpdateUserByIdHeaders());
    }

    public UserFull updateUserById(String userId, UpdateUserByIdQueryParams queryParams) {
        return this.updateUserById(userId, new UpdateUserByIdRequestBody(), queryParams, new UpdateUserByIdHeaders());
    }

    public UserFull updateUserById(String userId, UpdateUserByIdRequestBody requestBody, UpdateUserByIdQueryParams queryParams) {
        return this.updateUserById(userId, requestBody, queryParams, new UpdateUserByIdHeaders());
    }

    public UserFull updateUserById(String userId, UpdateUserByIdHeaders headers) {
        return this.updateUserById(userId, new UpdateUserByIdRequestBody(), new UpdateUserByIdQueryParams(), headers);
    }

    public UserFull updateUserById(String userId, UpdateUserByIdRequestBody requestBody, UpdateUserByIdHeaders headers) {
        return this.updateUserById(userId, requestBody, new UpdateUserByIdQueryParams(), headers);
    }

    public UserFull updateUserById(String userId, UpdateUserByIdQueryParams queryParams, UpdateUserByIdHeaders headers) {
        return this.updateUserById(userId, new UpdateUserByIdRequestBody(), queryParams, headers);
    }

    public UserFull updateUserById(String userId, UpdateUserByIdRequestBody requestBody, UpdateUserByIdQueryParams queryParams, UpdateUserByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId)), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UserFull.class);
    }

    public void deleteUserById(String userId) {
        this.deleteUserById(userId, new DeleteUserByIdQueryParams(), new DeleteUserByIdHeaders());
    }

    public void deleteUserById(String userId, DeleteUserByIdQueryParams queryParams) {
        this.deleteUserById(userId, queryParams, new DeleteUserByIdHeaders());
    }

    public void deleteUserById(String userId, DeleteUserByIdHeaders headers) {
        this.deleteUserById(userId, new DeleteUserByIdQueryParams(), headers);
    }

    public void deleteUserById(String userId, DeleteUserByIdQueryParams queryParams, DeleteUserByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("notify", UtilsManager.convertToString(queryParams.getNotify())), UtilsManager.entryOf("force", UtilsManager.convertToString(queryParams.getForce()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId)), "DELETE").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public UsersManager build() {
            return new UsersManager(this);
        }
    }
}

