/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.groups;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.groups.CreateGroupHeaders;
import com.box.sdkgen.managers.groups.CreateGroupQueryParams;
import com.box.sdkgen.managers.groups.CreateGroupRequestBody;
import com.box.sdkgen.managers.groups.DeleteGroupByIdHeaders;
import com.box.sdkgen.managers.groups.GetGroupByIdHeaders;
import com.box.sdkgen.managers.groups.GetGroupByIdQueryParams;
import com.box.sdkgen.managers.groups.GetGroupsHeaders;
import com.box.sdkgen.managers.groups.GetGroupsQueryParams;
import com.box.sdkgen.managers.groups.UpdateGroupByIdHeaders;
import com.box.sdkgen.managers.groups.UpdateGroupByIdQueryParams;
import com.box.sdkgen.managers.groups.UpdateGroupByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.groupfull.GroupFull;
import com.box.sdkgen.schemas.groups.Groups;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class GroupsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public GroupsManager() {
        this.networkSession = new NetworkSession();
    }

    protected GroupsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Groups getGroups() {
        return this.getGroups(new GetGroupsQueryParams(), new GetGroupsHeaders());
    }

    public Groups getGroups(GetGroupsQueryParams queryParams) {
        return this.getGroups(queryParams, new GetGroupsHeaders());
    }

    public Groups getGroups(GetGroupsHeaders headers) {
        return this.getGroups(new GetGroupsQueryParams(), headers);
    }

    public Groups getGroups(GetGroupsQueryParams queryParams, GetGroupsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("filter_term", UtilsManager.convertToString(queryParams.getFilterTerm())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Groups.class);
    }

    public GroupFull createGroup(CreateGroupRequestBody requestBody) {
        return this.createGroup(requestBody, new CreateGroupQueryParams(), new CreateGroupHeaders());
    }

    public GroupFull createGroup(CreateGroupRequestBody requestBody, CreateGroupQueryParams queryParams) {
        return this.createGroup(requestBody, queryParams, new CreateGroupHeaders());
    }

    public GroupFull createGroup(CreateGroupRequestBody requestBody, CreateGroupHeaders headers) {
        return this.createGroup(requestBody, new CreateGroupQueryParams(), headers);
    }

    public GroupFull createGroup(CreateGroupRequestBody requestBody, CreateGroupQueryParams queryParams, CreateGroupHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupFull.class);
    }

    public GroupFull getGroupById(String groupId) {
        return this.getGroupById(groupId, new GetGroupByIdQueryParams(), new GetGroupByIdHeaders());
    }

    public GroupFull getGroupById(String groupId, GetGroupByIdQueryParams queryParams) {
        return this.getGroupById(groupId, queryParams, new GetGroupByIdHeaders());
    }

    public GroupFull getGroupById(String groupId, GetGroupByIdHeaders headers) {
        return this.getGroupById(groupId, new GetGroupByIdQueryParams(), headers);
    }

    public GroupFull getGroupById(String groupId, GetGroupByIdQueryParams queryParams, GetGroupByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups/", UtilsManager.convertToString(groupId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupFull.class);
    }

    public GroupFull updateGroupById(String groupId) {
        return this.updateGroupById(groupId, new UpdateGroupByIdRequestBody(), new UpdateGroupByIdQueryParams(), new UpdateGroupByIdHeaders());
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdRequestBody requestBody) {
        return this.updateGroupById(groupId, requestBody, new UpdateGroupByIdQueryParams(), new UpdateGroupByIdHeaders());
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdQueryParams queryParams) {
        return this.updateGroupById(groupId, new UpdateGroupByIdRequestBody(), queryParams, new UpdateGroupByIdHeaders());
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdRequestBody requestBody, UpdateGroupByIdQueryParams queryParams) {
        return this.updateGroupById(groupId, requestBody, queryParams, new UpdateGroupByIdHeaders());
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdHeaders headers) {
        return this.updateGroupById(groupId, new UpdateGroupByIdRequestBody(), new UpdateGroupByIdQueryParams(), headers);
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdRequestBody requestBody, UpdateGroupByIdHeaders headers) {
        return this.updateGroupById(groupId, requestBody, new UpdateGroupByIdQueryParams(), headers);
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdQueryParams queryParams, UpdateGroupByIdHeaders headers) {
        return this.updateGroupById(groupId, new UpdateGroupByIdRequestBody(), queryParams, headers);
    }

    public GroupFull updateGroupById(String groupId, UpdateGroupByIdRequestBody requestBody, UpdateGroupByIdQueryParams queryParams, UpdateGroupByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups/", UtilsManager.convertToString(groupId)), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupFull.class);
    }

    public void deleteGroupById(String groupId) {
        this.deleteGroupById(groupId, new DeleteGroupByIdHeaders());
    }

    public void deleteGroupById(String groupId, DeleteGroupByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups/", UtilsManager.convertToString(groupId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public GroupsManager build() {
            return new GroupsManager(this);
        }
    }
}

