/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.sharedlinksweblinks;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.sharedlinksweblinks.AddShareLinkToWebLinkHeaders;
import com.box.sdkgen.managers.sharedlinksweblinks.AddShareLinkToWebLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksweblinks.AddShareLinkToWebLinkRequestBody;
import com.box.sdkgen.managers.sharedlinksweblinks.FindWebLinkForSharedLinkHeaders;
import com.box.sdkgen.managers.sharedlinksweblinks.FindWebLinkForSharedLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksweblinks.GetSharedLinkForWebLinkHeaders;
import com.box.sdkgen.managers.sharedlinksweblinks.GetSharedLinkForWebLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksweblinks.RemoveSharedLinkFromWebLinkHeaders;
import com.box.sdkgen.managers.sharedlinksweblinks.RemoveSharedLinkFromWebLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksweblinks.RemoveSharedLinkFromWebLinkRequestBody;
import com.box.sdkgen.managers.sharedlinksweblinks.UpdateSharedLinkOnWebLinkHeaders;
import com.box.sdkgen.managers.sharedlinksweblinks.UpdateSharedLinkOnWebLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksweblinks.UpdateSharedLinkOnWebLinkRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.weblink.WebLink;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SharedLinksWebLinksManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SharedLinksWebLinksManager() {
        this.networkSession = new NetworkSession();
    }

    protected SharedLinksWebLinksManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public WebLink findWebLinkForSharedLink(FindWebLinkForSharedLinkHeaders headers) {
        return this.findWebLinkForSharedLink(new FindWebLinkForSharedLinkQueryParams(), headers);
    }

    public WebLink findWebLinkForSharedLink(FindWebLinkForSharedLinkQueryParams queryParams, FindWebLinkForSharedLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch())), UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shared_items#web_links"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public WebLink getSharedLinkForWebLink(String webLinkId, GetSharedLinkForWebLinkQueryParams queryParams) {
        return this.getSharedLinkForWebLink(webLinkId, queryParams, new GetSharedLinkForWebLinkHeaders());
    }

    public WebLink getSharedLinkForWebLink(String webLinkId, GetSharedLinkForWebLinkQueryParams queryParams, GetSharedLinkForWebLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId), "#get_shared_link"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public WebLink addShareLinkToWebLink(String webLinkId, AddShareLinkToWebLinkQueryParams queryParams) {
        return this.addShareLinkToWebLink(webLinkId, new AddShareLinkToWebLinkRequestBody(), queryParams, new AddShareLinkToWebLinkHeaders());
    }

    public WebLink addShareLinkToWebLink(String webLinkId, AddShareLinkToWebLinkRequestBody requestBody, AddShareLinkToWebLinkQueryParams queryParams) {
        return this.addShareLinkToWebLink(webLinkId, requestBody, queryParams, new AddShareLinkToWebLinkHeaders());
    }

    public WebLink addShareLinkToWebLink(String webLinkId, AddShareLinkToWebLinkQueryParams queryParams, AddShareLinkToWebLinkHeaders headers) {
        return this.addShareLinkToWebLink(webLinkId, new AddShareLinkToWebLinkRequestBody(), queryParams, headers);
    }

    public WebLink addShareLinkToWebLink(String webLinkId, AddShareLinkToWebLinkRequestBody requestBody, AddShareLinkToWebLinkQueryParams queryParams, AddShareLinkToWebLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId), "#add_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public WebLink updateSharedLinkOnWebLink(String webLinkId, UpdateSharedLinkOnWebLinkQueryParams queryParams) {
        return this.updateSharedLinkOnWebLink(webLinkId, new UpdateSharedLinkOnWebLinkRequestBody(), queryParams, new UpdateSharedLinkOnWebLinkHeaders());
    }

    public WebLink updateSharedLinkOnWebLink(String webLinkId, UpdateSharedLinkOnWebLinkRequestBody requestBody, UpdateSharedLinkOnWebLinkQueryParams queryParams) {
        return this.updateSharedLinkOnWebLink(webLinkId, requestBody, queryParams, new UpdateSharedLinkOnWebLinkHeaders());
    }

    public WebLink updateSharedLinkOnWebLink(String webLinkId, UpdateSharedLinkOnWebLinkQueryParams queryParams, UpdateSharedLinkOnWebLinkHeaders headers) {
        return this.updateSharedLinkOnWebLink(webLinkId, new UpdateSharedLinkOnWebLinkRequestBody(), queryParams, headers);
    }

    public WebLink updateSharedLinkOnWebLink(String webLinkId, UpdateSharedLinkOnWebLinkRequestBody requestBody, UpdateSharedLinkOnWebLinkQueryParams queryParams, UpdateSharedLinkOnWebLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId), "#update_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public WebLink removeSharedLinkFromWebLink(String webLinkId, RemoveSharedLinkFromWebLinkQueryParams queryParams) {
        return this.removeSharedLinkFromWebLink(webLinkId, new RemoveSharedLinkFromWebLinkRequestBody(), queryParams, new RemoveSharedLinkFromWebLinkHeaders());
    }

    public WebLink removeSharedLinkFromWebLink(String webLinkId, RemoveSharedLinkFromWebLinkRequestBody requestBody, RemoveSharedLinkFromWebLinkQueryParams queryParams) {
        return this.removeSharedLinkFromWebLink(webLinkId, requestBody, queryParams, new RemoveSharedLinkFromWebLinkHeaders());
    }

    public WebLink removeSharedLinkFromWebLink(String webLinkId, RemoveSharedLinkFromWebLinkQueryParams queryParams, RemoveSharedLinkFromWebLinkHeaders headers) {
        return this.removeSharedLinkFromWebLink(webLinkId, new RemoveSharedLinkFromWebLinkRequestBody(), queryParams, headers);
    }

    public WebLink removeSharedLinkFromWebLink(String webLinkId, RemoveSharedLinkFromWebLinkRequestBody requestBody, RemoveSharedLinkFromWebLinkQueryParams queryParams, RemoveSharedLinkFromWebLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId), "#remove_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SharedLinksWebLinksManager build() {
            return new SharedLinksWebLinksManager(this);
        }
    }
}

