/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.omGraphics.editable.EOMGEditState;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.stateMachine.State;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class GraphicEditState
extends State
implements EOMGEditState {
    protected EditableOMGraphic graphic;

    public GraphicEditState(EditableOMGraphic eomg) {
        this.graphic = eomg;
    }

    public boolean mouseDragged(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|edit state|mouseDragged");
        if (this.graphic.getMovingPoint() != null) {
            this.graphic.redraw(e);
        } else {
            this.graphic.getStateMachine().setSelected();
        }
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseReleased(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|edit state|mouseReleased");
        if (this.graphic.getStateMachine().isOffsetNeeded()) {
            this.graphic.getStateMachine().setOffset();
            this.graphic.getStateMachine().setOffsetNeeded(false);
        } else {
            this.graphic.getStateMachine().setSelected();
            GrabPoint mp = this.graphic.getMovingPoint();
            if (!SwingUtilities.isRightMouseButton(e)) {
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e, 6);
            }
            if (mp == null && !this.graphic.getCanGrabGraphic()) {
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e, 2);
            } else {
                this.graphic.fireEvent(EOMGCursors.EDIT, "", e, 2);
            }
        }
        this.graphic.redraw(e, true);
        this.graphic.setMovingPoint(null);
        return this.getMapMouseListenerResponse();
    }
}

