/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMLabeler;
import com.bbn.openmap.omGraphics.OMText;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class OMTextLabeler
extends OMText
implements OMLabeler {
    public static final int ANCHOR_TOPLEFT = 0;
    public static final int ANCHOR_TOP = 1;
    public static final int ANCHOR_TOPRIGHT = 2;
    public static final int ANCHOR_LEFT = 3;
    public static final int ANCHOR_CENTER = 4;
    public static final int ANCHOR_RIGHT = 5;
    public static final int ANCHOR_BOTTOMLEFT = 6;
    public static final int ANCHOR_BOTTOM = 7;
    public static final int ANCHOR_BOTTOMRIGHT = 8;
    protected int anchor = 4;

    public OMTextLabeler(String stuff) {
        this(stuff, DEFAULT_FONT, 0);
    }

    public OMTextLabeler(String stuff, int just) {
        this(stuff, DEFAULT_FONT, just, 4);
    }

    public OMTextLabeler(String stuff, int just, int loc) {
        this(stuff, DEFAULT_FONT, just, loc);
    }

    public OMTextLabeler(String stuff, Font font, int just) {
        this(stuff, font, just, 4);
    }

    public OMTextLabeler(String stuff, Font font, int just, int loc) {
        this.setRenderType(2);
        this.setData(stuff);
        this.setFont(font);
        this.setJustify(just);
        this.setAnchor(loc);
        this.putAttribute("norotate", Boolean.TRUE);
    }

    public void setLocation(GeneralPath gp) {
        if (gp != null) {
            Rectangle rect = gp.getBounds();
            double x = rect.getX();
            double y = rect.getY();
            if (this.anchor == 1 || this.anchor == 4 || this.anchor == 7) {
                x += rect.getWidth() / 2.0;
            } else if (this.anchor == 2 || this.anchor == 5 || this.anchor == 8) {
                x += rect.getWidth();
            }
            if (this.anchor == 3 || this.anchor == 4 || this.anchor == 5) {
                y += rect.getHeight() / 2.0;
            } else if (this.anchor == 6 || this.anchor == 7 || this.anchor == 8) {
                y += rect.getHeight();
            }
            this.setLocation(new Point((int)x, (int)y));
        }
    }

    public void setLocation(Point2D p) {
        this.polyBounds = null;
        this.setX((int)p.getX());
        this.setY((int)p.getY());
        this.setMapLocation(p);
        this.computeBounds();
        this.setNeedToRegenerate(false);
    }

    public void setLocation(int[] xpoints, int[] ypoints) {
        this.setLocation(OMTextLabeler.getCenter(xpoints, ypoints));
    }

    protected static double calculateProjectedArea(int[] xpts, int[] ypts) {
        int j = 0;
        double area = 0.0;
        int npoints = xpts.length;
        for (int i = 0; i < npoints; ++i) {
            j = (i + 1) % npoints;
            area += (double)(xpts[i] * ypts[j]);
            area -= (double)(ypts[i] * xpts[j]);
        }
        return area / 2.0;
    }

    protected static Point getCenter(int[] xpts, int[] ypts) {
        int npoints = xpts.length;
        if (npoints == 1) {
            Point center = new Point(xpts[0], ypts[0]);
            return center;
        }
        if (npoints == 2) {
            int x = xpts[1] > xpts[0] ? xpts[0] + (xpts[1] - xpts[0]) / 2 : xpts[1] + (xpts[0] - xpts[1]) / 2;
            int y = ypts[1] > ypts[0] ? ypts[0] + (ypts[1] - ypts[0]) / 2 : ypts[1] + (ypts[0] - ypts[1]) / 2;
            Point center = new Point(x, y);
            return center;
        }
        double factor = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < npoints; ++i) {
            int j = (i + 1) % npoints;
            factor = xpts[i] * ypts[j] - xpts[j] * ypts[i];
            cx += (double)(xpts[i] + xpts[j]) * factor;
            cy += (double)(ypts[i] + ypts[j]) * factor;
        }
        double A = OMTextLabeler.calculateProjectedArea(xpts, ypts);
        factor = 1.0 / (A *= 6.0);
        Point center = new Point((int)Math.round(cx *= factor), (int)Math.round(cy *= factor));
        return center;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMTextLabeler) {
            OMTextLabeler labeler = (OMTextLabeler)source;
            this.anchor = labeler.anchor;
        }
    }
}

