/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.util.ImageWarp;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.util.DataBounds;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class OMScalingRaster
extends OMRaster
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double lat2 = 0.0;
    protected double lon2 = 0.0;
    protected AffineTransformOp scalingXFormOp;
    protected transient Rectangle clipRect;
    protected transient ArrayList<float[]> corners;
    protected int scaleTransformType = 2;
    protected Projection lastProjection = null;

    public OMScalingRaster() {
    }

    public OMScalingRaster(double ullat, double ullon, double lrlat, double lrlon, int w, int h, int[] pix) {
        super(ullat, ullon, w, h, pix);
        this.lat2 = lrlat;
        this.lon2 = lrlon;
    }

    public OMScalingRaster(double ullat, double ullon, double lrlat, double lrlon, ImageIcon ii) {
        this(ullat, ullon, lrlat, lrlon, ii.getImage());
    }

    public OMScalingRaster(double ullat, double ullon, double lrlat, double lrlon, Image ii) {
        this.setRenderType(1);
        this.setColorModel(2);
        this.lat = ullat;
        this.lon = ullon;
        this.lat2 = lrlat;
        this.lon2 = lrlon;
        this.setImage(ii);
    }

    public OMScalingRaster(double ullat, double ullon, double lrlat, double lrlon, int w, int h, byte[] bytes, Color[] colorTable, int trans) {
        super(ullat, ullon, w, h, bytes, colorTable, trans);
        this.lat2 = lrlat;
        this.lon2 = lrlon;
    }

    protected boolean position(Projection proj) {
        if (proj == null) {
            if (this.DEBUG) {
                logger.fine("OMScalingRaster: null projection in position!");
            }
            return false;
        }
        this.point1 = (Point)proj.forward(this.lat, this.lon, (Point2D)new Point());
        this.point2 = (Point)proj.forward(this.lat2, this.lon2, (Point2D)new Point());
        this.corners = null;
        if (this.point1.x > this.point2.x) {
            double[] coords = new double[]{this.lat, this.lon, this.lat, this.lon2, this.lat2, this.lon2, this.lat2, this.lon, this.lat, this.lon};
            this.corners = proj instanceof GeoProj ? ((GeoProj)proj).forwardPoly(ProjMath.arrayDegToRad(coords), 1, -1, true) : proj.forwardPoly(coords, true);
            if (this.corners != null && this.corners.size() > 2) {
                float[] xs = this.corners.get(0);
                float[] ys = this.corners.get(1);
                this.point1.setLocation(xs[0], ys[0]);
                this.point2.setLocation(xs[2], ys[2]);
            }
        }
        this.setNeedToReposition(false);
        return true;
    }

    public boolean generate(Projection proj) {
        if (!this.updateImageForProjection(proj)) {
            if (this.getNeedToReposition()) {
                this.position(proj);
                this.setShape();
            } else {
                this.setShape();
                this.setNeedToRegenerate(false);
                return true;
            }
        }
        this.setShape(null);
        if (!this.position(proj)) {
            if (this.DEBUG) {
                logger.fine("OMRaster.generate(): positioning failed!");
            }
            return false;
        }
        if (this.colorModel != 2 && (this.bitmap == null || this.getNeedToRegenerate())) {
            if (this.DEBUG) {
                logger.fine("OMScalingRaster: generating image");
            }
            super.generate(proj);
            this.setImage(this.bitmap);
            this.pixels = null;
            this.bits = null;
        }
        this.scaleTo(proj);
        if (this.bitmap != null) {
            if (this.corners == null) {
                GeneralPath projectedShape = OMScalingRaster.createBoxShape(this.point1.x, this.point1.y, this.point2.x - this.point1.x, this.point2.y - this.point1.y);
                int w = this.bitmap.getWidth(this);
                int h = this.bitmap.getHeight(this);
                double anchorX = this.point1.x + w / 2;
                double anchorY = this.point1.y + h / 2;
                this.setShape(this.adjustShapeForRotation(projectedShape, anchorX, anchorY));
            } else {
                int numRects = this.corners.size();
                Path2D projectedShape = null;
                for (int i = 0; i < numRects; i += 2) {
                    GeneralPath gp = OMScalingRaster.createShape(this.corners.get(i), this.corners.get(i + 1), true);
                    projectedShape = OMScalingRaster.appendShapeEdge((GeneralPath)projectedShape, gp, false);
                }
                if (projectedShape != null) {
                    Rectangle rect = projectedShape.getBounds();
                    double anchorX = rect.getX() + rect.getWidth() / 2.0;
                    double anchorY = rect.getY() + rect.getHeight() / 2.0;
                    projectedShape = this.adjustShapeForRotation((GeneralPath)projectedShape, anchorX, anchorY);
                }
                this.setShape((GeneralPath)projectedShape);
            }
            this.setLabelLocation(this.getShape(), proj);
            this.setNeedToRegenerate(false);
        } else {
            this.hasLabel = false;
        }
        return true;
    }

    protected boolean updateImageForProjection(Projection proj) {
        boolean ret;
        boolean projUnchanged = proj.equals(this.lastProjection);
        boolean bl = ret = this.bitmap != null && projUnchanged && !this.getNeedToRegenerate();
        if (!projUnchanged) {
            this.lastProjection = proj.makeClone();
        }
        this.evaluateRotationAngle(proj);
        return !ret;
    }

    protected void rotate(Graphics2D g) {
        Double angle = this.renderRotationAngle;
        if (angle != null) {
            int rotOffsetX = this.point1.x + (this.point2.x - this.point1.x) / 2;
            int rotOffsetY = this.point1.y + (this.point2.y - this.point1.y) / 2;
            g.rotate(angle, rotOffsetX, rotOffsetY);
        }
    }

    protected void scaleTo(Projection thisProj) {
        if (this.DEBUG) {
            logger.fine("starting scaling evaluation.");
        }
        if (this.bitmap == null) {
            if (this.DEBUG) {
                logger.fine("source image is null");
            }
            return;
        }
        Rectangle winRect = new Rectangle(thisProj.getWidth(), thisProj.getHeight());
        Rectangle projRect = new Rectangle();
        projRect.setLocation(this.point1);
        projRect.setSize(this.point2.x - this.point1.x, this.point2.y - this.point1.y);
        Rectangle sourceRect = new Rectangle();
        sourceRect.width = this.bitmap.getWidth(this);
        sourceRect.height = this.bitmap.getHeight(this);
        this.clipRect = null;
        Rectangle iRect = projRect;
        if (this.corners == null || this.corners.size() <= 2) {
            iRect = winRect.intersection(projRect);
        }
        if (!iRect.isEmpty()) {
            this.clipRect = new Rectangle();
            this.clipRect.setBounds(sourceRect);
            if (iRect.width >= 1 && iRect.height >= 1) {
                if (!winRect.contains(projRect)) {
                    double xScaleFactor = (double)sourceRect.width / (double)projRect.width;
                    double yScaleFactor = (double)sourceRect.height / (double)projRect.height;
                    int xOffset = iRect.x - projRect.x;
                    int yOffset = iRect.y - projRect.y;
                    this.clipRect.x = (int)Math.floor((double)xOffset * xScaleFactor);
                    this.clipRect.y = (int)Math.floor((double)yOffset * yScaleFactor);
                    this.clipRect.width = (int)Math.ceil((double)iRect.width * xScaleFactor);
                    this.clipRect.height = (int)Math.ceil((double)iRect.height * yScaleFactor);
                    if (this.clipRect.width + this.clipRect.x > sourceRect.width) {
                        this.clipRect.width = sourceRect.width - this.clipRect.x;
                    }
                    if (this.clipRect.height + this.clipRect.y > sourceRect.height) {
                        this.clipRect.height = sourceRect.height - this.clipRect.y;
                    }
                }
                if (this.clipRect.width <= 0) {
                    this.clipRect.width = 1;
                }
                if (this.clipRect.height <= 0) {
                    this.clipRect.height = 1;
                }
                double widthAdj = (double)iRect.width / (double)this.clipRect.width;
                double heightAdj = (double)iRect.height / (double)this.clipRect.height;
                AffineTransform xform = new AffineTransform();
                xform.setToScale(widthAdj, heightAdj);
                this.scalingXFormOp = new AffineTransformOp(xform, this.getScaleTransformType());
                this.point1.setLocation(iRect.x, iRect.y);
                this.point2.setLocation(iRect.x + iRect.width, iRect.y + iRect.height);
            }
        }
    }

    public void render(Graphics graphics) {
        boolean smallWorld;
        if (this.getNeedToRegenerate() || this.getNeedToReposition() || !this.isVisible()) {
            return;
        }
        boolean bl = smallWorld = this.bitmap != null && this.corners != null && this.corners.size() >= 4;
        if (smallWorld) {
            float[] xs = this.corners.get(2);
            float[] ys = this.corners.get(3);
            Point point1 = new Point();
            point1.setLocation(xs[0], ys[0]);
            Point point2 = new Point();
            point2.setLocation(xs[2], ys[2]);
            Graphics g = graphics.create();
            if (g instanceof Graphics2D && this.renderRotationAngle != null) {
                this.rotate((Graphics2D)g);
            }
            this.renderImage(g, this.bitmap, point1);
        }
        super.render(graphics);
    }

    protected void renderImage(Graphics g, Image image, Point loc) {
        Rectangle visibleImageArea = this.getClippedRectangle();
        if (image != null) {
            if (visibleImageArea != null) {
                if (this.DEBUG) {
                    logger.fine("drawing " + visibleImageArea + " image at " + loc.x + ", " + loc.y);
                }
                if (g instanceof Graphics2D) {
                    if (image instanceof BufferedImage) {
                        ((Graphics2D)g).drawImage(((BufferedImage)image).getSubimage(visibleImageArea.x, visibleImageArea.y, visibleImageArea.width, visibleImageArea.height), this.scalingXFormOp, loc.x, loc.y);
                    } else {
                        int sx1 = visibleImageArea.x;
                        int sy1 = visibleImageArea.y;
                        int sx2 = sx1 + visibleImageArea.width;
                        int sy2 = sy1 + visibleImageArea.height;
                        int dx1 = loc.x;
                        int dy1 = loc.y;
                        Point2D d2 = this.scalingXFormOp.getPoint2D(new Point2D.Double(dx1 + visibleImageArea.width, dy1 + visibleImageArea.height), new Point2D.Double());
                        int dx2 = (int)d2.getX();
                        int dy2 = (int)d2.getY();
                        ((Graphics2D)g).drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                    }
                }
            } else {
                g.drawImage(image, loc.x, loc.y, this);
            }
        } else if (this.DEBUG) {
            logger.fine("ignoring null bitmap image");
        }
    }

    public Rectangle getClippedRectangle() {
        return this.clipRect;
    }

    public void setULLat(double value) {
        this.setLat(value);
    }

    public double getULLat() {
        return this.getLat();
    }

    public void setULLon(double value) {
        this.setLon(value);
    }

    public double getULLon() {
        return this.getLon();
    }

    public void setLRLat(double value) {
        if (this.lat2 == value) {
            return;
        }
        this.lat2 = value;
        this.setNeedToReposition(true);
    }

    public double getLRLat() {
        return this.lat2;
    }

    public void setLRLon(double value) {
        if (this.lon2 == value) {
            return;
        }
        this.lon2 = value;
        this.setNeedToReposition(true);
    }

    public double getLRLon() {
        return this.lon2;
    }

    public void setShape() {
        if (this.point2 != null && this.point1 != null) {
            int w = this.point2.x - this.point1.x;
            int h = this.point2.y - this.point1.y;
            this.setShape(OMScalingRaster.createBoxShape(this.point1.x, this.point1.y, w, h));
        }
    }

    public boolean isOnMap(Projection proj) {
        Point2D p1 = proj.forward(this.lat, this.lon);
        Point2D p2 = proj.forward(this.lat2, this.lon2);
        int h = (int)Math.abs(p2.getY() - p1.getY());
        int w = (int)Math.abs(p2.getX() - p1.getX());
        Rectangle imageRect = new Rectangle((int)p1.getX(), (int)p1.getY(), w, h);
        proj.forward((Point2D)proj.getUpperLeft(), p1);
        proj.forward((Point2D)proj.getLowerRight(), p2);
        h = (int)Math.abs(p2.getY() - p1.getY());
        w = (int)Math.abs(p2.getX() - p1.getX());
        Rectangle mapRect = new Rectangle((int)p1.getX(), (int)p1.getY(), w, h);
        return mapRect.intersects(imageRect);
    }

    public int getScaleTransformType() {
        return this.scaleTransformType;
    }

    public void setScaleTransformType(int scaleTransformType) {
        if (scaleTransformType == 2 || scaleTransformType == 3 || scaleTransformType == 1) {
            this.scaleTransformType = scaleTransformType;
        }
    }

    public ImageWarp getImageWarp(GeoCoordTransformation transform) {
        ImageWarp imageWarp = null;
        Image image = this.bitmap;
        if (image != null) {
            DataBounds imageBounds = new DataBounds();
            imageBounds.add(this.lon, this.lat);
            imageBounds.add(this.lon2, this.lat2);
            if (transform == null) {
                transform = new LatLonGCT();
            }
            BufferedImage bi = null;
            if (image instanceof BufferedImage) {
                bi = (BufferedImage)image;
            } else {
                bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                bi.getGraphics().drawImage(image, 0, 0, null);
            }
            imageWarp = new ImageWarp(bi, transform, imageBounds);
        }
        return imageWarp;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMScalingRaster) {
            OMScalingRaster omsr = (OMScalingRaster)source;
            this.lat2 = omsr.lat2;
            this.lon2 = omsr.lon2;
            this.scaleTransformType = omsr.scaleTransformType;
        }
    }
}

