/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OMList<T extends OMGeometry>
extends OMGraphicAdapter
implements List<T>,
OMGraphic {
    public static final transient int LAST_ADDED_ON_TOP = 0;
    public static final transient int FIRST_ADDED_ON_TOP = 1;
    public static final int NONE = -1;
    protected int traverseMode = 1;
    protected boolean vague = false;
    protected boolean allowDuplicates = true;
    protected List<T> graphics;
    protected boolean processAllGeometries = false;

    public OMList() {
        this.graphics = Collections.synchronizedList(new ArrayList());
    }

    public OMList(int initialCapacity) {
        this.graphics = Collections.synchronizedList(new ArrayList(initialCapacity));
    }

    @Override
    public String getDescription() {
        return this.getDescription(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(int level) {
        StringBuffer sb = new StringBuffer();
        if (level > 0) {
            sb.append("|--> ");
        }
        sb.append("OMList with ").append(this.size()).append(" object").append(this.size() == 1 ? "\n" : "s\n");
        List<T> list = this.graphics;
        synchronized (list) {
            StringBuffer sb1 = new StringBuffer();
            for (int i = 0; i < level; ++i) {
                sb1.append("     ");
            }
            String spacer = sb1.toString();
            String levelHeader = level == 0 ? "" : "|--> ";
            for (OMGeometry omg : this.graphics) {
                String description = "";
                description = omg instanceof OMList ? ((OMList)omg).getDescription(level + 1) : levelHeader + omg.getDescription();
                sb.append(spacer).append(description).append("\n");
            }
        }
        return sb.toString();
    }

    public void setVague(boolean value) {
        this.vague = value;
    }

    public boolean isVague() {
        return this.vague;
    }

    @Override
    public Iterator<T> iterator() {
        return this.graphics.iterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.graphics.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int size) {
        return this.graphics.listIterator(size);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.graphics.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.graphics.size();
    }

    @Override
    public boolean isEmpty() {
        return this.graphics.isEmpty();
    }

    @Override
    public void clear() {
        this.graphics.clear();
    }

    @Override
    public int indexOf(Object o) {
        return this.graphics.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.graphics.lastIndexOf(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            if (this.contains(o)) continue;
            this.remove(o);
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        boolean ret = false;
        if (o != null) {
            List<T> list = this.graphics;
            synchronized (list) {
                for (OMGeometry omg : this.graphics) {
                    if (o != omg && (!(omg instanceof OMList) || !((OMList)omg).contains(o))) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T g) {
        this.checkForDuplicate(g);
        List<T> list = this.graphics;
        synchronized (list) {
            return this.graphics.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(int index, T g) {
        this.checkForDuplicate(g);
        List<T> list = this.graphics;
        synchronized (list) {
            this.graphics.add(index, g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        List<T> list = this.graphics;
        synchronized (list) {
            return this.graphics.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E[] toArray(E[] a) {
        List<T> list = this.graphics;
        synchronized (list) {
            return this.graphics.toArray(a);
        }
    }

    public void setTraverseMode(int mode) {
        this.traverseMode = mode;
    }

    public int getTraverseMode() {
        return this.traverseMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getWithObject(Object appObj) {
        List<T> list = this.graphics;
        synchronized (list) {
            for (OMGeometry omg : this.graphics) {
                Object obj = omg.getAppObject();
                if (obj != appObj && (appObj == null || !appObj.equals(obj))) continue;
                return (T)omg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object geometry) {
        boolean found = false;
        List<T> list = this.graphics;
        synchronized (list) {
            found = this.graphics.remove(geometry);
            if (!found && !this.isVague()) {
                for (OMGeometry graphic : this.graphics) {
                    if (!(graphic instanceof OMList)) continue;
                    found = ((OMList)graphic).remove(geometry);
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        List<T> list = this.graphics;
        synchronized (list) {
            return (T)((OMGeometry)this.graphics.remove(index));
        }
    }

    public final synchronized List<T> getCopy() {
        ArrayList<T> listCopy = new ArrayList<T>(this.graphics);
        return Collections.unmodifiableList(listCopy);
    }

    public void moveIndexedOneToTop(int location) {
        if (this.traverseMode == 1) {
            this.moveIndexedOneToFront(location);
        } else {
            this.moveIndexedOneToBack(location);
        }
    }

    public void moveIndexedToTop(int location) {
        if (this.traverseMode == 1) {
            this.moveIndexedToFirst(location);
        } else {
            this.moveIndexedToLast(location);
        }
    }

    public void moveIndexedOneToBottom(int location) {
        if (this.traverseMode == 1) {
            this.moveIndexedOneToBack(location);
        } else {
            this.moveIndexedOneToFront(location);
        }
    }

    public void moveIndexedToBottom(int location) {
        if (this.traverseMode == 1) {
            this.moveIndexedToLast(location);
        } else {
            this.moveIndexedToFirst(location);
        }
    }

    public void moveIndexedToFirst(int location) {
        int listSize = this.size();
        if (location > 0 && location < listSize) {
            OMGeometry tmpGraphic = (OMGeometry)this.get(location);
            for (int i = location; i > 0; --i) {
                this.set(i, this.get(i - 1));
            }
            this.graphics.set(0, tmpGraphic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveIndexedOneToFront(int location) {
        int listSize = this.size();
        if (location > 0 && location < listSize) {
            List<T> list = this.graphics;
            synchronized (list) {
                OMGeometry tmpGraphic = (OMGeometry)this.get(location);
                this.graphics.set(location, this.get(location - 1));
                this.graphics.set(location - 1, tmpGraphic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveIndexedToLast(int location) {
        int listSize = this.size();
        if (location < listSize - 1 && location >= 0) {
            List<T> list = this.graphics;
            synchronized (list) {
                OMGeometry tmpGraphic = (OMGeometry)this.get(location);
                for (int i = location; i < listSize - 1; ++i) {
                    this.set(i, this.get(i + 1));
                }
                this.graphics.set(listSize - 1, tmpGraphic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveIndexedOneToBack(int location) {
        int listSize = this.size();
        if (location < listSize - 1 && location >= 0) {
            List<T> list = this.graphics;
            synchronized (list) {
                OMGeometry tmpGraphic = (OMGeometry)this.get(location);
                this.graphics.set(location, this.get(location + 1));
                this.graphics.set(location + 1, tmpGraphic);
            }
        }
    }

    public void project(Projection p) {
        this.generate(p, false);
    }

    public void project(Projection p, boolean forceProjectAll) {
        this.generate(p, forceProjectAll);
    }

    @Override
    public boolean generate(Projection p) {
        return this.generate(p, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(Projection p, boolean forceProjectAll) {
        boolean ret = true;
        List<T> list = this.graphics;
        synchronized (list) {
            Iterator<T> iterator = this.iterator();
            if (forceProjectAll) {
                while (iterator.hasNext()) {
                    ret &= ((OMGeometry)iterator.next()).generate(p);
                }
            } else {
                while (iterator.hasNext()) {
                    ret &= ((OMGeometry)iterator.next()).regenerate(p);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics gr) {
        if (this.isVague() && !this.isVisible()) {
            return;
        }
        List<T> list = this.graphics;
        synchronized (list) {
            if (this.traverseMode == 1) {
                ListIterator<T> iterator = this.graphics.listIterator(this.size());
                while (iterator.hasPrevious()) {
                    OMGeometry graphic = (OMGeometry)iterator.previous();
                    if (!this.shouldProcess(graphic)) continue;
                    graphic.render(gr);
                }
            } else {
                ListIterator<T> iterator = this.graphics.listIterator();
                while (iterator.hasNext()) {
                    OMGeometry graphic = (OMGeometry)iterator.next();
                    if (!this.shouldProcess(graphic)) continue;
                    graphic.render(gr);
                }
            }
        }
        this.renderLabel(gr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void renderAllAsSelected(Graphics gr) {
        List<T> list = this.graphics;
        synchronized (list) {
            if (this.traverseMode == 1) {
                ListIterator<T> iterator = this.graphics.listIterator(this.size());
                while (iterator.hasPrevious()) {
                    OMGeometry graphic = (OMGeometry)iterator.previous();
                    if (!this.shouldProcess(graphic)) continue;
                    graphic.select();
                    graphic.render(gr);
                    graphic.deselect();
                }
            } else {
                ListIterator<T> iterator = this.graphics.listIterator();
                while (iterator.hasNext()) {
                    OMGeometry graphic = (OMGeometry)iterator.next();
                    if (!this.shouldProcess(graphic)) continue;
                    graphic.select();
                    graphic.render(gr);
                    graphic.deselect();
                }
            }
        }
    }

    protected boolean shouldProcess(OMGeometry graphic) {
        return this.processAllGeometries || graphic.isVisible();
    }

    public void setProcessAllGeometries(boolean set) {
        this.processAllGeometries = set;
    }

    public boolean getProcessAllGeometries() {
        return this.processAllGeometries;
    }

    @Override
    public float distance(double x, double y) {
        return this.findClosest((double)x, (double)y, (float)Float.MAX_VALUE, (boolean)false).d;
    }

    protected abstract OMDist<T> createDist();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMDist<T> findClosest(double x, double y, float limit, boolean resetSelect) {
        OMDist omd = new OMDist();
        List<T> list = this.graphics;
        synchronized (list) {
            if (!this.isEmpty()) {
                if (this.traverseMode == 1) {
                    int i = 0;
                    ListIterator<T> iterator = this.graphics.listIterator();
                    while (iterator.hasNext()) {
                        OMDist tomd;
                        if ((tomd = this.findClosestTest(omd, i++, (OMGeometry)iterator.next(), x, y, limit, resetSelect)) == null) continue;
                        omd = tomd;
                        if (omd.d != 0.0f) continue;
                        break;
                    }
                } else {
                    int i = this.size();
                    ListIterator<T> iterator = this.graphics.listIterator(i);
                    while (iterator.hasPrevious()) {
                        OMDist tomd;
                        if ((tomd = this.findClosestTest(omd, i--, (OMGeometry)iterator.previous(), x, y, limit, resetSelect)) == null) continue;
                        omd = tomd;
                        if (omd.d != 0.0f) continue;
                    }
                }
            }
        }
        if (Debug.debugging("omgraphics")) {
            int size = this.size();
            if (omd.omg != null && this.isVague()) {
                omd.omg = this;
                Debug.output(this.getClass().getName() + "(" + size + ") detecting hit and vagueness, returning " + omd);
            } else if (omd.omg != null && !this.isVague()) {
                Debug.output(this.getClass().getName() + "(" + size + ") detecting hit, no vagueness, returning contained " + omd);
            } else {
                Debug.output(this.getClass().getName() + "(" + size + ") omd.omg " + (omd.omg == null ? "== null" : "!= null"));
            }
        }
        return omd;
    }

    protected OMDist<T> findClosestTest(OMDist<T> current, int index, OMGeometry graphic, double x, double y, float limit, boolean resetSelect) {
        if (current == null) {
            current = this.createDist();
        }
        float currentDistance = Float.MAX_VALUE;
        if (!this.shouldProcess(graphic)) {
            return current;
        }
        if (graphic instanceof OMList) {
            OMList omgl = (OMList)graphic;
            OMDist<T> dist = omgl.findClosest(x, y, limit, resetSelect);
            if (dist.omg != null) {
                currentDistance = dist.d;
                graphic = (OMGeometry)dist.omg;
            }
        } else {
            if (resetSelect) {
                graphic.deselect();
            }
            currentDistance = graphic.distance(x, y);
        }
        if (currentDistance < limit && currentDistance < current.d) {
            current.omg = !this.isVague() ? graphic : this;
            current.index = index;
            current.d = currentDistance;
        }
        return current;
    }

    public T findClosest(double x, double y, float limit) {
        return (T)((OMGeometry)this.findClosest((double)x, (double)y, (float)limit, (boolean)false).omg);
    }

    public OMList<T> findAll(int x, int y, float limit) {
        return this.findAll(x, y, limit, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OMList<T> findAll(int x, int y, float limit, boolean resetSelect, OMList<T> addTo) {
        if (addTo == null) {
            addTo = this.create();
        }
        OMDist<T> omd = this.createDist();
        if (!this.isEmpty()) {
            List<T> list = this.graphics;
            synchronized (list) {
                if (this.traverseMode == 1) {
                    ListIterator<T> iterator = this.graphics.listIterator();
                    while (iterator.hasNext() && this.findAllTest(x, y, limit, resetSelect, addTo, (OMGeometry)iterator.next(), omd)) {
                    }
                } else {
                    ListIterator<T> iterator = this.graphics.listIterator(this.size());
                    while (iterator.hasPrevious() && this.findAllTest(x, y, limit, resetSelect, addTo, (OMGeometry)iterator.previous(), omd)) {
                    }
                }
            }
        }
        if (Debug.debugging("omgraphics")) {
            Debug.output(this.getClass().getName() + "(" + this.size() + ") detecting hits and vagueness, returning list with " + addTo.size() + " graphics.");
        }
        return addTo;
    }

    public abstract OMList<T> create();

    protected boolean findAllTest(int x, int y, float limit, boolean resetSelect, OMList<T> addTo, OMGeometry geometry, OMDist<T> omd) {
        if (geometry instanceof OMList) {
            OMList<T> tempList = this.create();
            ((OMList)geometry).findAll(x, y, limit, resetSelect, tempList);
            if (!tempList.isEmpty()) {
                if (this.isVague()) {
                    addTo.add(this);
                    return false;
                }
                addTo.addAll(tempList);
                return true;
            }
        } else {
            if ((omd = this.findClosestTest(omd, 0, geometry, x, y, limit, resetSelect)) == null || omd.omg == null) {
                return true;
            }
            if (this.isVague()) {
                addTo.add(this);
                return false;
            }
            addTo.add((OMList)((OMGeometry)omd.omg));
            omd.d = Float.MAX_VALUE;
            omd.omg = null;
        }
        return true;
    }

    public T findClosest(int x, int y) {
        return this.findClosest(x, y, Float.MAX_VALUE);
    }

    public int findIndexOfClosest(int x, int y, float limit) {
        return this.findClosest((double)((double)x), (double)((double)y), (float)limit, (boolean)false).index;
    }

    public int findIndexOfClosest(int x, int y) {
        return this.findClosest((double)((double)x), (double)((double)y), (float)Float.MAX_VALUE, (boolean)false).index;
    }

    public T selectClosest(int x, int y) {
        return this.selectClosest(x, y, Float.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T selectClosest(int x, int y, float limit) {
        OMDist<T> omd = null;
        OMGeometry ret = null;
        if (this.isVague() && (omd = this.findClosest(x, y, limit, true)) != null) {
            this.select();
            return (T)this;
        }
        List<T> list = this.graphics;
        synchronized (list) {
            if (!this.isEmpty()) {
                if (this.traverseMode == 1) {
                    ListIterator<T> iterator = this.graphics.listIterator();
                    while (iterator.hasNext()) {
                        OMDist<T> tomd = this.selectClosestTest(omd, 0, (OMGeometry)iterator.next(), x, y, limit);
                        if (tomd == null) continue;
                        omd = tomd;
                        if (omd.d != 0.0f) continue;
                        break;
                    }
                } else {
                    ListIterator<T> iterator = this.graphics.listIterator(this.size());
                    while (iterator.hasPrevious()) {
                        OMDist<T> tomd = this.selectClosestTest(omd, 0, (OMGeometry)iterator.previous(), x, y, limit);
                        if (tomd == null) continue;
                        omd = tomd;
                        if (omd.d != 0.0f) continue;
                    }
                }
            }
        }
        if (omd != null) {
            ret = (OMGeometry)omd.omg;
        }
        return (T)ret;
    }

    protected OMDist<T> selectClosestTest(OMDist<T> current, int index, OMGeometry graphic, int x, int y, float limit) {
        if (current == null) {
            current = this.createDist();
        }
        OMGeometry oldGraphic = (OMGeometry)current.omg;
        OMDist<T> ret = this.findClosestTest(current, index, graphic, x, y, limit, true);
        if (ret != null && oldGraphic != ret.omg) {
            if (oldGraphic != null) {
                oldGraphic.deselect();
            }
            ((OMGeometry)ret.omg).select();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getContains(int x, int y) {
        OMGeometry ret = null;
        List<T> list = this.graphics;
        synchronized (list) {
            if (!this.isEmpty()) {
                if (this.traverseMode == 1) {
                    ListIterator<T> iterator = this.graphics.listIterator();
                    while (iterator.hasNext()) {
                        OMGeometry graphic = (OMGeometry)iterator.next();
                        if (!this.shouldProcess(graphic)) continue;
                        if (graphic instanceof OMList) {
                            OMList tomgl = (OMList)graphic;
                            ret = tomgl.getContains(x, y);
                            if (ret == null) continue;
                            if (!tomgl.isVague()) break;
                            ret = graphic;
                            break;
                        }
                        if (!graphic.contains(x, y)) continue;
                        ret = graphic;
                        break;
                    }
                } else {
                    ListIterator<T> iterator = this.graphics.listIterator(this.size());
                    while (iterator.hasPrevious()) {
                        OMGeometry graphic = (OMGeometry)iterator.previous();
                        if (!this.shouldProcess(graphic)) continue;
                        if (graphic instanceof OMList) {
                            OMList tomgl = (OMList)graphic;
                            ret = tomgl.getContains(x, y);
                            if (ret == null) continue;
                            if (!tomgl.isVague()) break;
                            ret = graphic;
                            break;
                        }
                        if (!graphic.contains(x, y)) continue;
                        ret = graphic;
                        break;
                    }
                }
            }
        }
        if (ret != null && this.isVague()) {
            ret = this;
        }
        return (T)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deselect() {
        super.deselect();
        List<T> list = this.graphics;
        synchronized (list) {
            for (OMGeometry omg : this.graphics) {
                omg.deselect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void select() {
        super.select();
        List<T> list = this.graphics;
        synchronized (list) {
            for (OMGeometry omg : this.graphics) {
                omg.select();
            }
        }
    }

    public void doAction(T graphic, OMAction action) {
        boolean alreadyOnList;
        Debug.message("omgl", "OMList.doAction()");
        if (graphic == null) {
            return;
        }
        int i = this.indexOf(graphic);
        boolean bl = alreadyOnList = i != -1;
        if (action == null || action.getValue() == 0 && !alreadyOnList) {
            Debug.message("omgl", "OMGraphicList.doAction: adding graphic with null action");
            this.add(graphic);
            return;
        }
        if (action.isMask(64) || action.isMask(128) && !alreadyOnList) {
            Debug.message("omgl", "OMGraphicList.doAction: adding graphic");
            this.add(graphic);
        }
        if (action.isMask(4)) {
            Debug.message("omgl", "OMGraphicList.doAction: removing graphic");
            this.remove(graphic);
        }
        if (action.isMask(256)) {
            Debug.message("omgl", "OMGraphicList.doAction: raising graphic");
            this.moveIndexedOneToTop(i);
        }
        if (action.isMask(1)) {
            Debug.message("omgl", "OMGraphicList.doAction: raising graphic to top");
            this.moveIndexedToTop(i);
        }
        if (action.isMask(512)) {
            Debug.message("omgl", "OMGraphicList.doAction: lowering graphic");
            this.moveIndexedOneToBottom(i);
        }
        if (action.isMask(2)) {
            Debug.message("omgl", "OMGraphicList.doAction: lowering graphic to bottom");
            this.moveIndexedOneToBottom(i);
        }
        if (action.isMask(32)) {
            Debug.message("omgl", "OMGraphicList.doAction: deselecting all graphics.");
            this.deselect();
        }
        if (action.isMask(1024)) {
            Debug.message("omgl", "OMGraphicList.doAction: sorting the list");
            this.sort();
        }
        if (action.isMask(8)) {
            Debug.message("omgl", "OMGraphicList.doAction: selecting graphic");
            graphic.select();
        }
        if (action.isMask(16)) {
            Debug.message("omgl", "OMGraphicList.doAction: deselecting graphic");
            graphic.deselect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!this.isVague()) {
            List<T> list = this.graphics;
            synchronized (list) {
                Iterator<T> it = this.iterator();
                while (it.hasNext()) {
                    ((OMGeometry)it.next()).setVisible(visible);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisible() {
        if (!this.isVague()) {
            List<T> list = this.graphics;
            synchronized (list) {
                for (OMGeometry omg : this.graphics) {
                    if (!omg.isVisible()) continue;
                    return true;
                }
            }
            return false;
        }
        return super.isVisible();
    }

    public void setAllowDuplicates(boolean set) {
        this.allowDuplicates = set;
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    protected void checkForDuplicate(T g) {
        if (!this.allowDuplicates) {
            this.remove(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(OMGraphic g) {
        if (g != null) {
            List<T> list = this.graphics;
            synchronized (list) {
                for (OMGeometry omg : this.graphics) {
                    if (g != omg && (!(omg instanceof OMList) || !((OMList)omg).contains(g))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void sort() {
    }

    protected OMGraphic objectToOMGraphic(Object obj) {
        if (obj instanceof OMGraphic) {
            return (OMGraphic)obj;
        }
        return null;
    }

    @Override
    public void restore(OMGeometry source) {
        super.restore(source);
        try {
            if (source instanceof OMList) {
                OMList list = (OMList)source;
                for (OMGeometry omg : list) {
                    OMGeometry newCopy = (OMGeometry)ComponentFactory.create(omg.getClass().getName());
                    if (newCopy == null) continue;
                    newCopy.restore(source);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OMDist<T> {
        public T omg = null;
        public float d = Float.POSITIVE_INFINITY;
        public int index = -1;

        protected OMDist() {
        }

        public String toString() {
            return "OMDist: omg=" + (this.omg == null ? "null" : this.omg.getClass().getName()) + ", d=" + this.d + ", index=" + this.index;
        }
    }
}

