/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FanCompress;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerGraphicWarehouseSupport
implements VPFGraphicWarehouse {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.vpf.VPFGraphicWarehouse");
    protected DrawingAttributes drawingAttributes;
    protected static final transient float antarcticaThreshold = ProjMath.degToRad(-89.9f);
    protected OMGraphicList graphics;
    private boolean drawEdgeFeatures;
    private boolean drawTextFeatures;
    private boolean drawAreaFeatures;
    private boolean drawEPointFeatures;
    private boolean drawCPointFeatures;
    private static boolean doThinning = false;
    private static double fan_eps = 0.01f;
    private List<String> useLibrary = null;
    protected OMGraphicList areaSubList;
    protected OMGraphicList edgeSubList;
    protected OMGraphicList textSubList;
    protected OMGraphicList pointSubList;

    public LayerGraphicWarehouseSupport() {
        this.initDrawingAttributes();
        this.graphics = new OMGraphicList();
        this.graphics.setTraverseMode(0);
    }

    protected void initDrawingAttributes() {
        this.drawingAttributes = new DrawingAttributes();
    }

    public synchronized OMGraphicList getGraphics() {
        return this.getGraphics(this.graphics);
    }

    protected synchronized OMGraphicList getGraphics(OMGraphicList addToList) {
        if (this.areaSubList != null) {
            addToList.add(this.areaSubList);
        }
        if (this.edgeSubList != null) {
            addToList.add(this.edgeSubList);
        }
        if (this.pointSubList != null) {
            addToList.add(this.pointSubList);
        }
        if (this.textSubList != null) {
            addToList.add(this.textSubList);
        }
        return addToList;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    @Override
    public void resetForCAT() {
    }

    @Override
    public void setUseLibraries(List<String> lib) {
        this.useLibrary = lib;
    }

    @Override
    public List<String> getUseLibraries() {
        return this.useLibrary;
    }

    @Override
    public boolean checkLibraryForUsage(String libName) {
        boolean useLibrary = true;
        List<String> libraryNames = this.getUseLibraries();
        if (libraryNames != null && !libraryNames.isEmpty()) {
            useLibrary = false;
            for (String libraryName : libraryNames) {
                if (!libName.startsWith(libraryName)) continue;
                useLibrary = true;
                break;
            }
        }
        return useLibrary;
    }

    @Override
    public Component getGUI(LibrarySelectionTable lst) {
        if (this.drawingAttributes != null) {
            return this.drawingAttributes.getGUI();
        }
        return null;
    }

    public void clear() {
        this.graphics.clear();
        if (this.areaSubList != null) {
            this.areaSubList.clear();
            this.areaSubList = null;
        }
        if (this.edgeSubList != null) {
            this.edgeSubList.clear();
            this.edgeSubList = null;
        }
        if (this.textSubList != null) {
            this.textSubList.clear();
            this.textSubList = null;
        }
        if (this.pointSubList != null) {
            this.pointSubList.clear();
            this.pointSubList = null;
        }
    }

    protected void addArea(OMGraphic area) {
        if (this.areaSubList == null) {
            this.areaSubList = new OMGraphicList();
        }
        this.areaSubList.add(area);
    }

    protected void addEdge(OMGraphic edge) {
        if (this.edgeSubList == null) {
            this.edgeSubList = new OMGraphicList();
        }
        this.edgeSubList.add(edge);
    }

    protected void addText(OMGraphic text) {
        if (this.textSubList == null) {
            this.textSubList = new OMGraphicList();
        }
        this.textSubList.add(text);
    }

    protected void addPoint(OMGraphic point) {
        if (this.pointSubList == null) {
            this.pointSubList = new OMGraphicList();
        }
        this.pointSubList.add(point);
    }

    public void setEdgeFeatures(boolean newvalue) {
        this.drawEdgeFeatures = newvalue;
    }

    @Override
    public boolean drawEdgeFeatures() {
        return this.drawEdgeFeatures;
    }

    public void setTextFeatures(boolean newvalue) {
        this.drawTextFeatures = newvalue;
    }

    @Override
    public boolean drawTextFeatures() {
        return this.drawTextFeatures;
    }

    public void setAreaFeatures(boolean newvalue) {
        this.drawAreaFeatures = newvalue;
    }

    @Override
    public boolean drawAreaFeatures() {
        return this.drawAreaFeatures;
    }

    public void setEPointFeatures(boolean newvalue) {
        this.drawEPointFeatures = newvalue;
    }

    @Override
    public boolean drawEPointFeatures() {
        return this.drawEPointFeatures;
    }

    public void setCPointFeatures(boolean newvalue) {
        this.drawCPointFeatures = newvalue;
    }

    @Override
    public boolean drawCPointFeatures() {
        return this.drawCPointFeatures;
    }

    public void setFeatures(String features) {
        this.setAreaFeatures(false);
        this.setEdgeFeatures(false);
        this.setTextFeatures(false);
        this.setEPointFeatures(false);
        this.setCPointFeatures(false);
        StringTokenizer t = new StringTokenizer(features);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.equalsIgnoreCase("Area")) {
                this.setAreaFeatures(true);
                continue;
            }
            if (token.equalsIgnoreCase("Edge")) {
                this.setEdgeFeatures(true);
                continue;
            }
            if (token.equalsIgnoreCase("EPoint")) {
                this.setEPointFeatures(true);
                continue;
            }
            if (token.equalsIgnoreCase("CPoint")) {
                this.setCPointFeatures(true);
                continue;
            }
            if (token.equalsIgnoreCase("Text")) {
                this.setTextFeatures(true);
                continue;
            }
            Debug.output("LayerGraphicsWarehouseSupport: ignoring feature: " + token);
        }
    }

    public String getFeatureString() {
        StringBuffer features = new StringBuffer();
        if (this.drawAreaFeatures) {
            features.append("Area".toLowerCase()).append(" ");
        }
        if (this.drawEdgeFeatures) {
            features.append("Edge".toLowerCase()).append(" ");
        }
        if (this.drawEPointFeatures) {
            features.append("EPoint".toLowerCase()).append(" ");
        }
        if (this.drawCPointFeatures) {
            features.append("CPoint".toLowerCase()).append(" ");
        }
        if (this.drawTextFeatures) {
            features.append("Text".toLowerCase()).append(" ");
        }
        return features.toString();
    }

    public void setProperties(String prefix, Properties props) {
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String features = props.getProperty(realPrefix + "featureTypes");
        this.drawingAttributes.setProperties(prefix, props);
        if (features != null) {
            this.setFeatures(features);
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String realPrefix = PropUtils.getScopedPropertyPrefix(this.drawingAttributes);
        props.put(realPrefix + "featureTypes", this.getFeatureString());
        this.drawingAttributes.getProperties(props);
        return props;
    }

    public static OMPoly createAreaOMPoly(List<CoordFloatString> ipts, int totalSize, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, boolean doAntarcticaWorkaround) {
        double[] llpts = new double[totalSize * 2];
        if (doAntarcticaWorkaround) {
            doAntarcticaWorkaround = ll2.getLatitude() < -62.0f;
        }
        int npts = 0;
        for (CoordFloatString cfs : ipts) {
            int i;
            int cfscnt = cfs.tcount;
            int cfssz = cfs.tsize;
            double[] cfsvals = cfs.vals;
            if (cfscnt > 0) {
                for (i = 0; i < cfscnt; ++i) {
                    llpts[npts++] = ProjMath.degToRad(cfsvals[i * cfssz + 1]);
                    llpts[npts++] = ProjMath.degToRad(cfsvals[i * cfssz]);
                }
                continue;
            }
            for (i = (cfscnt *= -1) - 1; i >= 0; --i) {
                llpts[npts++] = ProjMath.degToRad(cfsvals[i * cfssz + 1]);
                llpts[npts++] = ProjMath.degToRad(cfsvals[i * cfssz]);
            }
        }
        if (doAntarcticaWorkaround) {
            double[] newllpts = new double[llpts.length];
            for (int i = 0; i < newllpts.length; i += 2) {
                newllpts[i] = llpts[i];
                newllpts[i + 1] = llpts[i + 1];
                if (!(newllpts[i] < (double)antarcticaThreshold)) continue;
                Debug.message("vpf", "AreaTable.generateOMPoly(): Antarctica!");
                newllpts[i++] = ProjMath.degToRad(-89.99f);
                newllpts[i++] = ProjMath.degToRad(179.99f);
                newllpts[i++] = ProjMath.degToRad(-89.99f);
                newllpts[i++] = ProjMath.degToRad(90.0f);
                newllpts[i++] = ProjMath.degToRad(-89.99f);
                newllpts[i++] = ProjMath.degToRad(0.0f);
                newllpts[i++] = ProjMath.degToRad(-89.99f);
                newllpts[i++] = ProjMath.degToRad(-90.0f);
                newllpts[i++] = ProjMath.degToRad(-89.99f);
                newllpts[i++] = ProjMath.degToRad(-179.99f);
                while (llpts[i + 1] > 0.0) {
                    newllpts[i++] = ProjMath.degToRad(-89.99f);
                    newllpts[i++] = ProjMath.degToRad(-179.99f);
                }
                i -= 2;
            }
            llpts = newllpts;
        }
        OMPoly py = new OMPoly(llpts, 1, 1);
        return py;
    }

    public static OMPoly createEdgeOMPoly(CoordFloatString coords, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon) {
        double[] llpts = coords.vals;
        if (coords.tsize > 2) {
            double[] newllpts = new double[coords.tcount * 2];
            int len = newllpts.length;
            int i = 0;
            int j = 0;
            while (i < len) {
                newllpts[i] = ProjMath.degToRad(llpts[j + 1]);
                newllpts[i + 1] = ProjMath.degToRad(llpts[j]);
                i += 2;
                j += 3;
            }
            llpts = newllpts;
        } else {
            int len = llpts.length;
            for (int i = 0; i < len; i += 2) {
                double lon = ProjMath.degToRad(llpts[i]);
                llpts[i] = ProjMath.degToRad(llpts[i + 1]);
                llpts[i + 1] = lon;
            }
        }
        OMPoly py = new OMPoly(llpts, 1, 1);
        return py;
    }

    public static void setDoThinning(boolean value) {
        doThinning = value;
    }

    public static boolean isDoThinning() {
        return doThinning;
    }

    public static void setFanEpsilon(double value) {
        fan_eps = value;
    }

    public static double getFanEpsilon() {
        return fan_eps;
    }

    protected static int doThinning(List<Object> ipts) {
        int size = ipts.size();
        int totalSize = 0;
        for (int j = 0; j < size; ++j) {
            boolean rev;
            CoordFloatString cfs = (CoordFloatString)ipts.get(j);
            int cfscnt = cfs.tcount;
            int cfssz = cfs.tsize;
            double[] cfsvals = cfs.vals;
            int npts = 0;
            boolean bl = rev = cfscnt < 0;
            if (rev) {
                cfscnt = -cfscnt;
            }
            double[] llpts = new double[cfscnt << 1];
            for (int i = 0; i < cfscnt; ++i) {
                llpts[npts++] = cfsvals[i * cfssz];
                llpts[npts++] = cfsvals[i * cfssz + 1];
            }
            FanCompress.FloatCompress fan = new FanCompress.FloatCompress(llpts);
            FanCompress.fan_compress(fan, fan_eps);
            cfs.vals = fan.getArray();
            cfs.tcount = cfs.vals.length >>> 1;
            cfs.tsize = 2;
            totalSize += cfs.tcount;
            if (!rev) continue;
            cfs.tcount *= -1;
        }
        return totalSize;
    }

    public static OMText createOMText(String text, double latitude, double longitude) {
        OMText txt = new OMText(latitude, longitude, text, 0);
        return txt;
    }

    public static OMPoint createOMPoint(double latitude, double longitude) {
        return new OMPoint(latitude, longitude);
    }
}

