/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeTable
extends PrimitiveTable {
    private static final String[] edgcolumns = new String[]{"id", "start_node", "end_node", "right_face", "left_face", "right_edge", "left_edge", "coordinates"};

    public EdgeTable(CoverageTable cov, TileDirectory tile) throws FormatException {
        super(cov, tile, "edg");
        if (Debug.debugging("vpf")) {
            Debug.output("EdgeTable(): " + this.filename);
        }
        if (cov.cachedLineSchema == null) {
            cov.cachedLineSchema = this.lookupSchema(edgcolumns, false);
        }
    }

    @Override
    public final int getID(List<Number> l) {
        return l.get(this.covtable.cachedLineSchema[0]).intValue();
    }

    public final int getStartNode(List<Object> l) {
        return ((Number)l.get(this.covtable.cachedLineSchema[1])).intValue();
    }

    public final int getEndNode(List<Object> l) {
        return ((Number)l.get(this.covtable.cachedLineSchema[2])).intValue();
    }

    public final TilingAdapter getRightFaceTilingAdapter() {
        return this.getTilingAdapter("right_face");
    }

    public final TilingAdapter getLeftFaceTilingAdapter() {
        return this.getTilingAdapter("left_face");
    }

    public final TilingAdapter getRightEdgeTilingAdapter() {
        return this.getTilingAdapter("right_edge");
    }

    public final TilingAdapter getLeftEdgeTilingAdapter() {
        return this.getTilingAdapter("left_edge");
    }

    public final CoordFloatString getCoordinates(List<Object> l) {
        return (CoordFloatString)l.get(this.covtable.cachedLineSchema[7]);
    }

    public int topologyLevel() {
        if (this.covtable.cachedLineSchema[1] == -1) {
            return 0;
        }
        if (this.covtable.cachedLineSchema[3] == -1) {
            return 2;
        }
        return 3;
    }

    @Override
    public CoverageTable getCoverageTable() {
        return this.covtable;
    }

    @Override
    public void drawTile(VPFGraphicWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        if (warehouse == null) {
            return;
        }
        try {
            this.seekToRow(1);
            ArrayList<Object> edge = new ArrayList<Object>();
            while (this.parseRow(edge)) {
                warehouse.createEdge(this.covtable, this, edge, ll1, ll2, dpplat, dpplon, this.getCoordinates(edge));
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    @Override
    public OMGraphic drawFeature(VPFFeatureWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2, List<Object> edge, String featureType, int primID) {
        if (warehouse != null) {
            return warehouse.createEdge(this.covtable, this, edge, ll1, ll2, dpplat, dpplon, this.getCoordinates(edge), featureType, primID);
        }
        return null;
    }
}

