/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.shape.DbfHandler;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SpatialIndexHandler
implements PropertyConsumer {
    protected SpatialIndex spatialIndex;
    protected String shapeFileName = null;
    protected String imageURLString = null;
    protected GeoCoordTransformation coordTranslator;
    protected String prettyName = null;
    protected DrawingAttributes drawingAttributes;
    protected boolean enabled = true;
    protected boolean buffered = false;
    protected String propertyPrefix;
    public static final String EnabledProperty = "enabled";
    public static final String BufferedProperty = "buffered";
    protected I18n i18n = Environment.getI18n();
    protected OMGraphicList bufferedList = null;

    public SpatialIndexHandler() {
    }

    public SpatialIndexHandler(String prefix, Properties props) {
        this.setProperties(prefix, props);
    }

    public static SpatialIndex create(String prefix, Properties props) {
        SpatialIndexHandler sih = new SpatialIndexHandler(prefix, props);
        return sih.getSpatialIndex();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("For ").append(this.prettyName).append(":\n");
        sb.append("  Shape file name: ").append(this.shapeFileName).append("\n");
        sb.append("  Spatal index file name: ").append(SpatialIndex.ssx(this.shapeFileName)).append("\n");
        sb.append("  image URL: ").append(this.imageURLString).append("\n");
        sb.append("  drawing attributes: ").append(this.drawingAttributes).append("\n");
        return sb.toString();
    }

    public JComponent getGUI() {
        JPanel stuff = new JPanel();
        stuff.setBorder(BorderFactory.createRaisedBevelBorder());
        stuff.add(this.drawingAttributes.getGUI());
        JPanel checks = new JPanel(new GridLayout(0, 1));
        JCheckBox enableButton = new JCheckBox(this.i18n.get(SpatialIndexHandler.class, "enableButton", "Show"));
        enableButton.setSelected(this.enabled);
        enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox jcb = (JCheckBox)ae.getSource();
                SpatialIndexHandler.this.enabled = jcb.isSelected();
            }
        });
        checks.add(enableButton);
        JCheckBox bufferButton = new JCheckBox(this.i18n.get(SpatialIndexHandler.class, "bufferButton", "Buffer"));
        bufferButton.setSelected(this.buffered);
        bufferButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox jcb = (JCheckBox)ae.getSource();
                SpatialIndexHandler.this.buffered = jcb.isSelected();
            }
        });
        checks.add(bufferButton);
        stuff.add(checks);
        return stuff;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.prettyName = props.getProperty(realPrefix + "prettyName");
        String dataPathPrefix = props.getProperty(prefix + "dataPathPrefix");
        dataPathPrefix = dataPathPrefix != null && dataPathPrefix.length() > 0 ? dataPathPrefix + "/" : "";
        this.shapeFileName = dataPathPrefix + props.getProperty(realPrefix + "shapeFile");
        if (this.shapeFileName != null && this.shapeFileName.endsWith(".shp")) {
            block14: {
                this.spatialIndex = SpatialIndex.locateAndSetShapeData(this.shapeFileName);
                String dbfFileName = SpatialIndex.dbf(this.shapeFileName);
                try {
                    if (BinaryFile.exists(dbfFileName)) {
                        BinaryBufferedFile bbf = new BinaryBufferedFile(dbfFileName);
                        DbfHandler dbfh = new DbfHandler(bbf);
                        dbfh.setProperties(realPrefix, props);
                        this.spatialIndex.setDbf(dbfh);
                    }
                }
                catch (FormatException fe) {
                    if (Debug.debugging("shape")) {
                        Debug.error("ShapeLayer: Couldn't create DBF handler for " + dbfFileName + ", FormatException: " + fe.getMessage());
                    }
                }
                catch (IOException ioe) {
                    if (!Debug.debugging("shape")) break block14;
                    Debug.error("ShapeLayer: Couldn't create DBF handler for " + dbfFileName + ", IOException: " + ioe.getMessage());
                }
            }
            this.imageURLString = props.getProperty(realPrefix + "pointImageURL");
            try {
                if (this.imageURLString != null && this.imageURLString.length() > 0) {
                    URL imageURL = PropUtils.getResourceOrFileOrURL(this, this.imageURLString);
                    ImageIcon imageIcon = new ImageIcon(imageURL);
                    this.spatialIndex.setPointIcon(imageIcon);
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("MultiShapeLayer.setProperties(" + realPrefix + ": point image URL not so good: \n\t" + this.imageURLString);
            }
            catch (NullPointerException npe) {
                Debug.error("Can't access icon image: \n" + this.imageURLString);
            }
        } else {
            Debug.error(realPrefix + ": No shape file name provided:");
            Debug.error("\t" + realPrefix + "shapeFile");
        }
        this.drawingAttributes = new DrawingAttributes(realPrefix, props);
        this.enabled = PropUtils.booleanFromProperties(props, realPrefix + EnabledProperty, this.enabled);
        this.buffered = PropUtils.booleanFromProperties(props, realPrefix + BufferedProperty, this.buffered);
        String transClassName = props.getProperty(realPrefix + "transform");
        if (transClassName != null) {
            try {
                this.coordTranslator = (GeoCoordTransformation)ComponentFactory.create(transClassName, realPrefix + "transform", props);
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
    }

    public Properties getProperties(Properties props) {
        DbfHandler dbfh;
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "shapeFile", this.shapeFileName == null ? "" : this.shapeFileName);
        props.put(prefix + "pointImageURL", this.imageURLString == null ? "" : this.imageURLString);
        if (this.drawingAttributes != null) {
            this.drawingAttributes.getProperties(props);
        } else {
            DrawingAttributes da = (DrawingAttributes)DrawingAttributes.DEFAULT.clone();
            da.setPropertyPrefix(prefix);
            da.getProperties(props);
        }
        props.put(prefix + EnabledProperty, new Boolean(this.enabled).toString());
        props.put(prefix + BufferedProperty, new Boolean(this.buffered).toString());
        if (this.spatialIndex != null && (dbfh = this.spatialIndex.getDbf()) != null) {
            dbfh.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String interString = this.i18n.get(ShapeLayer.class, "shapeFile", 3, "Location of Shape file - .shp (File, URL or relative file path).");
        props.put("shapeFile", interString);
        interString = this.i18n.get(ShapeLayer.class, "shapeFile", "shapeFile");
        props.put("shapeFile.label", interString);
        props.put("shapeFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(ShapeLayer.class, "pointImageURL", 3, "Image file to use for map location of point data (optional).");
        props.put("pointImageURL", interString);
        interString = this.i18n.get(ShapeLayer.class, "pointImageURL", "pointImageURL");
        props.put("pointImageURL.label", interString);
        props.put("pointImageURL.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        if (this.drawingAttributes != null) {
            this.drawingAttributes.getPropertyInfo(props);
        } else {
            DrawingAttributes.DEFAULT.getPropertyInfo(props);
        }
        interString = this.i18n.get(SpatialIndexHandler.class, EnabledProperty, 3, "Show file contents");
        props.put(EnabledProperty, interString);
        interString = this.i18n.get(SpatialIndexHandler.class, EnabledProperty, EnabledProperty);
        props.put("enabled.label", interString);
        props.put("enabled.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(SpatialIndexHandler.class, BufferedProperty, 3, "Read and hold entire file contents (may be faster)");
        props.put(BufferedProperty, interString);
        interString = this.i18n.get(SpatialIndexHandler.class, BufferedProperty, BufferedProperty);
        props.put("buffered.label", interString);
        props.put("buffered.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    public GeoCoordTransformation getCoordTranslator() {
        return this.coordTranslator;
    }

    public void setCoordTranslator(GeoCoordTransformation coordTranslator) {
        this.coordTranslator = coordTranslator;
    }

    public OMGraphicList getGraphics(double xmin, double ymin, double xmax, double ymax) throws IOException, FormatException {
        return this.getGraphics(xmin, ymin, xmax, ymax, null, null);
    }

    public OMGraphicList getGraphics(double xmin, double ymin, double xmax, double ymax, OMGraphicList list) throws IOException, FormatException {
        return this.getGraphics(xmin, ymin, xmax, ymax, list, null);
    }

    public OMGraphicList getGraphics(double xmin, double ymin, double xmax, double ymax, OMGraphicList list, Projection proj) throws IOException, FormatException {
        if (list == null) {
            list = new OMGraphicList();
        }
        if (!this.buffered) {
            if (this.bufferedList != null) {
                this.bufferedList = null;
            }
            this.spatialIndex.getOMGraphics(xmin, ymin, xmax, ymax, list, this.drawingAttributes, proj, this.coordTranslator);
        } else {
            if (this.bufferedList == null) {
                this.bufferedList = this.getWholePlanet(this.coordTranslator);
            }
            this.checkSpatialIndexEntries(xmin, ymin, xmax, ymax, list, proj);
        }
        return list;
    }

    protected void checkSpatialIndexEntries(double xmin, double ymin, double xmax, double ymax, OMGraphicList retList, Projection proj) throws IOException, FormatException {
        Iterator<SpatialIndex.Entry> entryIt = this.spatialIndex.entryIterator();
        Iterator omgIt = this.bufferedList.iterator();
        OMGraphicList labels = null;
        if (this.spatialIndex.getDbf() != null) {
            labels = new OMGraphicList();
            retList.add(labels);
        }
        while (entryIt.hasNext() && omgIt.hasNext()) {
            SpatialIndex.Entry entry = entryIt.next();
            OMGraphic omg = (OMGraphic)omgIt.next();
            if (!entry.intersects(xmin, ymin, xmax, ymax)) continue;
            this.drawingAttributes.setTo(omg);
            if ((omg = this.spatialIndex.evaluate(omg, labels, proj)) == null) continue;
            omg.generate(proj);
            retList.add(omg);
        }
    }

    protected OMGraphicList getWholePlanet() throws IOException, FormatException {
        return this.getWholePlanet(this.coordTranslator);
    }

    protected OMGraphicList getWholePlanet(GeoCoordTransformation dataTransform) throws IOException, FormatException {
        this.spatialIndex.readIndexFile(null, dataTransform);
        return this.spatialIndex.getAllOMGraphics(null, this.drawingAttributes, null, dataTransform);
    }

    public void setPrettyName(String set) {
        this.prettyName = set;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setBuffered(boolean set) {
        this.buffered = set;
    }

    public boolean getBuffered() {
        return this.buffered;
    }

    public void setDrawingAttributes(DrawingAttributes set) {
        this.drawingAttributes = set;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public void setSpatialIndex(SpatialIndex spatialIndex) {
        this.spatialIndex = spatialIndex;
    }

    public String getShapeFileName() {
        return this.shapeFileName;
    }

    public void setShapeFileName(String shapeFileName) {
        this.shapeFileName = shapeFileName;
    }

    public String getImageURLString() {
        return this.imageURLString;
    }

    public void setImageURLString(String imageURLString) {
        this.imageURLString = imageURLString;
    }

    public void setEnabled(boolean set) {
        this.enabled = set;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean close(boolean done) {
        if (this.spatialIndex != null) {
            return this.spatialIndex.close(done);
        }
        return false;
    }
}

