/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.imageTile;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMWarpingImage;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.proj.coords.MercatorUVGCT;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.propertyEditor.DirectoryPropertyEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MapTileUtilLayer
extends OMGraphicHandlerLayer
implements ListSelectionListener {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.layer.imageTile.MapTileUtilLayer");
    protected String tileRootDir;
    protected HashMap<String, BufferedImage> images = new HashMap();
    protected OMGraphicList omgraphics = new OMGraphicList();
    JPanel gui = null;
    DirectoryPropertyEditor dirEditor = null;
    JButton generateButton = null;
    JButton clearButton = null;
    JList imageList = null;

    public MapTileUtilLayer() {
        this.coordTransform = LatLonGCT.INSTANCE;
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public String getTileRootDir() {
        return this.tileRootDir;
    }

    public void setTileRootDir(String tileRootDir) {
        this.tileRootDir = tileRootDir;
        if (this.generateButton != null) {
            this.generateButton.setEnabled(tileRootDir != null && tileRootDir.length() != 0);
        }
    }

    protected OMGraphicList getOMGraphics() {
        return this.omgraphics;
    }

    protected void setOMGraphics(OMGraphicList omgl) {
        this.omgraphics = omgl;
    }

    public synchronized OMGraphicList prepare() {
        Projection proj;
        OMGraphicList ret = new OMGraphicList();
        OMGraphicList currentList = this.getOMGraphics();
        if (currentList != null) {
            ret.addAll(currentList);
        }
        if ((proj = this.getProjection()) != null) {
            ret.generate(proj);
        }
        return ret;
    }

    protected BufferedImage getImageForZoomLevel(int zoomLevel) {
        int dimensionForZoom = (int)Math.pow(2.0, zoomLevel);
        return new BufferedImage(dimensionForZoom, dimensionForZoom, 2);
    }

    protected OMWarpingImage getOMWarpingImage(BufferedImage bufImage, int zoomLevel) {
        MercatorUVGCT.TMS gct = new MercatorUVGCT.TMS(zoomLevel);
        return new OMWarpingImage(bufImage, (GeoCoordTransformation)gct, new DataBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(bufImage.getWidth(), bufImage.getHeight())));
    }

    protected void colorImage(File zoomLevelDir, BufferedImage bufImage, int rgb) {
        int width = bufImage.getWidth();
        int height = bufImage.getHeight();
        for (int x = 0; x < width; ++x) {
            File rowDir = new File(zoomLevelDir, Integer.toString(x));
            if (!rowDir.exists()) continue;
            for (int y = 0; y < height; ++y) {
                File colFile = new File(rowDir, Integer.toString(y) + ".png");
                if (!colFile.exists()) continue;
                bufImage.setRGB(x, y, rgb);
            }
        }
    }

    protected void generateMapTileImages() {
        File rootFile;
        if (this.imageList == null) {
            logger.info("imageList is null, something weird going on");
            return;
        }
        if (this.images != null) {
            this.images.clear();
        }
        if (this.tileRootDir != null && (rootFile = new File(this.tileRootDir)).exists()) {
            for (int zoomLevel = 0; zoomLevel < 21; ++zoomLevel) {
                BufferedImage buf = this.getImageForZoomLevel(zoomLevel);
                File levelDir = new File(rootFile, Integer.toString(zoomLevel));
                if (!levelDir.exists()) continue;
                this.colorImage(levelDir, buf, 0x77AAAA00);
                this.images.put(levelDir.getName(), buf);
                this.imageList.setListData(this.images.keySet().toArray());
            }
        }
    }

    protected void clearMapTileImages() {
        if (this.images != null) {
            this.images.clear();
        }
        if (this.imageList != null) {
            this.imageList.removeAll();
        }
    }

    public JComponent getGUI() {
        if (this.gui == null) {
            this.gui = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 17;
            c.insets = new Insets(10, 10, 0, 10);
            JLabel label1 = new JLabel("Tile Root Directory:");
            this.gui.add((Component)label1, c);
            this.dirEditor = new DirectoryPropertyEditor();
            this.dirEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent pce) {
                    DirectoryPropertyEditor de = (DirectoryPropertyEditor)pce.getSource();
                    MapTileUtilLayer.this.setTileRootDir(de.getAsText());
                }
            });
            c.gridx = 1;
            c.gridwidth = 2;
            c.fill = 2;
            c.weightx = 1.0;
            this.gui.add(this.dirEditor.getCustomEditor(), c);
            this.imageList = new JList();
            this.imageList.addListSelectionListener(this);
            this.imageList.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane(this.imageList, 20, 30);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 3;
            c.fill = 1;
            c.weighty = 1.0;
            c.insets = new Insets(10, 10, 10, 10);
            this.gui.add((Component)scrollPane, c);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridy = 2;
            c.insets = new Insets(0, 10, 10, 10);
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MapTileUtilLayer.this.clearMapTileImages();
                }
            });
            this.generateButton = new JButton("Generate");
            this.generateButton.setEnabled(this.tileRootDir != null && this.tileRootDir.length() != 0);
            this.generateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MapTileUtilLayer.this.generateMapTileImages();
                }
            });
            c.gridx = 0;
            this.gui.add((Component)this.clearButton, c);
            c.gridx = 2;
            c.anchor = 12;
            this.gui.add((Component)this.generateButton, c);
        }
        return this.gui;
    }

    public static void main(String[] args) {
        logger.info("for zoom level 17: " + Math.pow(2.0, 17.0));
        JFrame frame = new JFrame("GUI");
        MapTileUtilLayer layer = new MapTileUtilLayer();
        frame.setContentPane(layer.getGUI());
        frame.pack();
        frame.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting()) {
            int firstIndex = arg0.getFirstIndex();
            JList list = (JList)arg0.getSource();
            String zoomLevel = list.getSelectedValue().toString();
            if (this.images != null) {
                BufferedImage buf = this.images.get(zoomLevel);
                OMGraphicList omgl = new OMGraphicList();
                OMWarpingImage omwiImage = this.getOMWarpingImage(buf, Integer.parseInt(zoomLevel));
                omgl.add(omwiImage);
                this.setOMGraphics(omgl);
                this.doPrepare();
            }
            this.clearButton.setEnabled(((JList)arg0.getSource()).getComponentCount() > 0);
        }
    }
}

