/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.layer.policy.RenderPolicy;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.layer.policy.StandardRenderPolicy;
import com.bbn.openmap.omGraphics.FilterSupport;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.GestureResponsePolicy;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.omGraphics.event.StandardMapMouseInterpreter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.ISwingWorker;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PooledSwingWorker;
import com.bbn.openmap.util.PropUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMGraphicHandlerLayer
extends Layer
implements GestureResponsePolicy,
OMGraphicHandler {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.OMGraphicHandlerLayer");
    private static final long serialVersionUID = 1L;
    public static final String ProjectionChangePolicyProperty = "projectionChangePolicy";
    public static final String RenderPolicyProperty = "renderPolicy";
    public static final String MouseModesProperty = "mouseModes";
    public static final String ConsumeEventsProperty = "consumeEvents";
    public static final String TransparencyProperty = "transparency";
    public static final String InterruptableProperty = "interruptable";
    protected FilterSupport filter = new FilterSupport();
    protected ProjectionChangePolicy projectionChangePolicy = null;
    protected RenderPolicy renderPolicy = null;
    protected ISwingWorker<OMGraphicList> layerWorker;
    protected ISwingWorker<OMGraphicList> layerWorkerQueue;
    protected String[] mouseModeIDs = null;
    protected boolean consumeEvents = false;
    protected boolean interruptable = true;
    protected boolean wrapItUp = false;
    protected final Object LAYERWORKER_LOCK = new Object();
    protected MapMouseInterpreter mouseEventInterpreter = null;
    protected OMGraphicList selectedList;

    public void setInterruptable(boolean b) {
        this.interruptable = b;
    }

    public boolean isInterruptable() {
        return this.interruptable;
    }

    @Override
    public OMGraphicList filter(Shape withinThisShape) {
        return this.filter.filter(withinThisShape);
    }

    @Override
    public OMGraphicList filter(Shape shapeBoundary, boolean getInsideBoundary) {
        return this.filter.filter(shapeBoundary, getInsideBoundary);
    }

    @Override
    public boolean supportsSQL() {
        return this.filter.supportsSQL();
    }

    @Override
    public OMGraphicList filter(String SQLQuery) {
        return this.filter.filter(SQLQuery);
    }

    @Override
    public boolean doAction(OMGraphic graphic, OMAction action) {
        return this.filter.doAction(graphic, action);
    }

    @Override
    public OMGraphicList getList() {
        return this.filter.getList();
    }

    @Override
    public boolean canSetList() {
        return this.filter.canSetList();
    }

    @Override
    public void setList(OMGraphicList omgl) {
        this.filter.setList(omgl);
    }

    @Override
    public void resetFiltering() {
        this.filter.resetFiltering();
    }

    public void setFilter(FilterSupport fs) {
        this.filter = fs;
    }

    public FilterSupport getFilter() {
        return this.filter;
    }

    @Override
    public void projectionChanged(ProjectionEvent pe) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("OMGraphicHandlerLayer " + this.getName() + " projection changed, calling " + this.getProjectionChangePolicy().getClass().getName());
        }
        this.getProjectionChangePolicy().projectionChanged(pe);
    }

    public ProjectionChangePolicy getProjectionChangePolicy() {
        if (this.projectionChangePolicy == null) {
            this.projectionChangePolicy = new StandardPCPolicy(this);
        }
        return this.projectionChangePolicy;
    }

    public void setProjectionChangePolicy(ProjectionChangePolicy pcp) {
        this.projectionChangePolicy = pcp;
        pcp.setLayer(this);
    }

    public RenderPolicy getRenderPolicy() {
        if (this.renderPolicy == null) {
            this.renderPolicy = new StandardRenderPolicy(this);
        }
        return this.renderPolicy;
    }

    public void setRenderPolicy(RenderPolicy rp) {
        this.renderPolicy = rp;
        rp.setLayer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interrupt() {
        try {
            Object object = this.LAYERWORKER_LOCK;
            synchronized (object) {
                if (this.layerWorker != null && this.interruptable && !this.layerWorker.isInterrupted()) {
                    this.layerWorker.interrupt();
                }
                this.wrapItUp = true;
            }
        }
        catch (SecurityException se) {
            logger.warning(this.getName() + " layer caught a SecurityException when something tried to stop work on the worker thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLayerWorker(ISwingWorker<OMGraphicList> worker) {
        Object object = this.LAYERWORKER_LOCK;
        synchronized (object) {
            this.layerWorker = worker;
            if (this.layerWorker != null) {
                this.wrapItUp = false;
                this.layerWorker.start();
            }
        }
    }

    protected ISwingWorker<OMGraphicList> getLayerWorker() {
        return this.layerWorker;
    }

    protected ISwingWorker<OMGraphicList> createLayerWorker() {
        return new LayerWorker();
    }

    public boolean shouldWrapItUp() {
        return this.wrapItUp;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setList(null);
    }

    @Override
    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            logger.warning("Layer(" + this.getName() + ").renderDataForProjection: null projection!");
            return;
        }
        if (!proj.equals(this.getProjection())) {
            this.setProjection(proj.makeClone());
            this.setList(this.getRenderPolicy().prepare());
        }
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.getRenderPolicy().paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPrepare() {
        Object object = this.LAYERWORKER_LOCK;
        synchronized (object) {
            this.getRenderPolicy().prePrepare();
            if (this.isWorking()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.getName() + " layer already working in prepare(), canceling");
                }
                if (this.layerWorkerQueue == null) {
                    this.setCancelled(true);
                } else {
                    logger.finer("skipping swing worker creation, already queued");
                }
                return;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("creating another layer worker..." + (this.layerWorker == null) + ", " + (this.layerWorkerQueue == null));
            }
            this.setLayerWorker(this.createLayerWorker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorking() {
        Object object = this.LAYERWORKER_LOCK;
        synchronized (object) {
            return this.layerWorker != null;
        }
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList currentList = this.getList();
        Projection proj = this.getProjection();
        if (currentList != null && proj != null) {
            currentList.generate(proj);
        }
        return currentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelled(boolean set) {
        Object object = this.LAYERWORKER_LOCK;
        synchronized (object) {
            if (set && !this.isCancelled() && this.layerWorkerQueue == null) {
                this.layerWorkerQueue = this.createLayerWorker();
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.LAYERWORKER_LOCK;
        synchronized (object) {
            return this.layerWorker != null && this.layerWorker.isInterrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workerComplete(ISwingWorker<OMGraphicList> worker) {
        Object object = this.LAYERWORKER_LOCK;
        synchronized (object) {
            if (this.layerWorkerQueue != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("worker " + worker + " SW launching another because of interruption of thread " + Thread.currentThread().getName());
                }
                this.setLayerWorker(this.layerWorkerQueue);
                this.layerWorkerQueue = null;
            } else {
                OMGraphicList list = worker.get();
                this.setLayerWorker(null);
                if (!worker.isInterrupted()) {
                    this.getProjectionChangePolicy().workerComplete(list);
                }
            }
        }
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        Vector<String> mmv;
        String policyPrefix;
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String pcpString = props.getProperty(realPrefix + ProjectionChangePolicyProperty);
        if (pcpString != null) {
            policyPrefix = realPrefix + pcpString;
            String pcpClass = props.getProperty(policyPrefix + ".class");
            if (pcpClass != null) {
                Object obj = ComponentFactory.create(pcpClass, policyPrefix, props);
                if (obj != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Layer " + this.getName() + " setting ProjectionChangePolicy [" + obj.getClass().getName() + "]");
                    }
                    try {
                        this.setProjectionChangePolicy((ProjectionChangePolicy)obj);
                    }
                    catch (ClassCastException cce) {
                        logger.warning("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for ProjectionChangePolicy, but " + policyPrefix + ".class property (" + pcpClass + ") does not define a valid ProjectionChangePolicy. A " + obj.getClass().getName() + " was created instead.");
                    }
                } else {
                    logger.warning("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for PropertyChangePolicy, but " + policyPrefix + ".class property does not define a valid PropertyChangePolicy.");
                }
            } else if (this.projectionChangePolicy != null) {
                if (this.projectionChangePolicy instanceof PropertyConsumer) {
                    ((PropertyConsumer)((Object)this.projectionChangePolicy)).setProperties(policyPrefix, props);
                }
            } else {
                logger.warning("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for PropertyChangePolicy, but " + policyPrefix + ".class property is undefined.");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Layer " + this.getName() + " using default ProjectionChangePolicy [" + this.getProjectionChangePolicy().getClass().getName() + "]");
        }
        String rpString = props.getProperty(realPrefix + RenderPolicyProperty);
        if (rpString != null) {
            policyPrefix = realPrefix + rpString;
            String rpClass = props.getProperty(policyPrefix + ".class");
            if (rpClass != null) {
                Object rpObj = ComponentFactory.create(rpClass, policyPrefix, props);
                if (rpObj != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Layer " + this.getName() + " setting RenderPolicy [" + rpObj.getClass().getName() + "]");
                    }
                    try {
                        this.setRenderPolicy((RenderPolicy)rpObj);
                    }
                    catch (ClassCastException cce) {
                        logger.warning("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for RenderPolicy, but " + policyPrefix + ".class property (" + rpClass + ") does not define a valid RenderPolicy. A " + rpObj.getClass().getName() + " was created instead.");
                    }
                } else {
                    logger.warning("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for RenderPolicy, but " + policyPrefix + ".class property (" + rpClass + ") isn't being created.");
                }
            } else if (this.renderPolicy != null) {
                if (this.renderPolicy instanceof PropertyConsumer) {
                    ((PropertyConsumer)((Object)this.renderPolicy)).setProperties(policyPrefix, props);
                }
            } else {
                logger.warning("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for RenderPolicy, but " + policyPrefix + ".class property is undefined.");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Layer " + this.getName() + " using default RenderPolicy [" + this.getRenderPolicy().getClass().getName() + "]");
        }
        String mmString = props.getProperty(realPrefix + MouseModesProperty);
        if (mmString != null && !(mmv = PropUtils.parseSpacedMarkers(mmString)).isEmpty()) {
            String[] mm = new String[mmv.size()];
            int i = 0;
            for (String it : mmv) {
                mm[i++] = it;
            }
            this.setMouseModeIDsForEvents(mm);
        }
        this.consumeEvents = PropUtils.booleanFromProperties(props, realPrefix + ConsumeEventsProperty, this.consumeEvents);
        this.setTransparency(PropUtils.floatFromProperties(props, realPrefix + TransparencyProperty, this.getTransparency()));
        this.setInterruptable(PropUtils.booleanFromProperties(props, realPrefix + InterruptableProperty, this.isInterruptable()));
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String policyPrefix = null;
        ProjectionChangePolicy pcp = this.getProjectionChangePolicy();
        if (pcp instanceof PropertyConsumer) {
            policyPrefix = ((PropertyConsumer)((Object)pcp)).getPropertyPrefix();
            ((PropertyConsumer)((Object)pcp)).getProperties(props);
        }
        if (policyPrefix == null) {
            policyPrefix = prefix + "pcp";
        }
        props.put(prefix + ProjectionChangePolicyProperty, policyPrefix.substring(prefix.length()));
        policyPrefix = PropUtils.getScopedPropertyPrefix(policyPrefix);
        props.put(policyPrefix + "class", pcp.getClass().getName());
        RenderPolicy rp = this.getRenderPolicy();
        if (rp instanceof PropertyConsumer) {
            policyPrefix = ((PropertyConsumer)((Object)rp)).getPropertyPrefix();
            ((PropertyConsumer)((Object)rp)).getProperties(props);
        }
        if (policyPrefix == null) {
            policyPrefix = prefix + "rp";
        }
        props.put(prefix + RenderPolicyProperty, policyPrefix.substring(prefix.length()));
        policyPrefix = PropUtils.getScopedPropertyPrefix(policyPrefix);
        props.put(policyPrefix + "class", rp.getClass().getName());
        props.put(prefix + ConsumeEventsProperty, new Boolean(this.consumeEvents).toString());
        String[] mm = this.getMouseModeIDsForEvents();
        if (mm != null && mm.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mm.length; ++i) {
                if (mm[i].equals(this.getName())) continue;
                sb.append(mm[i]).append(" ");
            }
            props.put(prefix + MouseModesProperty, sb.toString());
        }
        props.put(prefix + TransparencyProperty, Float.toString(this.getTransparency()));
        props.put(prefix + InterruptableProperty, Boolean.toString(this.isInterruptable()));
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        String policyPrefix = null;
        ProjectionChangePolicy pcp = this.getProjectionChangePolicy();
        if (pcp instanceof PropertyConsumer && (policyPrefix = ((PropertyConsumer)((Object)pcp)).getPropertyPrefix()) != null) {
            int index = policyPrefix.indexOf(".");
            if (index != -1) {
                policyPrefix = policyPrefix.substring(index + 1);
            }
            ((PropertyConsumer)((Object)pcp)).getPropertyInfo(list);
        }
        if (policyPrefix == null) {
            policyPrefix = "pcp";
        }
        PropUtils.setI18NPropertyInfo(this.i18n, list, OMGraphicHandlerLayer.class, policyPrefix + ".class", "Projection Change Policy", "Class name of ProjectionChangePolicy (optional)", null);
        RenderPolicy rp = this.getRenderPolicy();
        if (rp instanceof PropertyConsumer) {
            int index;
            policyPrefix = ((PropertyConsumer)((Object)rp)).getPropertyPrefix();
            if (policyPrefix != null && (index = policyPrefix.indexOf(".")) != -1) {
                policyPrefix = policyPrefix.substring(index + 1);
            }
            ((PropertyConsumer)((Object)rp)).getPropertyInfo(list);
        }
        if (policyPrefix == null) {
            policyPrefix = "rp";
        }
        PropUtils.setI18NPropertyInfo(this.i18n, list, OMGraphicHandlerLayer.class, policyPrefix + ".class", "Rendering Policy", "Class name of RenderPolicy (optional)", null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, OMGraphicHandlerLayer.class, ConsumeEventsProperty, "Consume mouse events", "Flag that tells the layer to consume mouse events, or let other layers use them as well.", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, OMGraphicHandlerLayer.class, MouseModesProperty, "Mouse modes", "Space-separated list of MouseMode IDs to receive events from.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, OMGraphicHandlerLayer.class, TransparencyProperty, "Transparency", "Transparency setting for layer, between 0 (clear) and 1", null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, OMGraphicHandlerLayer.class, InterruptableProperty, "Interruptable", "Flat to set whether the layer should immediately stop performing current work when the projection changes.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public synchronized void setMouseEventInterpreter(MapMouseInterpreter mmi) {
        if (mmi instanceof StandardMapMouseInterpreter) {
            String[] modeList = this.getMouseModeIDsForEvents();
            ((StandardMapMouseInterpreter)mmi).setMouseModeServiceList(modeList);
            ((StandardMapMouseInterpreter)mmi).setConsumeEvents(this.getConsumeEvents());
        }
        if (this.mouseEventInterpreter != null) {
            this.mouseEventInterpreter.setGRP(null);
        }
        mmi.setGRP(this);
        this.mouseEventInterpreter = mmi;
    }

    public synchronized MapMouseInterpreter getMouseEventInterpreter() {
        if (this.getMouseModeIDsForEvents() != null && this.mouseEventInterpreter == null) {
            this.setMouseEventInterpreter(new StandardMapMouseInterpreter(this));
        }
        return this.mouseEventInterpreter;
    }

    @Override
    public MapMouseListener getMapMouseListener() {
        MapMouseInterpreter mml = this.getMouseEventInterpreter();
        if (mml != null && logger.isLoggable(Level.FINE)) {
            String[] modes = mml.getMouseModeServiceList();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < modes.length; ++i) {
                sb.append(modes[i]).append(", ");
            }
            logger.fine("Layer " + this.getName() + " returning " + mml.getClass().getName() + " as map mouse listener that listens to: " + sb.toString());
        }
        return mml;
    }

    public void setConsumeEvents(boolean consume) {
        this.consumeEvents = consume;
        if (this.mouseEventInterpreter instanceof StandardMapMouseInterpreter) {
            ((StandardMapMouseInterpreter)this.mouseEventInterpreter).setConsumeEvents(this.getConsumeEvents());
        }
    }

    public boolean getConsumeEvents() {
        return this.consumeEvents;
    }

    public String[] getMouseModeIDsForEvents() {
        return this.mouseModeIDs;
    }

    public void setMouseModeIDsForEvents(String[] mm) {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mm.length; ++i) {
                sb.append(mm[i]).append(" ");
            }
            logger.fine("For layer " + this.getName() + ", setting mouse modes to " + sb.toString());
        }
        this.mouseModeIDs = mm;
        if (this.mouseEventInterpreter instanceof StandardMapMouseInterpreter) {
            ((StandardMapMouseInterpreter)this.mouseEventInterpreter).setMouseModeServiceList(mm);
        }
    }

    @Override
    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }

    @Override
    public boolean isSelectable(OMGraphic omg) {
        return false;
    }

    @Override
    public OMGraphicList getSelected() {
        return this.selectedList;
    }

    @Override
    public void highlight(OMGraphic omg) {
        omg.select();
        omg.generate(this.getProjection());
        this.repaint();
    }

    @Override
    public void unhighlight(OMGraphic omg) {
        omg.deselect();
        omg.generate(this.getProjection());
        this.repaint();
    }

    @Override
    public void select(OMGraphicList list) {
        if (list != null) {
            for (OMGraphic omg : list) {
                if (this.selectedList == null) {
                    this.selectedList = new OMGraphicList();
                }
                if (omg instanceof OMGraphicList && !((OMGraphicList)omg).isVague()) {
                    this.select((OMGraphicList)omg);
                    continue;
                }
                this.selectedList.add(omg);
            }
        }
    }

    @Override
    public void deselect(OMGraphicList list) {
        if (list != null) {
            for (OMGraphic omg : list) {
                if (omg instanceof OMGraphicList && !((OMGraphicList)omg).isVague()) {
                    this.deselect((OMGraphicList)omg);
                    continue;
                }
                if (this.selectedList == null) continue;
                this.selectedList.remove(omg);
            }
        }
    }

    @Override
    public OMGraphicList cut(OMGraphicList omgl) {
        OMGraphicList list = this.getList();
        if (list != null && omgl != null) {
            list.removeAll(omgl);
        }
        return omgl;
    }

    @Override
    public OMGraphicList copy(OMGraphicList omgl) {
        return null;
    }

    @Override
    public void paste(OMGraphicList omgl) {
        OMGraphicList list = this.getList();
        list.addAll(omgl);
    }

    @Override
    public String getInfoText(OMGraphic omg) {
        return null;
    }

    @Override
    public String getToolTipTextFor(OMGraphic omg) {
        return null;
    }

    @Override
    public List<Component> getItemsForMapMenu(MapMouseEvent mme) {
        return null;
    }

    @Override
    public List<Component> getItemsForOMGraphicMenu(OMGraphic omg) {
        return null;
    }

    @Override
    public boolean receivesMapEvents() {
        return false;
    }

    @Override
    public boolean mouseOver(MapMouseEvent mme) {
        return false;
    }

    @Override
    public boolean leftClick(MapMouseEvent mme) {
        return false;
    }

    public JPanel getTransparencyAdjustmentPanel(String label, int orientation, float initialValue) {
        JPanel opaquePanel = PaletteHelper.createPaletteJPanel(label);
        JSlider opaqueSlide = new JSlider(orientation, 0, 255, (int)(255.0f * initialValue));
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        dict.put(new Integer(0), new JLabel(this.i18n.get(OMGraphicHandlerLayer.class, "clearSliderLabel", "clear")));
        dict.put(new Integer(255), new JLabel(this.i18n.get(OMGraphicHandlerLayer.class, "opqueSliderLabel", "opaque")));
        opaqueSlide.setLabelTable(dict);
        opaqueSlide.setPaintLabels(true);
        opaqueSlide.setMajorTickSpacing(50);
        opaqueSlide.setPaintTicks(true);
        opaqueSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider slider = (JSlider)ce.getSource();
                if (slider.getValueIsAdjusting()) {
                    OMGraphicHandlerLayer.this.setTransparency((float)slider.getValue() / 255.0f);
                    OMGraphicHandlerLayer.this.repaint();
                }
            }
        });
        opaquePanel.add(opaqueSlide);
        return opaquePanel;
    }

    public void setTransparency(float value) {
        AlphaComposite ac = null;
        if (value != 1.0f) {
            ac = AlphaComposite.getInstance(10, value);
        }
        this.getRenderPolicy().setComposite(ac);
    }

    public float getTransparency() {
        Composite comp;
        float ret = 1.0f;
        RenderPolicy rp = this.getRenderPolicy();
        if (rp != null && (comp = rp.getComposite()) instanceof AlphaComposite) {
            ret = ((AlphaComposite)comp).getAlpha();
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd" && this.isVisible()) {
            this.doPrepare();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LayerWorker
    extends PooledSwingWorker<OMGraphicList> {
        @Override
        public OMGraphicList construct() {
            String msg;
            logger.fine(OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct()");
            OMGraphicHandlerLayer.this.fireStatusUpdate(8342);
            try {
                long start = System.currentTimeMillis();
                OMGraphicList list = OMGraphicHandlerLayer.this.getRenderPolicy().prepare();
                long stop = System.currentTimeMillis();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct(): fetched " + (list == null ? "null list " : list.size() + " graphics ") + "in " + (double)(stop - start) / 1000.0 + " seconds");
                }
                return list;
            }
            catch (OutOfMemoryError e) {
                msg = OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct(): " + e.getMessage();
                if (logger.isLoggable(Level.FINER)) {
                    logger.fine(msg);
                    e.printStackTrace();
                } else {
                    logger.info(OMGraphicHandlerLayer.this.getName() + " layer ran out of memory, attempting to recover...");
                }
            }
            catch (Throwable e) {
                msg = OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct(): " + e.getClass().getName() + ", " + e.getMessage();
                logger.info(msg);
                e.printStackTrace();
            }
            if (Debug.debugging("displayLayerErrors")) {
                OMGraphicHandlerLayer.this.fireRequestMessage(new InfoDisplayEvent(this, msg));
            }
            return null;
        }

        @Override
        public void finished() {
            OMGraphicHandlerLayer.this.workerComplete(this);
            if (!this.isInterrupted()) {
                OMGraphicHandlerLayer.this.fireStatusUpdate(8359);
            }
        }

        public String toString() {
            return OMGraphicHandlerLayer.this.getName() + " LayerWorker";
        }
    }
}

