/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.event;

import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.event.EventListIconPackage;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class EventListCellRenderer
extends OMComponentPanel
implements ListCellRenderer {
    protected JLabel label = new JLabel();
    protected JLabel timeMark = new JLabel();
    protected JLabel ratingMark = new JLabel();
    public Color fontColor = Color.BLACK;
    public Color altFontColor = Color.BLACK;
    public Color selectColor = Color.GRAY;
    public Color timeWindowColor = Color.LIGHT_GRAY;
    public Color regularBackgroundColor = Color.WHITE;
    public static final String FontColorProperty = "fontColor";
    public static final String AltFontColorProperty = "altFontColor";
    public static final String SelectColorProperty = "selectColor";
    public static final String TimeWindowColorProperty = "timeWindowColor";
    public static final String BackgroundColorProperty = "color";
    public static final String IconPackageClassProperty = "iconPackageClass";
    protected EventListIconPackage iconPackage;

    public EventListCellRenderer() {
        this.init();
    }

    protected void init() {
        this.removeAll();
        this.setOpaque(true);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.label, c);
        this.add(this.label);
        c.fill = 0;
        c.weightx = 0.0;
        gridbag.setConstraints(this.ratingMark, c);
        this.add(this.ratingMark);
        gridbag.setConstraints(this.timeMark, c);
        this.add(this.timeMark);
        Font f = this.label.getFont();
        f = new Font(f.getName(), f.getStyle(), f.getSize() - 1);
        this.label.setFont(f);
        this.setPreferredSize(new Dimension(20, this.getIconPackage().getButtonSize()));
    }

    public EventListIconPackage getIconPackage() {
        if (this.iconPackage == null) {
            this.iconPackage = new EventListIconPackage();
        }
        return this.iconPackage;
    }

    public void setIconPackage(EventListIconPackage iconPackage) {
        this.iconPackage = iconPackage;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.fontColor = (Color)PropUtils.parseColorFromProperties(props, prefix + FontColorProperty, this.fontColor);
        this.altFontColor = (Color)PropUtils.parseColorFromProperties(props, prefix + AltFontColorProperty, this.altFontColor);
        this.selectColor = (Color)PropUtils.parseColorFromProperties(props, prefix + SelectColorProperty, this.selectColor);
        this.timeWindowColor = (Color)PropUtils.parseColorFromProperties(props, prefix + TimeWindowColorProperty, this.timeWindowColor);
        this.regularBackgroundColor = (Color)PropUtils.parseColorFromProperties(props, prefix + BackgroundColorProperty, this.regularBackgroundColor);
        String crc = props.getProperty(prefix + IconPackageClassProperty);
        if (crc != null) {
            this.iconPackage = (EventListIconPackage)ComponentFactory.create(crc, prefix, props);
            this.init();
        }
    }

    public DrawingAttributes setRenderingAttributes(DrawingAttributes drawingAttributes) {
        if (drawingAttributes == null) {
            drawingAttributes = DrawingAttributes.getDefaultClone();
        }
        drawingAttributes.setFillPaint(this.regularBackgroundColor);
        drawingAttributes.setSelectPaint(this.selectColor);
        drawingAttributes.setLinePaint(this.fontColor);
        drawingAttributes.setMattingPaint(this.timeWindowColor);
        return drawingAttributes;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.label.setText(value.toString());
        if (value instanceof OMEvent) {
            OMEvent OMe = (OMEvent)value;
            isSelected = OMe.getAttribute("SELECTED") != null;
            this.timeMark.setIcon(OMe.getAttribute("PLAY_FILTER") == Boolean.TRUE ? this.iconPackage.clockImage : this.iconPackage.invisibleImage);
            Object rating = OMe.getAttribute("RATING");
            if (rating == "-") {
                this.ratingMark.setIcon(this.iconPackage.thumbsDownImage);
            } else if (rating == "+") {
                this.ratingMark.setIcon(this.iconPackage.thumbsUpImage);
            } else {
                this.ratingMark.setIcon(this.iconPackage.invisibleImage);
            }
            if (OMe.isAtCurrentTime()) {
                if (isSelected) {
                    this.setBackground(this.selectColor);
                } else {
                    this.setBackground(this.timeWindowColor);
                }
                this.setForeground(this.altFontColor);
                return this;
            }
        } else {
            this.timeMark.setIcon(this.iconPackage.invisibleImage);
            this.ratingMark.setIcon(this.iconPackage.invisibleImage);
        }
        this.setBackground(isSelected ? this.selectColor : this.regularBackgroundColor);
        this.setForeground(isSelected ? this.altFontColor : this.fontColor);
        return this;
    }
}

