/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class NavMouseMode2
extends NavMouseMode {
    public NavMouseMode2() {
        this(true);
    }

    public NavMouseMode2(boolean shouldConsumeEvents) {
        super(shouldConsumeEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseReleased(MouseEvent e) {
        Object obj;
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode2.mouseReleased()");
        }
        if (this.theMap != (obj = e.getSource()) || !this.autoZoom || this.point1 == null || this.point2 == null) {
            return;
        }
        Projection projection = this.theMap.getProjection();
        Proj p = (Proj)projection;
        MapBean map = this.theMap;
        NavMouseMode2 navMouseMode2 = this;
        synchronized (navMouseMode2) {
            this.point2 = this.getRatioPoint(map, this.point1, e.getPoint());
            int dx = Math.abs(this.point2.x - this.point1.x);
            int dy = Math.abs(this.point2.y - this.point1.y);
            if (dx < 5 || dy < 5) {
                if (dx < 5 && dy < 5) {
                    Point2D llp = map.getCoordinates(e);
                    boolean shift = e.isShiftDown();
                    boolean control = e.isControlDown();
                    if (control) {
                        if (shift) {
                            p.setScale(p.getScale() * 2.0f);
                        } else {
                            p.setScale(p.getScale() / 2.0f);
                        }
                    }
                    this.cleanUp();
                    p.setCenter(llp);
                    map.setProjection(p);
                }
                return;
            }
            dx = Math.abs(this.point2.x - this.point1.x);
            dy = Math.abs(this.point2.y - this.point1.y);
            Point cornerPoint1 = new Point(this.point2.x < this.point1.x ? this.point2.x : this.point1.x, this.point2.y < this.point1.y ? this.point2.y : this.point1.y);
            Point cornerPoint2 = new Point(cornerPoint1.x + 2 * dx, cornerPoint1.y + 2 * dy);
            float newScale = ProjMath.getScale(cornerPoint1, cornerPoint2, projection);
            Point2D center = map.inverse(this.point1.x, this.point1.y, null);
            p.setScale(newScale);
            p.setCenter(center);
            this.cleanUp();
            map.setProjection(p);
        }
    }

    protected void paintRectangle(Graphics g, Point pt1, Point pt2) {
        if (pt1 != null && pt2 != null) {
            int width = Math.abs(pt2.x - pt1.x);
            int height = Math.abs(pt2.y - pt1.y);
            if (width == 0) {
                ++width;
            }
            if (height == 0) {
                ++height;
            }
            Rectangle2D.Double rect1 = new Rectangle2D.Double(pt1.x - width, pt1.y - height, width * 2, height * 2);
            Rectangle2D.Double rect2 = new Rectangle2D.Double(pt1.x - 1, pt1.y - 1, 3.0, 3.0);
            if (this.theMap != null) {
                this.rectAttributes.render((Graphics2D)g, this.theMap.getNonRotatedShape(rect1));
                this.rectAttributes.render((Graphics2D)g, this.theMap.getNonRotatedShape(rect2));
            }
        }
    }
}

