/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ZoomLevelInfo
extends OMComponent {
    protected int zoomLevel = 0;
    protected float scale = -1.0f;

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public int getEdgeTileCount() {
        return (int)Math.pow(2.0, this.zoomLevel);
    }

    public Rectangle2D getUVBounds(Rectangle2D bounds, MapTileCoordinateTransform mtct, int zoomLevel) {
        double x = bounds.getX();
        double y = bounds.getY();
        double h = bounds.getHeight();
        double w = bounds.getWidth();
        Point2D.Double point1 = new Point2D.Double(x, y + h);
        Point2D.Double point2 = new Point2D.Double(x + w, y);
        Point2D uluv = mtct.latLonToTileUV(point1, zoomLevel);
        Point2D lruv = mtct.latLonToTileUV(point2, zoomLevel);
        x = Math.floor(uluv.getX());
        y = Math.floor(uluv.getY());
        w = Math.ceil(lruv.getX() - x);
        h = Math.ceil(lruv.getY() - y);
        return new Rectangle2D.Double(x, y, w, h);
    }

    public String formatParentDirectoryName(String rootDir, int uvx, int uvy) {
        return rootDir + "/" + this.getZoomLevel() + "/" + uvx;
    }

    public String formatImageFilePath(String rootDir, int uvx, int uvy) {
        return rootDir + "/" + this.getZoomLevel() + "/" + uvx + "/" + uvy;
    }
}

