/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.esri;

import com.bbn.openmap.Layer;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.DrawingAttributesUtility;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.plugin.BeanContextAbstractPlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsriPlugIn
extends BeanContextAbstractPlugIn
implements ShapeConstants,
DataBoundsProvider {
    private EsriGraphicList _list = null;
    private DbfTableModel _model = null;
    private int _type = -1;
    private String dbf;
    private String shx;
    private String shp;
    protected OMGraphicList selectedGraphics = new OMGraphicList();
    protected Projection proj;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();
    protected JTable table = null;
    protected ListSelectionModel lsm = null;
    protected Layer parentLayer = null;
    protected JPanel daGUI = null;
    protected JFrame tableFrame = null;
    protected int graphicIndex = -1;

    public EsriPlugIn() {
        Debug.message("esri", "EsriPlugIn: default constructor");
    }

    public EsriPlugIn(String name, int type, int columnCount) throws Exception {
        switch (type) {
            case 1: {
                this._list = new EsriPointList();
                break;
            }
            case 5: {
                this._list = new EsriPolygonList();
                break;
            }
            case 3: {
                this._list = new EsriPolylineList();
                break;
            }
            default: {
                this._list = null;
            }
        }
        this._model = new DbfTableModel(columnCount);
        this.name = name;
    }

    public EsriPlugIn(String name, URL dbf, URL shp, URL shx) {
        this.dbf = dbf.toString();
        this.shp = shp.toString();
        this.shx = shx.toString();
        this._list = this.getGeometry(shp);
        this._model = this.getDbfTableModel(dbf);
        this._list.putAttribute("DBF_ATTRIBUTE", this._model);
        this.name = name;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
        if (this._list != null) {
            this.drawingAttributes.setTo(this._list);
        }
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public void addRecord(OMGraphic graphic, ArrayList<Object> record) {
        EsriGraphicList list = this.getEsriGraphicList();
        graphic.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", record);
        if (list != null) {
            graphic.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(list.size()));
            ((OMGraphicList)list).add(graphic);
            this._model.addRecord(record);
        } else {
            Debug.error("EsriPlugIn.addRecord(): invalid data files!");
        }
    }

    private DbfTableModel getDbfTableModel(URL dbf) {
        return DbfTableModel.getDbfTableModel(dbf);
    }

    public EsriGraphicList getEsriGraphicList() {
        if (this._list == null) {
            try {
                if ((this.shx == null || this.shx.length() == 0) && this.shp != null) {
                    this.shx = this.shp.substring(0, this.shp.lastIndexOf(46) + 1) + "shx";
                }
                if ((this.dbf == null || this.dbf.length() == 0) && this.shp != null) {
                    this.dbf = this.shp.substring(0, this.shp.lastIndexOf(46) + 1) + "dbf";
                }
                this._model = this.getDbfTableModel(PropUtils.getResourceOrFileOrURL(this.dbf));
                this._list = this.getGeometry(PropUtils.getResourceOrFileOrURL(this.shp));
                if (this._model != null) {
                    DrawingAttributesUtility.setDrawingAttributes(this._list, this._model, this.getDrawingAttributes());
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("EsriPlugIn|" + this.getName() + " Malformed URL Exception\n" + murle.getMessage());
            }
            catch (Exception exception) {
                Debug.error("EsriPlugIn|" + this.getName() + " Exception\n" + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return this._list;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Give EsriPlugIn a path to a shape file, and it'll print out the graphics.");
            System.exit(0);
        }
        Debug.init();
        EsriPlugIn epi = new EsriPlugIn();
        Properties props = new Properties();
        props.put("shp", argv[0]);
        epi.setProperties(props);
        EsriGraphicList list = epi.getEsriGraphicList();
        if (list != null) {
            Debug.output(list.getDescription());
        }
        String dbfFileName = argv[0].substring(0, argv[0].lastIndexOf(46) + 1) + "dbf";
        try {
            DbfTableModel dbf = epi.getDbfTableModel(PropUtils.getResourceOrFileOrURL(epi, dbfFileName));
            if (list != null) {
                list.putAttribute("DBF_ATTRIBUTE", dbf);
            }
            Debug.output("Set list in table");
            dbf.showGUI(dbfFileName, 0);
        }
        catch (Exception e) {
            Debug.error("Can't read .dbf file for .shp file: " + dbfFileName + "\n" + e.getMessage());
            System.exit(0);
        }
        EsriShapeExport ese = new EsriShapeExport((OMGraphicList)list, null, "./ese");
        Debug.output("Exporting...");
        ese.export();
        Debug.output("Done.");
    }

    @Override
    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = this.getEsriGraphicList();
        this.proj = p;
        if (list != null) {
            list.generate(p);
            OMGraphicList parent = new OMGraphicList();
            parent.add(this.selectedGraphics);
            parent.add(list);
            list = parent;
        }
        return list;
    }

    public EsriGraphicList getGeometry(URL shp, URL shx) {
        return EsriGraphicList.getEsriGraphicList(shp, this.getDrawingAttributes(), this.getModel(), this.parentLayer.getCoordTransform());
    }

    public EsriGraphicList getGeometry(URL shp) {
        Component comp;
        if (this.parentLayer == null && (comp = this.getComponent()) instanceof Layer) {
            this.parentLayer = (Layer)comp;
        }
        GeoCoordTransformation coordTransform = null;
        if (this.parentLayer != null) {
            coordTransform = this.parentLayer.getCoordTransform();
        }
        return EsriGraphicList.getEsriGraphicList(shp, this.getDrawingAttributes(), this.getModel(), coordTransform);
    }

    public DbfTableModel getModel() {
        return this._model;
    }

    public int getType() {
        return this._type;
    }

    public void query(String query) {
    }

    public void setModel(DbfTableModel model) {
        if (this._model != null) {
            this._model = model;
            this._list.putAttribute("DBF_ATTRIBUTE", model);
        }
    }

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.drawingAttributes.setProperties(prefix, properties);
        if (this._list != null) {
            if (this._model != null) {
                DrawingAttributesUtility.setDrawingAttributes(this._list, this._model, this.drawingAttributes);
            } else {
                this.drawingAttributes.setTo(this._list);
            }
        }
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.shp = properties.getProperty(prefix + "shp");
        this.shx = properties.getProperty(prefix + "shx");
        this.dbf = properties.getProperty(prefix + "dbf");
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "shp", PropUtils.unnull(this.shp));
        props.put(prefix + "shx", PropUtils.unnull(this.shx));
        props.put(prefix + "dbf", PropUtils.unnull(this.dbf));
        this.drawingAttributes.setPropertyPrefix(this.getPropertyPrefix());
        this.drawingAttributes.getProperties(props);
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put("initProperties", "shp dbf shx" + this.drawingAttributes.getInitPropertiesOrder() + " " + "addToBeanContext");
        props.put("shp", "Location of a shape (.shp) file (path or URL)");
        props.put("shx", "Location of a index file (.shx) for the shape file (path or URL, optional)");
        props.put("dbf", "Location of a database file (.dbf) for the shape file (path or URL, optional)");
        props.put("shp.editor", "com.bbn.openmap.util.propertyEditor.FDUPropertyEditor");
        props.put("dbf.editor", "com.bbn.openmap.util.propertyEditor.FDUPropertyEditor");
        props.put("shx.editor", "com.bbn.openmap.util.propertyEditor.FDUPropertyEditor");
        this.drawingAttributes.getPropertyInfo(props);
        return props;
    }

    @Override
    public Component getGUI() {
        JPanel holder = new JPanel(new BorderLayout());
        holder.add(this.drawingAttributes.getGUI(), "Center");
        JPanel btnPanel = new JPanel(new GridLayout(3, 1));
        JButton redrawSelected = new JButton("Set Colors for Selected");
        btnPanel.add(redrawSelected);
        JButton redrawAll = new JButton("Set Colors For All");
        btnPanel.add(redrawAll);
        JButton tableTrigger = new JButton("Show Data Table");
        btnPanel.add(tableTrigger);
        holder.add((Component)btnPanel, "South");
        redrawSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EsriPlugIn.this.graphicIndex >= 0) {
                    OMGraphic omg = EsriPlugIn.this.getEsriGraphicList().getOMGraphicAt(EsriPlugIn.this.graphicIndex);
                    EsriPlugIn.this.repaintGraphics(omg);
                }
            }
        });
        redrawAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EsriPlugIn.this.repaintGraphics(EsriPlugIn.this.getEsriGraphicList());
            }
        });
        tableTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EsriPlugIn.this.showTable();
            }
        });
        return holder;
    }

    public void setDrawingAttributes(OMGraphic omg) {
        if (this.drawingAttributes != null && omg != null) {
            this.drawingAttributes.setFrom(omg);
        }
    }

    private void repaintGraphics(OMGraphic omg) {
        this.drawingAttributes.setTo(omg);
        this.doPrepare();
    }

    public JTable getTable() {
        if (this.table == null) {
            this.lsm = new DefaultListSelectionModel();
            this.table = new JTable();
            this.table.setModel(this.getModel());
            this.table.setSelectionModel(this.lsm);
            this.table.setAutoResizeMode(0);
            this.lsm.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm2 = (ListSelectionModel)e.getSource();
                    if (!lsm2.isSelectionEmpty()) {
                        int index = lsm2.getMinSelectionIndex();
                        EsriPlugIn.this.selectGraphic(index);
                        EsriPlugIn.this.getComponent().repaint();
                    }
                }
            });
        }
        return this.table;
    }

    public void selectGraphic(int index) {
        EsriGraphicList list = this.getEsriGraphicList();
        list.deselect();
        this.selectedGraphics.clear();
        this.selectGraphic(list.getOMGraphicAt(index));
        this.graphicIndex = index;
        list.regenerate(this.proj);
    }

    public void selectGraphic(OMGraphic graphic) {
        if (graphic != null) {
            graphic.select();
            graphic.regenerate(this.proj);
            this.selectedGraphics.add(graphic);
        }
    }

    public void selectEntry(OMGraphic graphic) {
        if (this.lsm == null) {
            this.getTable();
        }
        this.lsm.setSelectionInterval(this.graphicIndex, this.graphicIndex);
        this.getTable().scrollRectToVisible(this.getTable().getCellRect(this.graphicIndex, 0, true));
    }

    public void showTable() {
        if (this.tableFrame == null) {
            String tableTitle = this.name != null ? this.name : "";
            this.tableFrame = new JFrame(tableTitle + " Shape Data Attributes");
            JScrollPane pane = new JScrollPane(this.getTable(), 20, 30);
            this.tableFrame.getContentPane().add((Component)pane, "Center");
            this.tableFrame.setSize(400, 300);
        }
        this.tableFrame.setVisible(true);
        this.tableFrame.toFront();
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        EsriGraphicList list = this.getEsriGraphicList();
        boolean ret = false;
        this.graphicIndex = -1;
        if (list != null) {
            OMGraphic omg = (OMGraphic)list.selectClosest(e.getX(), e.getY(), 4.0f);
            if (omg != null) {
                this.graphicIndex = list.indexOf(omg);
                this.selectEntry(omg);
                ret = true;
            } else {
                if (this.lsm == null) {
                    this.getTable();
                }
                this.lsm.clearSelection();
                list.deselect();
                this.selectedGraphics.clear();
                this.repaint();
            }
        }
        return ret;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        EsriGraphicList list = this.getEsriGraphicList();
        boolean ret = false;
        if (list != null) {
            OMGraphic omg = (OMGraphic)list.findClosest(e.getX(), e.getY(), 4.0f);
            if (omg != null) {
                Component comp;
                Integer I = (Integer)omg.getAttribute("SHAPE_INDEX_ATTRIBUTE");
                int index = I != null ? I.intValue() : list.indexOf(omg);
                if (this.parentLayer == null && (comp = this.getComponent()) instanceof Layer) {
                    this.parentLayer = (Layer)comp;
                }
                if (this.parentLayer != null) {
                    this.parentLayer.fireRequestToolTip(this.getDescription(index));
                }
                ret = true;
            } else if (this.parentLayer != null) {
                this.parentLayer.fireHideToolTip();
            }
        }
        return ret;
    }

    public String getDescription(int index) {
        StringBuffer v = new StringBuffer();
        v.append("<HTML><BODY>");
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            try {
                String column = this.getTable().getColumnName(i);
                String value = this.getTable().getValueAt(index, i) + "";
                v.append(i == 0 ? "<b>" : "<BR><b>").append(column).append(":</b> ").append(value);
                continue;
            }
            catch (NullPointerException npe) {
                continue;
            }
            catch (IndexOutOfBoundsException obe) {
                // empty catch block
            }
        }
        v.append("</BODY></HTML>");
        return v.toString();
    }

    @Override
    public DataBounds getDataBounds() {
        DataBounds box = null;
        if (this._list == null) {
            this._list = this.getEsriGraphicList();
        }
        if (this._list != null) {
            double[] extents = this._list.getExtents();
            box = new DataBounds(extents[1], extents[0], extents[3], extents[2]);
        }
        return box;
    }
}

