/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.rule;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.omGraphics.rule.RuleOp;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rule<T>
extends OMComponent {
    protected String keyField;
    protected List<String> tooltipFields;
    protected List<String> infolineFields;
    protected List<String> labelFields;
    protected Object val;
    protected RuleOp op = RuleOp.NONE;
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    protected float displayMinScale = Float.MIN_VALUE;
    protected float displayMaxScale = Float.MAX_VALUE;
    protected float labelMinScale = Float.MIN_VALUE;
    protected float labelMaxScale = Float.MAX_VALUE;
    public static final String RuleListProperty = "rules";
    public static final String RuleKeyProperty = "key";
    public static final String RuleOperatorProperty = "op";
    public static final String RuleValueProperty = "val";
    public static final String RuleActionRender = "render";
    public static final String RuleActionTooltip = "tooltip";
    public static final String RuleActionInfoline = "infoline";
    public static final String RuleActionLabel = "label";
    public static final String RuleActionMinScale = "minScale";
    public static final String RuleActionMaxScale = "maxScale";

    public abstract boolean evaluate(T var1);

    public abstract String getContent(List<String> var1, T var2);

    @Override
    public void setProperties(String prefix, Properties props) {
        String newVal;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.keyField = props.getProperty(prefix + RuleKeyProperty, this.keyField);
        this.tooltipFields = this.getStringFromFields(props.getProperty(prefix + RuleActionTooltip));
        this.infolineFields = this.getStringFromFields(props.getProperty(prefix + RuleActionInfoline));
        this.labelFields = this.getStringFromFields(props.getProperty(prefix + RuleActionLabel));
        RuleOp op = RuleOp.resolve(props.getProperty(prefix + RuleOperatorProperty));
        if (op != null) {
            this.op = op;
        }
        if ((newVal = props.getProperty(prefix + RuleValueProperty)) != null) {
            this.val = newVal;
        }
        if (this.keyField == null) {
            Debug.output("No key for rule (" + prefix + ") found in properties.");
        }
        this.displayMinScale = PropUtils.floatFromProperties(props, prefix + RuleActionRender + "." + RuleActionMinScale, this.displayMinScale);
        this.displayMaxScale = PropUtils.floatFromProperties(props, prefix + RuleActionRender + "." + RuleActionMaxScale, this.displayMaxScale);
        this.labelMinScale = PropUtils.floatFromProperties(props, prefix + RuleActionLabel + "." + RuleActionMinScale, this.labelMinScale);
        this.labelMaxScale = PropUtils.floatFromProperties(props, prefix + RuleActionLabel + "." + RuleActionMaxScale, this.labelMaxScale);
        boolean renderProperties = PropUtils.booleanFromProperties(props, prefix + RuleActionRender, this.drawingAttributes != null);
        if (renderProperties) {
            if (this.drawingAttributes == null) {
                this.drawingAttributes = new DrawingAttributes();
            }
            this.drawingAttributes.setProperties(prefix, props);
        } else {
            this.drawingAttributes = null;
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + RuleKeyProperty, PropUtils.unnull(this.keyField));
        if (this.tooltipFields != null && !this.tooltipFields.isEmpty()) {
            props.put(prefix + RuleActionTooltip, this.getFieldsAsString(this.tooltipFields));
        }
        if (this.infolineFields != null && !this.infolineFields.isEmpty()) {
            props.put(prefix + RuleActionInfoline, this.getFieldsAsString(this.infolineFields));
        }
        if (this.labelFields != null && !this.labelFields.isEmpty()) {
            props.put(prefix + RuleActionLabel, this.getFieldsAsString(this.labelFields));
        }
        if (this.op != null) {
            props.put(prefix + RuleOperatorProperty, this.op.getPropertyNotation());
        }
        if (this.val != null) {
            props.put(prefix + RuleValueProperty, PropUtils.unnull(this.val.toString()));
        }
        if (this.displayMinScale != Float.MIN_VALUE) {
            props.put(prefix + RuleActionRender + "." + RuleActionMinScale, Float.toString(this.displayMinScale));
        }
        if (this.displayMaxScale != Float.MAX_VALUE) {
            props.put(prefix + RuleActionRender + "." + RuleActionMaxScale, Float.toString(this.displayMaxScale));
        }
        if (this.labelMinScale != Float.MIN_VALUE) {
            props.put(prefix + RuleActionLabel + "." + RuleActionMinScale, Float.toString(this.labelMinScale));
        }
        if (this.labelMaxScale != Float.MAX_VALUE) {
            props.put(prefix + RuleActionLabel + "." + RuleActionMaxScale, Float.toString(this.labelMaxScale));
        }
        if (this.drawingAttributes != null) {
            props.put(prefix + RuleActionRender, Boolean.toString(true));
            this.drawingAttributes.getProperties(props);
        }
        return props;
    }

    public OMGraphic evaluate(T record, OMGraphic omg, Projection proj) {
        if (this.evaluate(record)) {
            float scale = 0.0f;
            if (proj != null && ((scale = proj.getScale()) < this.displayMinScale || scale > this.displayMaxScale)) {
                return null;
            }
            if (this.infolineFields != null) {
                omg.putAttribute("Information Line", this.getContent(this.infolineFields, record));
            }
            if (this.tooltipFields != null) {
                omg.putAttribute("Tooltip", this.getContent(this.tooltipFields, record));
            }
            if (this.labelFields != null && scale >= this.labelMinScale && scale <= this.labelMaxScale) {
                String curLabel = this.getContent(this.labelFields, record);
                OMTextLabeler label = new OMTextLabeler(curLabel, 1);
                omg.putAttribute("Label", label);
            }
            if (this.drawingAttributes != null) {
                this.drawingAttributes.setTo(omg);
            }
            omg.setVisible(this.drawingAttributes != null);
            if (Rule.getLogger().isLoggable(Level.FINE)) {
                Rule.getLogger().fine(this.getPropertyPrefix() + " being assigned to " + ((Object)((Object)this.op)).getClass().getName() + " " + this.keyField + " " + this.val + " vs " + ((Map)record).get(this.keyField));
                omg.putAttribute("RULE", this.getPropertyPrefix());
            }
            return omg;
        }
        return null;
    }

    public String getFieldsAsString(List<String> fieldNames) {
        StringBuffer buf = new StringBuffer();
        if (fieldNames != null) {
            for (String field : fieldNames) {
                buf.append(PropUtils.unnull(field)).append(" ");
            }
        }
        return buf.toString().trim();
    }

    public List<String> getStringFromFields(String fieldString) {
        if (fieldString != null && !fieldString.isEmpty()) {
            return PropUtils.parseSpacedMarkers(fieldString);
        }
        return null;
    }

    public DrawingAttributes getDrawingAttribtues() {
        return this.drawingAttributes;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public float getDisplayMaxScale() {
        return this.displayMaxScale;
    }

    public void setDisplayMaxScale(float displayMaxScale) {
        this.displayMaxScale = displayMaxScale;
    }

    public float getDisplayMinScale() {
        return this.displayMinScale;
    }

    public void setDisplayMinScale(float displayMinScale) {
        this.displayMinScale = displayMinScale;
    }

    public String getKeyName() {
        return this.keyField;
    }

    public void setKeyName(String keyName) {
        this.keyField = keyName;
    }

    public List<String> getLabelFields() {
        return this.labelFields;
    }

    public void setLabelFields(List<String> labelFields) {
        this.labelFields = labelFields;
    }

    public List<String> getInfolineFields() {
        return this.infolineFields;
    }

    public void setInfolineFields(List<String> infolineFields) {
        this.infolineFields = infolineFields;
    }

    public List<String> getTooltipFields() {
        return this.tooltipFields;
    }

    public void setTooltipFields(List<String> tooltipFields) {
        this.tooltipFields = tooltipFields;
    }

    public float getLabelMaxScale() {
        return this.labelMaxScale;
    }

    public void setLabelMaxScale(float labelMaxScale) {
        this.labelMaxScale = labelMaxScale;
    }

    public float getLabelMinScale() {
        return this.labelMinScale;
    }

    public void setLabelMinScale(float labelMinScale) {
        this.labelMinScale = labelMinScale;
    }

    public RuleOp getOp() {
        return this.op;
    }

    public void setOp(RuleOp op) {
        this.op = op;
    }

    public Object getVal() {
        return this.val;
    }

    public void setVal(Object val) {
        this.val = val;
    }

    private static Logger getLogger() {
        return LoggerHolder.LOGGER;
    }

    private static final class LoggerHolder {
        private static final Logger LOGGER = Logger.getLogger(Rule.class.getName());

        private LoggerHolder() {
            throw new AssertionError((Object)"This should never be instantiated");
        }
    }
}

