/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DeepCopyUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.logging.Level;
import javax.swing.ImageIcon;

public class OMRaster
extends OMRasterObject
implements Serializable {
    protected int[] colors = null;
    protected int transparent = 255;

    public OMRaster() {
        super(0, 0, 0);
    }

    public OMRaster(double lt, double ln, int w, int h, int[] pix) {
        super(1, 0, 0);
        this.setColorModel(0);
        this.lat = lt;
        this.lon = ln;
        this.width = w;
        this.height = h;
        this.pixels = pix;
        if (this.pixels == null || this.pixels.length == 0) {
            this.pixels = new int[this.height * this.width];
        }
    }

    public OMRaster(int x1, int y1, int w, int h, int[] pix) {
        super(2, 0, 0);
        this.setColorModel(0);
        this.x = x1;
        this.y = y1;
        this.width = w;
        this.height = h;
        this.pixels = pix;
        if (this.pixels == null || this.pixels.length == 0) {
            this.pixels = new int[this.height * this.width];
        }
    }

    public OMRaster(double lt, double ln, int offset_x1, int offset_y1, int w, int h, int[] pix) {
        super(3, 0, 0);
        this.setColorModel(0);
        this.lat = lt;
        this.lon = ln;
        this.x = offset_x1;
        this.y = offset_y1;
        this.width = w;
        this.height = h;
        this.pixels = pix;
        if (this.pixels == null || this.pixels.length == 0) {
            this.pixels = new int[this.height * this.width];
        }
    }

    public OMRaster(double lt, double ln, ImageIcon ii) {
        this(lt, ln, ii.getImage());
    }

    public OMRaster(double lt, double ln, Image ii) {
        super(1, 0, 0);
        this.setColorModel(2);
        this.lat = lt;
        this.lon = ln;
        this.setImage(ii);
    }

    public OMRaster(int x1, int y1, ImageIcon ii) {
        this(x1, y1, ii.getImage());
    }

    public OMRaster(int x1, int y1, Image ii) {
        super(2, 0, 0);
        this.setColorModel(2);
        this.x = x1;
        this.y = y1;
        this.setImage(ii);
    }

    public OMRaster(double lt, double ln, int offset_x1, int offset_y1, ImageIcon ii) {
        this(lt, ln, offset_x1, offset_y1, ii.getImage());
    }

    public OMRaster(double lt, double ln, int offset_x1, int offset_y1, Image ii) {
        super(3, 0, 0);
        this.setColorModel(2);
        this.lat = lt;
        this.lon = ln;
        this.x = offset_x1;
        this.y = offset_y1;
        this.setImage(ii);
    }

    public OMRaster(double lt, double ln, int w, int h, byte[] bytes, Color[] colorTable, int trans) {
        super(1, 0, 0);
        this.setColorModel(1);
        this.lat = lt;
        this.lon = ln;
        this.width = w;
        this.height = h;
        this.bits = bytes;
        this.transparent = trans;
        if (colorTable != null) {
            this.setColors(colorTable);
        }
        if (this.bits != null && this.bits.length != 0) {
            if (colorTable != null && this.colors.length != 0) {
                this.pixels = this.computePixels(this.bits);
            }
        } else {
            this.bits = new byte[this.height * this.width];
        }
    }

    public OMRaster(int x1, int y1, int w, int h, byte[] bytes, Color[] colorTable, int trans) {
        super(2, 0, 0);
        this.setColorModel(1);
        this.x = x1;
        this.y = y1;
        this.width = w;
        this.height = h;
        this.bits = bytes;
        this.transparent = trans;
        if (colorTable != null) {
            this.setColors(colorTable);
        }
        if (this.bits != null && this.bits.length != 0) {
            if (colorTable != null && this.colors.length != 0) {
                this.pixels = this.computePixels(this.bits);
            }
        } else {
            this.bits = new byte[this.height * this.width];
        }
    }

    public OMRaster(double lt, double ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, Color[] colorTable, int trans) {
        super(3, 0, 0);
        this.setColorModel(1);
        this.lat = lt;
        this.lon = ln;
        this.x = offset_x1;
        this.y = offset_y1;
        this.width = w;
        this.height = h;
        this.transparent = trans;
        this.bits = bytes;
        if (colorTable != null) {
            this.setColors(colorTable);
        }
        if (this.bits != null && this.bits.length != 0) {
            if (colorTable != null && this.colors.length != 0) {
                this.pixels = this.computePixels(this.bits);
            }
        } else {
            this.bits = new byte[this.height * this.width];
        }
    }

    private boolean boundsSafe(int x, int y) {
        return y >= 0 && y < this.height && x >= 0 && x < this.width;
    }

    public void setImageIcon(ImageIcon img) {
        this.setImage(img.getImage());
    }

    public boolean setPixel(int x, int y, int colorValue) {
        if (this.boundsSafe(x, y)) {
            this.pixels[y * this.width + x] = colorValue;
            this.setNeedToRegenerate(true);
            return true;
        }
        return false;
    }

    public int getPixel(int x, int y) {
        if (this.boundsSafe(x, y)) {
            return this.pixels[y * this.width + x];
        }
        return 0;
    }

    public boolean setByte(int x, int y, byte ctIndex) {
        if (this.boundsSafe(x, y) && this.bits != null) {
            this.bits[y * this.width + x] = ctIndex;
            this.setNeedToRegenerate(true);
            return true;
        }
        return false;
    }

    public byte getByte(int x, int y) {
        if (this.boundsSafe(x, y) && this.bits != null) {
            return this.bits[y * this.width + x];
        }
        return 0;
    }

    public void setBits(byte[] values) {
        super.setBits(values);
        if (values.length != this.height * this.width && logger.isLoggable(Level.FINE)) {
            logger.fine("OMBitmap: new byte[] size (" + values.length + ") doesn't" + " match [height*width (" + this.height * this.width + ")]");
        }
    }

    public void setTransparent(int value) {
        if (this.transparent == (value &= 0xFF)) {
            return;
        }
        this.transparent = value;
        this.setNeedToRegenerate(true);
        if (this.bits != null) {
            this.pixels = this.computePixels(this.bits);
        } else {
            value <<= 24;
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = 0xFFFFFF & this.pixels[i] | value;
            }
        }
    }

    public int getTransparent() {
        return this.transparent;
    }

    public void setColors(int[] values) {
        if (this.colorModel != 1) {
            logger.fine("OMRaster: Setting colors for final colortable when a colortable isn't needed!");
        } else {
            this.colors = values;
            this.setNeedToRegenerate(true);
        }
    }

    public void setColors(Color[] values) {
        if (this.colorModel != 1) {
            logger.fine("Setting colors for final colortable when a colortable isn't needed!");
            return;
        }
        if (values == null || values.length == 0) {
            this.colors = new int[0];
            logger.fine("What are you trying to do to me?!? The colortables gots to have values!");
            return;
        }
        if (values.length > 0) {
            this.colors = new int[values.length];
            boolean allTransparent = true;
            int trans = this.transparent << 24 & 0xFF000000;
            for (int i = 0; i < values.length; ++i) {
                if (this.transparent < 255) {
                    int argb = values[i].getRGB();
                    this.colors[i] = values[i].getAlpha() > this.transparent ? 0xFFFFFF & argb | trans : argb;
                } else {
                    this.colors[i] = values[i].getRGB();
                }
                if (!allTransparent || this.colors[i] >>> 24 == 0) continue;
                allTransparent = false;
            }
            if (this.DEBUG && allTransparent) {
                logger.fine("OMRaster: **Whasamatta?** Image created with all transparent pixels!");
            }
        }
        this.pixels = null;
        this.setNeedToRegenerate(true);
    }

    public int[] getColors() {
        return this.colors;
    }

    protected int[] computePixels(byte[] bits) {
        if (this.DEBUG) {
            logger.fine("OMRaster.compute pixels!");
        }
        if (this.colorModel != 1) {
            return new int[0];
        }
        if (this.colors == null || this.colors.length == 0 || bits == null || bits.length == 0) {
            logger.fine("OMRaster: attempting to compute pixels without color table or proper indexes!");
            return null;
        }
        int nPixels = this.width * this.height;
        if (this.DEBUG) {
            logger.fine("Computing pixels for image size:" + this.width + ", " + this.height);
        }
        int[] iPixels = new int[nPixels];
        int alpha = this.transparent << 24 & 0xFF000000;
        int numColors = this.colors.length;
        int bitsLength = bits.length;
        for (int i = 0; i < bitsLength && i < nPixels; ++i) {
            byte b = bits[i];
            int color = 0;
            if (b < 0) {
                color = this.colors[MoreMath.signedToInt(b)];
            } else if (b < numColors) {
                color = this.colors[b];
            }
            if (this.transparent < 255 && color >> 24 > this.transparent) {
                color = alpha | 0xFFFFFF & color;
            }
            iPixels[i] = color;
        }
        return iPixels;
    }

    public boolean generate(Projection proj) {
        this.renderRotationAngle = null;
        if (!this.position(proj)) {
            if (this.DEBUG) {
                logger.fine("OMRaster.generate(): positioning failed!");
            }
            return false;
        }
        if (this.getNeedToRegenerate()) {
            this.bitmap = this.getBitmapFromInternalData();
            if (this.bitmap == null) {
                return false;
            }
        }
        this.evaluateRotationAngle(proj);
        this.setShape();
        this.setLabelLocation(this.getShape(), proj);
        this.setNeedToRegenerate(false);
        return true;
    }

    protected void evaluateRotationAngle(Projection proj) {
        this.renderRotationAngle = null;
        double projRotation = proj.getRotationAngle();
        if (projRotation != 0.0) {
            boolean compensateForProjRot;
            Object noRotationAtt = this.getAttribute("norotate");
            boolean bl = compensateForProjRot = noRotationAtt != null && !noRotationAtt.equals(Boolean.FALSE);
            if (compensateForProjRot) {
                this.renderRotationAngle = this.rotationAngle - projRotation;
                return;
            }
        }
        if (this.rotationAngle != 0.0) {
            this.renderRotationAngle = this.rotationAngle;
        }
    }

    protected Image getBitmapFromInternalData() {
        Image bi = this.bitmap;
        int[] iPixels = this.pixels;
        byte[] iBits = this.bits;
        int iWidth = this.width;
        int iHeight = this.height;
        ImageFilter iImageFilter = this.imageFilter;
        if (this.colorModel != 2) {
            if (iPixels == null) {
                if (iBits != null) {
                    this.pixels = iPixels = this.computePixels(iBits);
                }
                if (iPixels != null) {
                    logger.fine("attempted to generate without pixels defined!");
                    return null;
                }
            }
            if (iWidth <= 0 || iHeight <= 0 || iPixels == null) {
                return null;
            }
            bi = new BufferedImage(iWidth, iHeight, 2);
            WritableRaster raster = ((BufferedImage)bi).getRaster();
            try {
                raster.setDataElements(0, 0, iWidth, iHeight, iPixels);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                logger.fine("w: " + iWidth + ", h: " + iHeight + ", p.l: " + (iPixels != null ? iPixels.length + ", diff " + (iWidth * iHeight - iPixels.length) : "null"));
            }
        }
        if (iImageFilter != null) {
            bi = this.filterImage(bi);
        }
        return bi;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMRaster) {
            OMRaster raster = (OMRaster)source;
            this.colors = DeepCopyUtil.deepCopy(raster.colors);
            this.transparent = raster.transparent;
        }
    }
}

