/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.HandleError;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMGraphicList
extends OMList<OMGraphic>
implements Serializable {
    public OMGraphicList() {
        this(10);
    }

    public OMGraphicList(int initialCapacity) {
        this.graphics = Collections.synchronizedList(new ArrayList(initialCapacity));
    }

    public OMGraphicList(Collection<OMGraphic> c) {
        this.graphics.addAll(c);
    }

    public Iterator<OMGraphic> iteratorCopy() {
        return new OMGraphicList(this.graphics).iterator();
    }

    public ListIterator<OMGraphic> listIteratorCopy() {
        return new OMGraphicList(this.graphics).listIterator();
    }

    public ListIterator<OMGraphic> listIteratorCopy(int size) {
        return new OMGraphicList(this.graphics).listIterator(size);
    }

    @Override
    public boolean add(OMGraphic g) {
        this.checkForDuplicate(g);
        return this.graphics.add(g);
    }

    public void setOMGraphicAt(OMGraphic graphic, int index) {
        this.graphics.set(index, graphic);
    }

    public OMGraphic getOMGraphicAt(int index) {
        return this.get(index);
    }

    @Override
    public OMGraphic get(int location) {
        return (OMGraphic)this.graphics.get(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStroke(Stroke stroke) {
        super.setStroke(stroke);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setStroke(stroke);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFillPaint(Paint paint) {
        super.setFillPaint(paint);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setFillPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextureMask(TexturePaint texture) {
        super.setTextureMask(texture);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setTextureMask(texture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinePaint(Paint paint) {
        super.setLinePaint(paint);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setLinePaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectPaint(Paint paint) {
        super.setSelectPaint(paint);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setSelectPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMattingPaint(Paint paint) {
        super.setMattingPaint(paint);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setMattingPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMatted(boolean value) {
        super.setMatted(value);
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                omg.setMatted(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGridGenerator(OMGridGenerator generator, Projection proj) {
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic graphic : this.graphics) {
                if (!(graphic instanceof OMGrid)) continue;
                ((OMGrid)graphic).setGenerator(generator);
                if (proj == null) continue;
                graphic.generate(proj);
            }
        }
    }

    public List<OMGraphic> getTargets() {
        if (this.graphics == null) {
            this.graphics = Collections.synchronizedList(new ArrayList(10));
        }
        return this.graphics;
    }

    public void setTargets(List<OMGraphic> list) {
        this.graphics = Collections.synchronizedList(new ArrayList<OMGraphic>(list));
    }

    public void readGraphics(URL cacheURL) throws IOException {
        try {
            ObjectInputStream objstream = new ObjectInputStream(cacheURL.openStream());
            if (Debug.debugging("omgraphics")) {
                Debug.output("OMGraphicList: Opened " + cacheURL.toString());
            }
            this.readGraphics(objstream);
            objstream.close();
            if (Debug.debugging("omgraphics")) {
                Debug.output("OMGraphicList: closed " + cacheURL.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new HandleError(aioobe);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void readGraphics(ObjectInputStream objstream) throws IOException {
        Debug.message("omgraphics", "OMGraphicList: Reading cached graphics");
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        omg = (OMGraphic)objstream.readObject();
                        this.graphics.add(omg);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (OptionalDataException ode) {
                    ode.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var2_5) {
            return;
        }
        ** GOTO lbl-1000
    }

    public void writeGraphics(String graphicsSaveFile) throws IOException {
        FileOutputStream ostream = new FileOutputStream(graphicsSaveFile);
        ObjectOutputStream objectstream = new ObjectOutputStream(ostream);
        this.writeGraphics(objectstream);
        objectstream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGraphics(ObjectOutputStream objectstream) throws IOException {
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic g : this) {
                try {
                    objectstream.writeObject(g);
                }
                catch (IOException e) {
                    Debug.error("OMGraphicList: Couldn't write object " + g + "\nOMGraphicList: Reason: " + e.toString());
                }
            }
        }
        objectstream.close();
    }

    @Override
    public void sort() {
    }

    @Override
    protected OMGraphic objectToOMGraphic(Object obj) {
        if (obj instanceof OMGraphic) {
            return (OMGraphic)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        OMGraphicList omgl = (OMGraphicList)super.clone();
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic omg : this.graphics) {
                if (omg instanceof OMGraphicList) {
                    omgl.add((OMGraphic)((OMGraphicList)omg).clone());
                    continue;
                }
                omgl.graphics.add(omg);
            }
        }
        return omgl;
    }

    @Override
    public OMList<OMGraphic> create() {
        return new OMGraphicList();
    }

    @Override
    protected OMList.OMDist<OMGraphic> createDist() {
        return new OMList.OMDist<OMGraphic>();
    }

    @Override
    public void add(int index, OMGraphic element) {
        this.setNeedToRegenerate(true);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends OMGraphic> c) {
        this.setNeedToRegenerate(true);
        return this.graphics.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends OMGraphic> c) {
        this.setNeedToRegenerate(true);
        return this.graphics.addAll(index, c);
    }

    @Override
    public OMGraphic set(int index, OMGraphic element) {
        this.setNeedToRegenerate(true);
        return this.graphics.set(index, element);
    }

    @Override
    public OMGraphic remove(int location) {
        OMGraphic obj = (OMGraphic)super.remove(location);
        if (obj != null) {
            this.setNeedToRegenerate(true);
        }
        return obj;
    }
}

