/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMGeometryList
extends OMList<OMGeometry>
implements Serializable {
    protected boolean connectParts = false;

    public OMGeometryList() {
    }

    public OMGeometryList(int initialCapacity) {
        super(initialCapacity);
    }

    public OMGeometryList(Collection<OMGeometry> c) {
        this.graphics.addAll(c);
    }

    @Override
    public boolean add(OMGeometry g) {
        this.setNeedToRegenerate(true);
        return super.add(g);
    }

    public boolean addOMGraphic(OMGraphic omg) {
        return super.add(omg);
    }

    public boolean remove(OMGeometry geometry) {
        this.setNeedToRegenerate(true);
        return super.remove(geometry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMGeometry set(int index, OMGeometry geometry) {
        this.setNeedToRegenerate(true);
        List list = this.graphics;
        synchronized (list) {
            return this.graphics.set(index, geometry);
        }
    }

    @Override
    public OMGeometry remove(int location) {
        Object obj = super.remove(location);
        if (obj != null) {
            this.setNeedToRegenerate(true);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics gr) {
        if (this.isVague() && !this.isVisible()) {
            return;
        }
        GeneralPath shp = this.getShape();
        if (shp != null) {
            if (this.matted && gr instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                ((Graphics2D)gr).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                this.setGraphicsColor(gr, this.mattingPaint);
                ((Graphics2D)gr).draw(shp);
            }
            this.setGraphicsForFill(gr);
            ((Graphics2D)gr).fill(shp);
            this.setGraphicsForEdge(gr);
            ((Graphics2D)gr).draw(shp);
        } else {
            List list = this.graphics;
            synchronized (list) {
                if (this.traverseMode == 1) {
                    ListIterator iterator = this.graphics.listIterator(this.graphics.size());
                    while (iterator.hasPrevious()) {
                        this.renderGeometry((OMGeometry)iterator.previous(), gr);
                    }
                } else {
                    ListIterator iterator = this.graphics.listIterator();
                    while (iterator.hasNext()) {
                        this.renderGeometry((OMGeometry)iterator.next(), gr);
                    }
                }
            }
        }
        this.renderLabel(gr);
    }

    protected void renderGeometry(OMGeometry geometry, Graphics gr) {
        boolean isRenderable;
        GeneralPath shp = geometry.getShape();
        boolean bl = isRenderable = !geometry.getNeedToRegenerate() && geometry.isVisible() && shp != null;
        if (isRenderable) {
            if (this.matted && gr instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                ((Graphics2D)gr).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                this.setGraphicsColor(gr, this.mattingPaint);
                this.draw(gr, shp);
            }
            this.setGraphicsForFill(gr);
            this.fill(gr, shp);
            this.setGraphicsForEdge(gr);
            this.draw(gr, shp);
        }
    }

    @Override
    public void renderAllAsSelected(Graphics gr) {
        GeneralPath shape = this.getShape();
        if (shape != null) {
            this.setGraphicsForFill(gr);
            ((Graphics2D)gr).fill(shape);
            this.select();
            this.setGraphicsForEdge(gr);
            ((Graphics2D)gr).draw(shape);
            this.deselect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generate(Projection p, boolean forceProjectAll) {
        this.setNeedToRegenerate(true);
        GeneralPath projectedShape = null;
        List list = this.graphics;
        synchronized (list) {
            if (this.traverseMode == 1) {
                ListIterator iterator = this.graphics.listIterator(this.size());
                while (iterator.hasPrevious()) {
                    projectedShape = this.updateShape(projectedShape, (OMGeometry)iterator.previous(), p, forceProjectAll);
                }
            } else {
                ListIterator iterator = this.graphics.listIterator();
                while (iterator.hasNext()) {
                    projectedShape = this.updateShape(projectedShape, (OMGeometry)iterator.next(), p, forceProjectAll);
                }
            }
        }
        this.setShape(projectedShape);
        this.setLabelLocation(projectedShape, p);
        this.setNeedToRegenerate(false);
        return projectedShape != null;
    }

    protected void updateShape(OMGeometry geometry, Projection p, boolean forceProject) {
        if (geometry.isVisible()) {
            if (forceProject) {
                geometry.generate(p);
            } else {
                geometry.regenerate(p);
            }
            this.setShape(OMGeometryList.appendShapeEdge(this.getShape(), geometry.getShape(), this.connectParts));
        }
    }

    protected GeneralPath updateShape(GeneralPath currentShape, OMGeometry geometry, Projection p, boolean forceProject) {
        GeneralPath newShapePart = null;
        if (geometry != null && geometry.isVisible()) {
            if (forceProject) {
                geometry.generate(p);
            } else {
                geometry.regenerate(p);
            }
            newShapePart = geometry.getShape();
        }
        return OMGeometryList.appendShapeEdge(currentShape, newShapePart, this.connectParts);
    }

    /*
     * Unable to fully structure code
     */
    public void readGraphics(ObjectInputStream objstream) throws IOException {
        Debug.message("omgraphics", "OMGeometryList: Reading cached geometries");
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        omg = (OMGeometry)objstream.readObject();
                        this.add(omg);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (OptionalDataException ode) {
                    ode.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var2_5) {
            return;
        }
        ** GOTO lbl-1000
    }

    public void setConnectParts(boolean value) {
        this.connectParts = value;
    }

    public boolean getConnectParts() {
        return this.connectParts;
    }

    public Iterator<OMGeometry> iteratorCopy() {
        return new OMGeometryList(this.graphics).iterator();
    }

    public ListIterator<OMGeometry> listIteratorCopy() {
        return new OMGeometryList(this.graphics).listIterator();
    }

    public ListIterator<OMGeometry> listIteratorCopy(int size) {
        return new OMGeometryList(this.graphics).listIterator(size);
    }

    @Override
    public OMList<OMGeometry> create() {
        return new OMGeometryList();
    }

    @Override
    protected OMList.OMDist<OMGeometry> createDist() {
        return new OMList.OMDist<OMGeometry>();
    }

    @Override
    public void clear() {
        this.setNeedToRegenerate(true);
        super.clear();
    }

    @Override
    public void add(int index, OMGeometry element) {
        this.setNeedToRegenerate(true);
        super.add(index, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends OMGeometry> c) {
        this.setNeedToRegenerate(true);
        List list = this.graphics;
        synchronized (list) {
            return this.graphics.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends OMGeometry> c) {
        this.setNeedToRegenerate(true);
        List list = this.graphics;
        synchronized (list) {
            return this.graphics.addAll(index, c);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.setNeedToRegenerate(true);
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.setNeedToRegenerate(true);
        return super.retainAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMGeometry get(int index) {
        List list = this.graphics;
        synchronized (list) {
            return (OMGeometry)this.graphics.get(index);
        }
    }
}

