/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageCharVdt;
import com.bbn.openmap.layer.vpf.CoverageIntVdt;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.DcwThematicIndex;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.layer.vpf.TableHolder;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFAutoFeatureGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.layer.vpf.VPFWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageTable {
    protected static final Logger logger = Logger.getLogger("com.bbn.openmap.layer.vpf.CoverageTable");
    public final String covtype;
    protected final String tablepath;
    private final Map<CoverageIntVdt, String> intvdtrec = new HashMap<CoverageIntVdt, String>();
    private final Map<CoverageCharVdt, String> charvdtrec = new HashMap<CoverageCharVdt, String>();
    public int[] cachedLineSchema = null;
    public int[] cachedAreaSchema = null;
    public int[] cachedTextSchema = null;
    public int[] cachedEPointSchema = null;
    public int[] cachedCPointSchema = null;
    public FeatureClassInfo[] lineinfo = new FeatureClassInfo[0];
    public FeatureClassInfo[] areainfo = new FeatureClassInfo[0];
    public FeatureClassInfo[] textinfo = new FeatureClassInfo[0];
    public FeatureClassInfo[] epointinfo = new FeatureClassInfo[0];
    public FeatureClassInfo[] cpointinfo = new FeatureClassInfo[0];
    protected Hashtable<String, FeatureClassInfo> featureTypes = new Hashtable();
    protected Hashtable<String, FeatureClassRec> featureTypeInfo;
    public boolean appendDot = false;
    protected CoverageAttributeTable cat;
    public final boolean doAntarcticaWorkaround;
    public static final char EDGE_FEATURETYPE = 'L';
    public static final char AREA_FEATURETYPE = 'A';
    public static final char TEXT_FEATURETYPE = 'T';
    public static final char UPOINT_FEATURETYPE = 'P';
    public static final char EPOINT_FEATURETYPE = 'E';
    public static final char CPOINT_FEATURETYPE = 'N';
    public static final char COMPLEX_FEATURETYPE = 'C';
    public static final char SKIP_FEATURETYPE = 'S';
    public static final String[] VDTColumnNames = new String[]{"table", "attribute", "value", "description"};
    public static final char[] intVDTschematype = new char[]{'I', 'T', 'T', 'i', 'T'};
    public static final int[] intVDTschemalength = new int[]{1, -1, -1, 1, -1};
    public static final char[] charVDTschematype = new char[]{'I', 'T', 'T', 'T', 'T'};
    public static final int[] charVDTschemalength = new int[]{1, -1, -1, -1, -1};
    private static final String[] fcsColumns = new String[]{"feature_class", "table1", "table1_key", "table2", "table2_key"};
    private static final String[] fcsColumnsDCW = new String[]{"feature_class", "table1", "foreign_key", "table2", "primary_key"};

    public CoverageTable(String path, String covtype) {
        this.covtype = covtype;
        this.tablepath = path + "/" + covtype + "/";
        this.doAntarcticaWorkaround = this.tablepath.indexOf("browse") >= 0;
        this.internSchema();
        this.loadIntVDT();
        this.loadCharVDT();
        this.featureTypeInfo = this.getFeatureTypeInfo();
    }

    public CoverageTable(String path, String covtype, CoverageAttributeTable cat) {
        this(path, covtype);
        this.cat = cat;
    }

    private void loadIntVDT() {
        try {
            String vdt = this.tablepath + "int.vdt";
            if (BinaryFile.exists(vdt)) {
                DcwRecordFile intvdt = new DcwRecordFile(vdt);
                int[] cols = intvdt.lookupSchema(VDTColumnNames, true, intVDTschematype, intVDTschemalength, false);
                ArrayList<Object> l = new ArrayList<Object>(intvdt.getColumnCount());
                while (intvdt.parseRow(l)) {
                    String tab = (String)l.get(cols[0]);
                    String attr = (String)l.get(cols[1]);
                    int val = ((Number)l.get(cols[2])).intValue();
                    String desc = ((String)l.get(cols[3])).intern();
                    this.intvdtrec.put(new CoverageIntVdt(tab, attr, val), desc);
                }
                intvdt.close();
            }
        }
        catch (FormatException formatException) {
            // empty catch block
        }
    }

    private void loadCharVDT() {
        try {
            String vdt = this.tablepath + "char.vdt";
            if (BinaryFile.exists(vdt)) {
                DcwRecordFile charvdt = new DcwRecordFile(vdt);
                int[] cols = charvdt.lookupSchema(VDTColumnNames, true, charVDTschematype, charVDTschemalength, false);
                ArrayList<Object> l = new ArrayList<Object>(charvdt.getColumnCount());
                while (charvdt.parseRow(l)) {
                    String tab = (String)l.get(cols[0]);
                    String attr = (String)l.get(cols[1]);
                    String val = (String)l.get(cols[2]);
                    String desc = ((String)l.get(cols[3])).intern();
                    this.charvdtrec.put(new CoverageCharVdt(tab, attr, val), desc);
                }
                charvdt.close();
            }
        }
        catch (FormatException formatException) {
            // empty catch block
        }
    }

    private FeatureClassInfo[] internSchema(FeatureClassInfo[] fti, String foreign_key, String tablename) throws FormatException {
        FeatureClassInfo[] rv = new FeatureClassInfo[fti.length + 1];
        System.arraycopy(fti, 0, rv, 0, fti.length);
        rv[fti.length] = new FeatureClassInfo(this, foreign_key.intern(), this.tablepath, tablename.intern());
        return rv;
    }

    private void internSchema() {
        this.internSchema(false);
    }

    private void internSchema(boolean DCW) {
        boolean addSlash = true;
        if (this.tablepath.endsWith("/") || this.tablepath.endsWith(File.separator)) {
            addSlash = false;
        }
        try {
            String filename = this.tablepath + (addSlash ? "/" : "") + "fcs";
            if (!BinaryFile.exists(filename)) {
                filename = filename + ".";
                this.appendDot = true;
            }
            DcwRecordFile fcs = new DcwRecordFile(filename);
            int[] fcscols = fcs.lookupSchema(DCW ? fcsColumnsDCW : fcsColumns, true);
            ArrayList<Object> fcsrec = new ArrayList<Object>(fcs.getColumnCount());
            while (fcs.parseRow(fcsrec)) {
                String feature_class = (String)fcsrec.get(fcscols[0]);
                String table1 = (String)fcsrec.get(fcscols[1]);
                String foreign_key = (String)fcsrec.get(fcscols[2]);
                String table2 = (String)fcsrec.get(fcscols[3]);
                String primary_key = (String)fcsrec.get(fcscols[4]);
                this.internSchema(feature_class.toLowerCase(), table1.toLowerCase(), foreign_key.toLowerCase(), table2.toLowerCase(), primary_key.toLowerCase());
            }
            fcs.close();
        }
        catch (FormatException f) {
            if (!DCW) {
                this.internSchema(true);
            }
            System.out.println("CoverageTable: " + f.getMessage());
        }
    }

    private void internSchema(String feature_class, String table1, String foreign_key, String table2, String primary_key) {
        try {
            if (table1.equals("fac")) {
                this.areainfo = this.internSchema(this.areainfo, foreign_key, table2);
            } else if (table1.equals("edg")) {
                this.lineinfo = this.internSchema(this.lineinfo, foreign_key, table2);
            } else if (table1.equals("end")) {
                this.epointinfo = this.internSchema(this.epointinfo, foreign_key, table2);
            } else if (table1.equals("cnd")) {
                this.cpointinfo = this.internSchema(this.cpointinfo, foreign_key, table2);
            } else if (table1.equals("txt")) {
                this.textinfo = this.internSchema(this.textinfo, foreign_key, table2);
            } else if (table1.startsWith(feature_class) && (foreign_key.equals("end_id") || foreign_key.equals("cnd_id") || foreign_key.equals("fac_id") || foreign_key.equals("edg_id") || foreign_key.equals("txt_id"))) {
                if (Debug.debugging("vpf")) {
                    Debug.output("CoverageTable: Found entry for: " + feature_class + ": " + table1 + "|" + foreign_key + "|" + table2 + "|" + primary_key);
                }
                FeatureClassInfo featureClass = new FeatureClassInfo(this, foreign_key.intern(), this.tablepath.intern(), table1.intern(), table2.intern(), foreign_key.intern());
                featureClass.close(false);
                this.featureTypes.put(feature_class.intern(), featureClass);
            }
        }
        catch (FormatException f) {
            System.out.println("internSchema: " + f.getMessage());
        }
    }

    public String getDataPath() {
        return this.tablepath;
    }

    public Map<String, FeatureClassInfo> getFeatureClasses() {
        return Collections.unmodifiableMap(this.featureTypes);
    }

    public FeatureClassInfo getFeatureClassInfo(String featureType) {
        return this.featureTypes.get(featureType);
    }

    public String getDescription(String t, String a, int v) {
        CoverageIntVdt civ = new CoverageIntVdt(t, a, v);
        return this.intvdtrec.get(civ);
    }

    public String getDescription(String t, String a, String v) {
        CoverageCharVdt civ = new CoverageCharVdt(t, a, v);
        return this.charvdtrec.get(civ);
    }

    private String getDescription(List<Object> id, FeatureClassInfo[] fti, MutableInt ret) {
        if (fti == null || fti.length == 0) {
            return null;
        }
        StringBuffer foo = null;
        for (int i = 0; i < fti.length; ++i) {
            String desc = fti[i].getDescription(id, ret);
            if (desc == null) continue;
            if (foo == null) {
                foo = new StringBuffer(desc);
                continue;
            }
            foo.append(";; ").append(desc);
        }
        return foo == null ? null : foo.toString();
    }

    public String getLineDescription(List<Object> lineid, MutableInt retval) {
        return this.getDescription(lineid, this.lineinfo, retval);
    }

    public String getTextDescription(List<Object> textid, MutableInt retval) {
        return this.getDescription(textid, this.textinfo, retval);
    }

    public String getEPointDescription(List<Object> pointid, MutableInt retval) {
        return this.getDescription(pointid, this.epointinfo, retval);
    }

    public String getCPointDescription(List<Object> pointid, MutableInt retval) {
        return this.getDescription(pointid, this.cpointinfo, retval);
    }

    public String getAreaDescription(List<Object> areaid, MutableInt retval) {
        return this.getDescription(areaid, this.areainfo, retval);
    }

    public void setCoverateAttributeTable(CoverageAttributeTable cat) {
        this.cat = cat;
    }

    public CoverageAttributeTable getCoverageAttributeTable() {
        return this.cat;
    }

    public void drawTile(TileDirectory drawtd, VPFGraphicWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon) {
        if (Debug.debugging("vpf.tile")) {
            Debug.output("Drawtile for " + drawtd);
        }
        TableHolder tables = new TableHolder(this);
        tables.drawTile(drawtd, warehouse, ll1, ll2, dpplat, dpplon);
    }

    public boolean drawFeatures(VPFFeatureWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon) {
        boolean didSomething = false;
        TableHolder tables = new TableHolder(this);
        List<String> featureList = warehouse.getFeatures();
        for (String currentFeature : featureList) {
            FeatureClassInfo fci;
            block16: {
                char featureType = this.whatFeatureType(warehouse, currentFeature);
                if (featureType == 'S') continue;
                if (Debug.debugging("vpf")) {
                    Debug.output("CoverageTable getting " + currentFeature + " features");
                }
                fci = this.getFeatureClassInfo(currentFeature);
                int fciFeatureIDCol = fci.whatColumn("id");
                if (fci == null || this.cat == null || currentFeature == null) continue;
                if (this.drawFeaturesFromThematicIndex(fci, warehouse, tables, ll1, ll2, dpplat, dpplon, currentFeature, featureType)) {
                    didSomething = true;
                    continue;
                }
                boolean needToFindOurselves = true;
                TilingAdapter fciTilingAdapter = fci.getTilingAdapter();
                if (fciTilingAdapter == null) continue;
                TileDirectory currentTile = null;
                int oldTileID = -2;
                try {
                    int getrow = 1;
                    ArrayList<Object> fcirow = new ArrayList<Object>();
                    while (fci.getRow(fcirow, getrow++)) {
                        int featureID;
                        int primitiveID;
                        int tileID;
                        if (Debug.debugging("vpfdetail")) {
                            Debug.output("CoverageTable new feature " + fcirow);
                        }
                        if ((tileID = fciTilingAdapter.getTileId(fcirow)) != oldTileID) {
                            tables.close();
                            if (Debug.debugging("vpf.tile")) {
                                Debug.output("CoverageTable.drawFeatures(): opening new tile (" + tileID + ")");
                            }
                            TileDirectory tileDirectory = currentTile = tileID == -1 ? new TileDirectory() : this.cat.getTileWithID(tileID);
                            if (currentTile == null) {
                                Debug.error("VPFLayer|CoverageTable.drawFeatures: null tile from bogus ID (" + tileID + ") from " + fci.filename + ", skipping...");
                                continue;
                            }
                            if (tileID == -1 || currentTile.inRegion(ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude())) {
                                String libraryname = "";
                                if (this.cat != null) {
                                    libraryname = this.cat.libraryname;
                                }
                                if (!warehouse.needToFetchTileContents(libraryname, currentFeature, currentTile)) {
                                    if (!Debug.debugging("vpf")) continue;
                                    Debug.output("CoverageTable: Loaded Cached List for " + currentFeature + " and " + currentTile.getPath());
                                    continue;
                                }
                                if (Debug.debugging("vpf.tile")) {
                                    Debug.output("CoverageTable: Drawing " + featureType + " features for " + currentTile);
                                }
                                tables.setTables(featureType, currentTile);
                                if (needToFindOurselves) {
                                    needToFindOurselves = false;
                                    tables.findYourself(fci);
                                }
                            } else {
                                tables.close();
                            }
                            oldTileID = tileID;
                        }
                        if (tables.drawFeature(primitiveID = fciTilingAdapter.getPrimId(fcirow), warehouse, ll1, ll2, dpplat, dpplon, currentFeature, featureID = ((Number)fcirow.get(fciFeatureIDCol)).intValue()) == null) continue;
                        didSomething = true;
                    }
                }
                catch (FormatException f) {
                    if (!Debug.debugging("vpf.FormatException")) break block16;
                    Debug.output("CoverageTable: Creating table: " + f.getClass() + " " + f.getMessage());
                }
            }
            fci.close();
        }
        tables.close();
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean drawFeaturesFromThematicIndex(FeatureClassInfo fci, VPFFeatureWarehouse warehouse, TableHolder tables, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, String currentFeature, char featureType) {
        if (!fci.initThematicIndex(this.tablepath)) {
            return false;
        }
        ArrayList<Object> v = new ArrayList<Object>();
        try {
            int primitiveIdColIndex = fci.getTilePrimitiveIdColIndex();
            DcwThematicIndex thematicIndex = fci.getThematicIndex();
            Object[] indexes = thematicIndex.getValueIndexes();
            fci.reopen(1);
            for (int i = 0; i < indexes.length; ++i) {
                int tileID = VPFUtil.objectToInt(indexes[i]);
                TileDirectory currentTile = this.cat.getTileWithID(tileID);
                if (currentTile == null) {
                    Debug.error("VPFLayer|CoverageTable.drawFeatures: null tile from bogus ID (" + tileID + ") from " + fci.filename + ", skipping...");
                    continue;
                }
                if (currentTile.inRegion(ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude())) {
                    String libraryname;
                    tables.setTables(featureType, currentTile);
                    tables.findYourself(fci);
                    int[] featureID = thematicIndex.get(indexes[i]);
                    if (Debug.debugging("vpf.tile")) {
                        Debug.output("Drawing " + featureID.length + " " + featureType + " features for " + tileID + " " + currentTile);
                    }
                    if (!warehouse.needToFetchTileContents(libraryname = this.cat.libraryname, currentFeature, currentTile)) {
                        if (!Debug.debugging("vpf")) continue;
                        Debug.output("Loaded Cached List for " + currentFeature + " and " + currentTile.getPath());
                        continue;
                    }
                    for (int j = 0; j < featureID.length; ++j) {
                        int featurePrimID = featureID[j];
                        if (!fci.getRow(v, featurePrimID)) continue;
                        int primitiveID = VPFUtil.objectToInt(v.get(primitiveIdColIndex));
                        tables.drawFeature(primitiveID, warehouse, ll1, ll2, dpplat, dpplon, currentFeature, featurePrimID);
                    }
                    tables.close();
                    continue;
                }
                if (!Debug.debugging("vpf.tile")) continue;
                Debug.output("Skipping " + featureType + " features for " + tileID + ", not on map");
            }
            boolean bl = true;
            return bl;
        }
        catch (FormatException f) {
            if (Debug.debugging("vpf.FormatException")) {
                Debug.output("CoverageTable.DFFTI: Format Exception creating features: " + f.getClass() + " " + f.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            fci.close();
        }
    }

    public void getFeatures(VPFAutoFeatureGraphicWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, OMGraphicList omgList) throws FormatException {
        Map<String, FeatureClassInfo> featureInfo = this.getFeatureClasses();
        TableHolder tables = new TableHolder(this);
        for (Map.Entry<String, FeatureClassInfo> entry : featureInfo.entrySet()) {
            int faccIndex;
            String featureName = entry.getKey();
            FeatureClassInfo fci = entry.getValue();
            if (fci == null) continue;
            int fciFeatureIDCol = fci.whatColumn("id");
            char featureType = this.whatFeatureType(warehouse, featureName);
            fci.checkInit();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" for " + featureName + ": " + fci.getDescription());
            }
            if ((faccIndex = fci.getFaccIndex()) < 0) continue;
            int primitiveIDIndex = fci.getTilePrimitiveIdColIndex();
            int tileIDIndex = fci.getTileIdIndex();
            TileDirectory currentTile = null;
            boolean needToFindOurselves = true;
            TilingAdapter fciTilingAdapter = fci.getTilingAdapter();
            if (fciTilingAdapter == null) continue;
            int oldTileID = -2;
            int getrow = 1;
            ArrayList<Object> fcirow = new ArrayList<Object>();
            while (fci.getRow(fcirow, getrow++)) {
                String facc = (String)fcirow.get(faccIndex);
                List<VPFAutoFeatureGraphicWarehouse.FeaturePriorityHolder> list = warehouse.faccLookup.get(facc);
                if (list != null) {
                    boolean foundMatch = false;
                    for (VPFAutoFeatureGraphicWarehouse.FeaturePriorityHolder ph : list) {
                        int featureID;
                        int primitiveID;
                        OMGraphic omg;
                        int tileID;
                        if (!ph.matches(facc, fci, fcirow)) continue;
                        foundMatch = true;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("+++ MATCH FOUND for " + facc + " tileid:" + fcirow.get(tileIDIndex) + ", primID:" + fcirow.get(primitiveIDIndex));
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("CoverageTable new feature " + fcirow);
                        }
                        if ((tileID = fciTilingAdapter.getTileId(fcirow)) != oldTileID) {
                            tables.close();
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("opening new tile (" + tileID + ")");
                            }
                            TileDirectory tileDirectory = currentTile = tileID == -1 ? new TileDirectory() : this.cat.getTileWithID(tileID);
                            if (currentTile == null) {
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.warning("VPFLayer|CoverageTable.drawFeatures: null tile from bogus ID (" + tileID + ") from " + fci.filename + ", skipping...");
                                continue;
                            }
                            if (tileID == -1 || currentTile.inRegion(ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude())) {
                                String libraryname = "";
                                if (this.cat != null) {
                                    libraryname = this.cat.libraryname;
                                }
                                if (!warehouse.needToFetchTileContents(libraryname, featureName, currentTile)) {
                                    if (!Debug.debugging("vpf")) continue;
                                    Debug.output("CoverageTable: Loaded Cached List for " + featureName + " and " + currentTile.getPath());
                                    continue;
                                }
                                if (Debug.debugging("vpf.tile")) {
                                    Debug.output("CoverageTable: Drawing " + featureType + " features for " + currentTile);
                                }
                                try {
                                    tables.setTables(featureType, currentTile);
                                }
                                catch (FormatException fe) {
                                    System.out.println("missing tile, let's ignore that");
                                    continue;
                                }
                                if (needToFindOurselves) {
                                    needToFindOurselves = false;
                                    tables.findYourself(fci);
                                }
                            } else {
                                tables.close();
                            }
                            oldTileID = tileID;
                        }
                        if ((omg = tables.drawFeature(primitiveID = fciTilingAdapter.getPrimId(fcirow), warehouse, ll1, ll2, dpplat, dpplon, featureName, featureID = ((Number)fcirow.get(fciFeatureIDCol)).intValue())) == null) continue;
                        warehouse.handleInformationForOMGraphic(omg, fci, fcirow);
                        ph.add(omg);
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        StringBuffer pout = new StringBuffer();
                        for (Object e : fcirow) {
                            pout.append(e).append(',');
                        }
                        logger.finest(pout.toString());
                    }
                    if (foundMatch || !logger.isLoggable(Level.FINE)) continue;
                    logger.fine("--- NO MATCH FOUND for " + facc + ", type:" + featureType + ", tileid:" + fcirow.get(tileIDIndex) + ", primID:" + fcirow.get(primitiveIDIndex));
                    continue;
                }
                if (warehouse.debugFacc != null || !logger.isLoggable(Level.FINE)) continue;
                logger.info("didn't find facc list for: " + facc);
            }
            fci.close();
        }
        tables.close();
    }

    protected OMGraphic getOMGraphicForFeature() {
        OMGraphic omg = null;
        return omg;
    }

    protected char whatFeatureType(VPFWarehouse warehouse, String featureName) {
        char featureType = 'S';
        FeatureClassInfo fci = this.getFeatureClassInfo(featureName);
        if (fci == null) {
            return featureType;
        }
        char type = fci.getFeatureType();
        if (type == 'A' && warehouse.drawAreaFeatures() || type == 'T' && warehouse.drawTextFeatures() || type == 'L' && warehouse.drawEdgeFeatures() || type == 'E' && warehouse.drawEPointFeatures() || type == 'N' && warehouse.drawCPointFeatures()) {
            featureType = type;
        }
        return featureType;
    }

    public Hashtable<String, FeatureClassRec> getFeatureTypeInfo() {
        if (this.featureTypeInfo == null) {
            String fca;
            this.featureTypeInfo = new Hashtable();
            String path = this.getDataPath();
            boolean addSlash = true;
            if (path.endsWith("/") || path.endsWith(File.separator)) {
                addSlash = false;
            }
            if (!BinaryFile.exists(fca = path + (addSlash ? "/" : "") + "fca")) {
                fca = fca + ".";
            }
            if (BinaryFile.exists(fca)) {
                try {
                    DcwRecordFile fcadesc = new DcwRecordFile(fca);
                    int fclass = fcadesc.whatColumn("fclass");
                    int type = fcadesc.whatColumn("type");
                    int descr = fcadesc.whatColumn("descr");
                    ArrayList<Object> al = new ArrayList<Object>(fcadesc.getColumnCount());
                    while (fcadesc.parseRow(al)) {
                        String fname = ((String)al.get(fclass)).toLowerCase().intern();
                        char ftype = ((String)al.get(type)).charAt(0);
                        String fdesc = (String)al.get(descr);
                        FeatureClassRec fcr = new FeatureClassRec(fname, ftype, fdesc);
                        this.featureTypeInfo.put(fname, fcr);
                    }
                    fcadesc.close();
                }
                catch (FormatException fe) {
                    // empty catch block
                }
            }
        }
        return this.featureTypeInfo;
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("This main() is just assorted test code.");
            System.out.println("Usage: java classname librarypath coveragename");
            System.out.println("    tablename attribute value");
            System.out.println("Result: Prints the corresponding value in int.vdt");
        } else {
            CoverageTable ct = new CoverageTable(args[0], args[1]);
            String desc = ct.getDescription(args[2], args[3], Integer.parseInt(args[4]));
            System.out.println(desc);
        }
    }

    public static class FeatureClassRec {
        public final String feature_class;
        public final char type;
        public final String description;

        public FeatureClassRec(String fclass, char type, String desc) {
            this.feature_class = fclass;
            this.type = type;
            this.description = desc;
        }
    }
}

