/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPoly;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.geom.PolygonGeometry;
import com.bbn.openmap.omGraphics.geom.PolylineGeometry;
import com.bbn.openmap.proj.ProjMath;
import java.io.IOException;

public class ESRIPolygonRecord
extends ESRIRecord {
    protected int shapeType = 5;
    public ESRIBoundingBox bounds;
    public ESRIPoly[] polygons;

    public ESRIPolygonRecord() {
        this.bounds = new ESRIBoundingBox();
        this.polygons = new ESRIPoly[0];
    }

    public ESRIPolygonRecord(byte[] b, int off) throws IOException {
        super(b, off);
        int _len;
        int i;
        int ptr = off + 8;
        this.shapeType = ESRIPolygonRecord.readLEInt(b, ptr);
        ptr += 4;
        if (this.shapeType != 5 && this.shapeType != 3) {
            throw new IOException("Invalid polygon record. Expected shape type 5 or type 3, but found " + this.shapeType);
        }
        boolean ispolyg = this.isPolygon();
        this.bounds = ESRIPolygonRecord.readBox(b, ptr);
        int numParts = ESRIPolygonRecord.readLEInt(b, ptr += 32);
        int numPoints = ESRIPolygonRecord.readLEInt(b, ptr += 4);
        ptr += 4;
        if (numParts <= 0) {
            this.polygons = new ESRIPoly[0];
            return;
        }
        this.polygons = new ESRIPoly[numParts];
        int origin = 0;
        for (i = 0; i < numParts; ++i) {
            int nextOrigin = ESRIPolygonRecord.readLEInt(b, ptr);
            ptr += 4;
            if (i > 0) {
                _len = nextOrigin - origin;
                if (ispolyg) {
                    ++_len;
                }
                this.polygons[i - 1] = new ESRIPoly.ESRIFloatPoly(_len);
            }
            origin = nextOrigin;
        }
        _len = numPoints - origin;
        if (ispolyg) {
            ++_len;
        }
        this.polygons[numParts - 1] = new ESRIPoly.ESRIFloatPoly(_len);
        for (i = 0; i < numParts; ++i) {
            ptr += this.polygons[i].read(b, ptr, ispolyg);
        }
    }

    public boolean isPolygon() {
        return this.shapeType == 5;
    }

    public void setPolygon(boolean isPolygon) {
        this.shapeType = isPolygon ? 5 : 3;
    }

    public void add(double[] radians) {
        ESRIPoly.ESRIFloatPoly newPoly = new ESRIPoly.ESRIFloatPoly(radians);
        int numParts = this.polygons.length;
        ESRIPoly[] oldPolys = this.polygons;
        this.polygons = new ESRIPoly[numParts + 1];
        System.arraycopy(oldPolys, 0, this.polygons, 0, numParts);
        this.polygons[numParts] = newPoly;
        int len = radians.length;
        for (int i = 0; i < len; i += 2) {
            this.bounds.addPoint(ProjMath.radToDeg(radians[i + 1]), ProjMath.radToDeg(radians[i]));
        }
    }

    public void addOMGraphics(OMGraphicList list, DrawingAttributes drawingAttributes) {
        int nPolys = this.polygons.length;
        if (nPolys <= 0) {
            return;
        }
        OMPoly p = null;
        boolean ispolyg = this.isPolygon();
        OMGraphicList sublist = null;
        if (nPolys > 1) {
            sublist = new OMGraphicList();
            if (drawingAttributes != null) {
                drawingAttributes.setTo(sublist);
            }
            sublist.setVague(true);
            list.add(sublist);
            sublist.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(this.getRecordNumber()));
        }
        for (int i = 0; i < nPolys; ++i) {
            double[] pts = ((ESRIPoly.ESRIFloatPoly)this.polygons[i]).getRadians();
            p = new OMPoly(pts, 1, 1);
            if (drawingAttributes != null) {
                drawingAttributes.setTo(p);
            }
            if (!ispolyg) {
                p.setIsPolygon(false);
            }
            if (sublist != null) {
                ((OMList)sublist).add(p);
                continue;
            }
            p.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(this.getRecordNumber()));
            list.add(p);
        }
    }

    public OMGeometry addOMGeometry(OMGeometryList list) {
        int nPolys = this.polygons.length;
        if (nPolys <= 0) {
            return null;
        }
        boolean ispolyg = this.isPolygon();
        PolygonGeometry.LL geom = null;
        for (int i = 0; i < nPolys; ++i) {
            double[] pts = ((ESRIPoly.ESRIFloatPoly)this.polygons[i]).getRadians();
            geom = ispolyg ? new PolygonGeometry.LL(pts, 1, 1) : new PolylineGeometry.LL(pts, 1, 1);
            list.add(geom);
        }
        return geom;
    }

    public ESRIBoundingBox getBoundingBox() {
        return this.bounds;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getRecordLength() {
        int numParts = this.polygons.length;
        int numPoints = 0;
        for (int i = 0; i < numParts; ++i) {
            numPoints += this.polygons[i].nPoints;
        }
        return 44 + numParts * 4 + numPoints * 16;
    }

    public int write(byte[] b, int off) {
        int i;
        int nBytes = super.write(b, off);
        nBytes += ESRIPolygonRecord.writeLEInt(b, off + nBytes, this.shapeType);
        nBytes += ESRIPolygonRecord.writeBox(b, off + nBytes, this.bounds);
        int numParts = this.polygons.length;
        nBytes += ESRIPolygonRecord.writeLEInt(b, off + nBytes, numParts);
        int numPoints = 0;
        for (int i2 = 0; i2 < numParts; ++i2) {
            numPoints += this.polygons[i2].nPoints;
        }
        nBytes += ESRIPolygonRecord.writeLEInt(b, off + nBytes, numPoints);
        int ptr = 0;
        for (i = 0; i < numParts; ++i) {
            nBytes += ESRIPolygonRecord.writeLEInt(b, off + nBytes, ptr);
            ptr += this.polygons[i].nPoints;
        }
        for (i = 0; i < numParts; ++i) {
            double[] pts = ((ESRIPoly.ESRIFloatPoly)this.polygons[i]).getRadians();
            int nPts = pts.length;
            for (int j = 0; j < nPts; j += 2) {
                nBytes += ESRIPolygonRecord.writeLEDouble(b, off + nBytes, ProjMath.radToDeg(pts[j + 1]));
                nBytes += ESRIPolygonRecord.writeLEDouble(b, off + nBytes, ProjMath.radToDeg(pts[j]));
            }
        }
        return nBytes;
    }
}

