/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfCoverageManager;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfLayer;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RpfCoverage
extends OMGraphicList
implements RpfConstants,
PropertyConsumer {
    public static final String CoverageOpaquenessProperty = "coverageOpaque";
    public static final String FillProperty = "coverageFill";
    private static final long serialVersionUID = 1L;
    protected RpfCoverageManager coverageManager = null;
    protected RpfFrameProvider frameProvider = null;
    protected Map<RpfProductInfo, RpfCoverageControl> coverages = new TreeMap<RpfProductInfo, RpfCoverageControl>(new RCCScaleComparator());
    protected String propertyPrefix = null;
    protected int opaqueness = 255;
    protected boolean fillRects = true;
    protected Layer layer;
    protected boolean inUse = false;
    protected boolean showPalette = true;
    protected I18n i18n = Environment.getI18n();
    protected JFrame paletteWindow = null;

    public RpfCoverage(Layer l, RpfFrameProvider frameProvider) {
        this.layer = l;
        this.setFrameProvider(frameProvider);
        super.setTraverseMode(0);
    }

    public void setFrameProvider(RpfFrameProvider frameProvider) {
        this.frameProvider = frameProvider;
        if (frameProvider != null) {
            List<RpfCoverageBox> rpfCoverages = frameProvider.getCatalogCoverage(90.0, -180.0, -90.0, 180.0, new CADRG(new LatLonPoint.Double(), 1.0E7f, 200, 200), null);
            for (RpfCoverageBox rcb : rpfCoverages) {
                RpfCoverageControl control;
                RpfProductInfo rpfPI = RpfProductInfo.get(rcb.chartCode);
                if (rpfPI == null || (control = this.coverages.get(RpfProductInfo.get(rcb.chartCode))) != null) continue;
                control = new RpfCoverageControl(rpfPI, this.layer);
                this.coverages.put(rpfPI, control);
                control.setFilled(this.fillRects);
                control.setFillPaint(this.getModifiedColor((Color)control.getFillPaint()));
            }
        }
    }

    protected void setDefaultValues() {
        this.allCoveragesOn();
        this.opaqueness = 127;
        this.fillRects = true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean iu) {
        this.inUse = iu;
        this.setVisible(iu);
        if (this.showPalette || !this.inUse) {
            JFrame covPalette = this.getPaletteWindow();
            covPalette.setLocationRelativeTo(this.layer.getPalette());
            covPalette.setVisible(this.inUse);
        }
    }

    public boolean isShowPalette() {
        return this.showPalette;
    }

    public void setShowPalette(boolean sp) {
        this.showPalette = sp;
        if (!this.showPalette) {
            this.allCoveragesOn();
        }
    }

    public void allCoveragesOn() {
        for (RpfCoverageControl rcc : this.coverages.values()) {
            rcc.setVisible(true);
        }
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties properties) {
        this.setPropertyPrefix(prefix);
        this.setDefaultValues();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.fillRects = PropUtils.booleanFromProperties(properties, prefix + FillProperty, this.fillRects);
        this.showPalette = PropUtils.booleanFromProperties(properties, prefix + "coverage", this.showPalette);
        this.opaqueness = PropUtils.intFromProperties(properties, prefix + CoverageOpaquenessProperty, this.opaqueness);
        for (RpfCoverageControl rcc : this.coverages.values()) {
            String abbrdot = PropUtils.getScopedPropertyPrefix(rcc.rpfProduct.abbr.replace(' ', '_'));
            rcc.setColorValue(properties.getProperty(prefix + abbrdot + "color", rcc.getColorValue()));
            rcc.setFilled(this.fillRects);
            rcc.setFillPaint(this.getModifiedColor((Color)rcc.getFillPaint()));
            rcc.setVisible(PropUtils.booleanFromProperties(properties, prefix + abbrdot + "showcov", rcc.isVisible()));
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + FillProperty, new Boolean(this.fillRects).toString());
        props.put(prefix + "coverage", new Boolean(this.showPalette).toString());
        props.put(prefix + CoverageOpaquenessProperty, Integer.toString(this.opaqueness));
        for (RpfCoverageControl rcc : this.coverages.values()) {
            String abbr = rcc.rpfProduct.abbr.replace(' ', '_');
            String abbrdot = PropUtils.getScopedPropertyPrefix(abbr);
            props.put(prefix + abbrdot + "color", Integer.toHexString(((Color)rcc.getLinePaint()).getRGB()));
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        PropUtils.setI18NPropertyInfo(this.i18n, list, RpfLayer.class, FillProperty, "Fill Coverage Rectangles", "Flag to set if the coverage rectangles should be filled.", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, RpfLayer.class, "coverage", "Show Coverage Palette", "Flag to set the coverage palette should be shown.", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, RpfLayer.class, CoverageOpaquenessProperty, "Coverage Opaqueness", "Integer representing opaqueness level (0-255, 0 is clear) of coverage rectangles.", null);
        for (RpfCoverageControl rcc : this.coverages.values()) {
            String abbr = rcc.rpfProduct.abbr.replace(' ', '_');
            String abbrdot = PropUtils.getScopedPropertyPrefix(abbr);
            PropUtils.setI18NPropertyInfo(this.i18n, list, RpfLayer.class, abbrdot + "color", rcc.rpfProduct.abbr + " Coverage Color", "Color for " + abbr + " chart coverage.", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        }
        return list;
    }

    public String getInitPropertiesOrder() {
        StringBuilder sb = new StringBuilder(" coverageFill coverageOpaque");
        for (RpfProductInfo rpi : this.coverages.keySet()) {
            sb.append(" ").append(rpi.abbr.replace(' ', '_')).append(".").append("color");
        }
        return sb.toString();
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void prepare(Projection projection, String chartSeries) {
        double ullat = 90.0;
        double ullon = -180.0;
        double lrlat = -90.0;
        double lrlon = 180.0;
        if (projection != null) {
            ullat = ((Point2D)projection.getUpperLeft()).getY();
            ullon = ((Point2D)projection.getUpperLeft()).getX();
            lrlat = ((Point2D)projection.getLowerRight()).getY();
            lrlon = ((Point2D)projection.getLowerRight()).getX();
        }
        Debug.message("basic", "RpfCoverage.prepare(): doing it");
        if (this.coverageManager == null) {
            this.coverageManager = new RpfCoverageManager(this.frameProvider);
        }
        this.clearLayerAndCoverages();
        this.coverageManager.getCatalogCoverage(ullat, ullon, lrlat, lrlon, projection, chartSeries, this.coverages);
        this.resetCoveragesOnLayer();
    }

    protected void clearLayerAndCoverages() {
        this.clear();
        for (RpfCoverageControl rcc : this.coverages.values()) {
            rcc.clear();
        }
    }

    protected void resetCoveragesOnLayer() {
        this.clear();
        for (RpfCoverageControl rcc : this.coverages.values()) {
            if (!rcc.getVisibilityToggle().isSelected()) continue;
            this.addAll(rcc);
        }
    }

    public int getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(int opaqueness) {
        this.opaqueness = opaqueness;
        for (RpfCoverageControl rcc : this.coverages.values()) {
            rcc.setFilled(this.fillRects);
            rcc.setFillPaint(this.getModifiedColor((Color)rcc.getFillPaint()));
        }
    }

    public boolean isFillRects() {
        return this.fillRects;
    }

    public void setFillRects(boolean fillRects) {
        this.fillRects = fillRects;
        if (this.coverages != null) {
            for (RpfCoverageControl rcc : this.coverages.values()) {
                rcc.setFilled(fillRects);
                rcc.setFillPaint(this.getModifiedColor((Color)rcc.getFillPaint()));
            }
        }
    }

    protected Color getModifiedColor(Color color) {
        if (this.opaqueness < 255) {
            int opa = this.opaqueness << 24;
            return ColorFactory.createColor(color.getRGB() & 0xFFFFFF | opa, true);
        }
        return ColorFactory.createColor(color.getRGB(), true);
    }

    public Component getGUI() {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Coverage Controls"));
        if (this.coverages != null) {
            for (RpfProductInfo rpi : this.coverages.keySet()) {
                box.add(this.coverages.get(rpi).getVisibilityToggle());
            }
        }
        return box;
    }

    public JFrame getPaletteWindow() {
        if (this.paletteWindow == null) {
            Component pal = this.getGUI();
            if (pal == null) {
                pal = new JLabel("No Coverage Information Available.");
            }
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setAlignmentX(0.0f);
            p.setAlignmentY(1.0f);
            p.add(pal);
            JScrollPane scrollPane = new JScrollPane(p, 20, 30);
            scrollPane.setAlignmentX(0.0f);
            scrollPane.setAlignmentY(0.0f);
            this.paletteWindow = new JFrame("RPF Coverage Palette");
            this.paletteWindow.setContentPane(scrollPane);
            this.paletteWindow.pack();
        }
        return this.paletteWindow;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DefaultColors {
        CG(RpfProductInfo.CG, 11290707),
        TLM(RpfProductInfo.TL, 13520703),
        JOG(RpfProductInfo.JG, 11304308),
        TPC(RpfProductInfo.TP, 11324688),
        ONC(RpfProductInfo.ON, 16567781),
        JNC(RpfProductInfo.JN, 7571173),
        GNC(RpfProductInfo.GN, 5604971),
        CIB10(RpfProductInfo.I1, 479595),
        CIB5(RpfProductInfo.I2, 466144),
        MISC(RpfProductInfo.MM, 15911201);

        private RpfProductInfo rpi;
        private int defaultColorInt;

        private DefaultColors(RpfProductInfo rpi, int defaultColorInt) {
            this.rpi = rpi;
            this.defaultColorInt = defaultColorInt;
        }

        static int getColorInt(RpfProductInfo rpi) {
            for (DefaultColors dc : DefaultColors.values()) {
                if (!dc.rpi.equals(rpi)) continue;
                return dc.defaultColorInt;
            }
            return DefaultColors.MISC.defaultColorInt;
        }

        static Color getColor(RpfProductInfo rpi) {
            return new Color(DefaultColors.getColorInt(rpi));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RCCScaleComparator
    implements Comparator<RpfProductInfo> {
        @Override
        public int compare(RpfProductInfo c1, RpfProductInfo c2) {
            double diff = c1.scale - c2.scale;
            if (diff == 0.0) {
                return 0;
            }
            if (diff < 0.0) {
                return 1;
            }
            return -1;
        }
    }

    public static class RpfCoverageControl
    extends OMGraphicList {
        private static final long serialVersionUID = 1L;
        RpfProductInfo rpfProduct;
        Layer layer;
        JCheckBox controlToggle;
        String colorValue;

        public RpfCoverageControl(RpfProductInfo rpfPro, Layer layer) {
            this.rpfProduct = rpfPro;
            this.layer = layer;
            Color c = DefaultColors.getColor(rpfPro);
            this.setLinePaint(c);
            this.setColorValue(Integer.toHexString(c.getRGB()));
        }

        public JCheckBox getVisibilityToggle() {
            if (this.controlToggle == null) {
                StringBuilder title = new StringBuilder("Show ");
                title.append(this.rpfProduct.abbr).append(" Coverage");
                this.controlToggle = new JCheckBox(title.toString(), true);
                this.controlToggle.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        RpfCoverageControl.this.setVisible(((JCheckBox)ae.getSource()).isSelected());
                        if (RpfCoverageControl.this.layer != null) {
                            if (RpfCoverageControl.this.layer instanceof RpfLayer && ((RpfLayer)RpfCoverageControl.this.layer).coverage != null) {
                                ((RpfLayer)RpfCoverageControl.this.layer).coverage.resetCoveragesOnLayer();
                            }
                            RpfCoverageControl.this.layer.repaint();
                        }
                    }
                });
            }
            return this.controlToggle;
        }

        public boolean add(OMGraphic omg) {
            omg.setLinePaint(this.getLinePaint());
            omg.setFillPaint(this.getFillPaint());
            return super.add(omg);
        }

        public void setFilled(boolean filled) {
            if (filled) {
                this.setFillPaint(this.getLinePaint());
            } else {
                this.setFillPaint(OMColor.clear);
            }
        }

        public boolean isFilled() {
            Paint fPaint = this.getFillPaint();
            return fPaint == null || fPaint == OMColor.clear;
        }

        public void setVisible(boolean set) {
            super.setVisible(set);
            if (this.controlToggle != null) {
                this.controlToggle.setSelected(set);
            }
        }

        public String getColorValue() {
            return this.colorValue;
        }

        public void setColorValue(String colorValue) {
            try {
                this.colorValue = colorValue;
                this.setLinePaint(PropUtils.parseColor(colorValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

