/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfCacheHandler;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfCacheManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SMALL_CACHE_SIZE = 10;
    public static final int MAX_NUM_BOXES = 4;
    protected transient RpfCacheHandler[] caches = new RpfCacheHandler[4];
    protected RpfFrameProvider frameProvider;
    protected RpfViewAttributes viewAttributes;
    protected int auxCacheSize;

    public RpfCacheManager() {
    }

    public RpfCacheManager(RpfFrameProvider fp) {
        this(fp, new RpfViewAttributes());
    }

    public RpfCacheManager(RpfFrameProvider rfp, RpfViewAttributes rva) {
        this(rfp, rva, 20, 10);
    }

    public RpfCacheManager(RpfFrameProvider rfp, RpfViewAttributes rva, int mainCacheSize, int auxSubframeCacheSize) {
        this.frameProvider = rfp;
        this.viewAttributes = rva;
        this.caches[0] = new RpfCacheHandler(rfp, rva, mainCacheSize);
        this.auxCacheSize = auxSubframeCacheSize;
    }

    public void clearCaches() {
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].clearCache();
        }
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        this.viewAttributes = rva;
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].setViewAttributes(this.viewAttributes);
        }
    }

    public RpfViewAttributes getViewAttributes() {
        return this.viewAttributes;
    }

    public void setFrameProvider(RpfFrameProvider fp) {
        this.frameProvider = fp;
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].setFrameProvider(fp);
        }
    }

    public RpfFrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public List<RpfCoverageBox> getCoverageBoxes() {
        return this.caches[0].getCoverageBoxes();
    }

    public synchronized OMGraphicList getRectangle(Projection proj) {
        float[] lat = new float[3];
        float[] lon = new float[3];
        if (this.frameProvider != null && this.frameProvider.needViewAttributeUpdates()) {
            this.frameProvider.setViewAttributes(this.viewAttributes);
        }
        int xa = 2;
        int ya = 2;
        int lat_minus = 2;
        int lon_minus = 2;
        LatLonPoint ll1 = (LatLonPoint)proj.getUpperLeft();
        LatLonPoint ll2 = (LatLonPoint)proj.getLowerRight();
        lat[0] = ll1.getLatitude();
        lon[0] = ll1.getLongitude();
        lat[1] = ll2.getLatitude();
        lon[1] = ll2.getLongitude();
        lat[2] = ll2.getLatitude();
        lon[2] = ll2.getLongitude();
        if (lon[0] > 0.0f && lon[2] < 0.0f) {
            lon[1] = -179.999f;
            lon_minus = 1;
        }
        if (lat[0] > 0.0f && lat[2] < 0.0f) {
            lat[1] = -1.0E-4f;
            lat_minus = 1;
        }
        if (Debug.debugging("rpf")) {
            Debug.output("RpfCacheManager - for:");
            Debug.output("\tlat[0] " + lat[0]);
            Debug.output("\tlon[0] " + lon[0]);
            Debug.output("\tlat[1] " + lat[1]);
            Debug.output("\tlon[1] " + lon[1]);
            Debug.output("\tlat[2] " + lat[2]);
            Debug.output("\tlon[2] " + lon[2]);
            Debug.output("\tlat_minus = " + lat_minus);
            Debug.output("\tlon_minus = " + lon_minus);
        }
        OMGraphicList list = new OMGraphicList();
        this.caches[0].getSubframes(lat[ya - lat_minus], lon[xa - lon_minus], lat[ya], lon[xa], proj, list);
        if (Debug.debugging("rpf")) {
            Debug.output("RpfCacheManager: main (1) cache used.");
        }
        if (lon_minus == 1) {
            if (this.caches[1] == null) {
                this.caches[1] = new RpfCacheHandler(this.frameProvider, this.viewAttributes, this.auxCacheSize);
            }
            this.caches[1].getSubframes(lat[ya - lat_minus], lon[0], lat[ya], -1.0f * lon[1], proj, list);
            if (Debug.debugging("rpf")) {
                Debug.output("-- second cache used");
            }
        } else {
            this.caches[1] = null;
        }
        if (lat_minus == 1) {
            if (this.caches[2] == null) {
                this.caches[2] = new RpfCacheHandler(this.frameProvider, this.viewAttributes, this.auxCacheSize);
            }
            this.caches[2].getSubframes(lat[0], lon[xa - lon_minus], -1.0f * lat[1], lon[xa], proj, list);
            if (Debug.debugging("rpf")) {
                Debug.output("-- third cache used");
            }
        } else {
            this.caches[2] = null;
        }
        if (lon_minus == 1 && lat_minus == 1) {
            if (this.caches[3] == null) {
                this.caches[3] = new RpfCacheHandler(this.frameProvider, this.viewAttributes, this.auxCacheSize);
            }
            this.caches[3].getSubframes(lat[0], lon[0], -1.0f * lat[1], -1.0f * lon[1], proj, list);
            if (Debug.debugging("rpf")) {
                Debug.output("-- fourth cache used");
            }
        } else {
            this.caches[3] = null;
        }
        return list;
    }
}

