/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.beanbox;

import com.bbn.openmap.layer.beanbox.NullLayout;
import com.bbn.openmap.layer.beanbox.SimpleBeanObject;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.tools.beanbox.BeanContainer;
import com.bbn.openmap.tools.beanbox.BeanLayoutManager;
import java.util.Vector;

public class SimpleBeanContainer
extends SimpleBeanObject
implements BeanContainer {
    private float widthInNM;
    private float heightInNM;
    private Vector contents;
    private BeanLayoutManager layoutManager;
    private String layoutClass;

    public SimpleBeanContainer() {
        this(System.currentTimeMillis(), 0.0f, 0.0f, 0.0f, 200.0f, 200.0f, null);
    }

    public SimpleBeanContainer(long id, float centerLatitude, float centerLongitude, float bearingInDeg, float widthInNM, float heightInNM, BeanLayoutManager layoutManager) {
        super(id, centerLatitude, centerLongitude, bearingInDeg);
        this.setWidthInNM(widthInNM);
        this.setHeightInNM(heightInNM);
        this.setLayout(layoutManager);
        this.contents = new Vector();
        super.setCustomGraphicClassName("com.bbn.openmap.layer.beanbox.ContainerGraphic");
    }

    public Vector getContents() {
        return this.contents;
    }

    public void setContents(Vector contents) {
        this.contents = contents;
    }

    public void add(Object bean) {
        if (bean instanceof SimpleBeanObject) {
            SimpleBeanObject obj = (SimpleBeanObject)bean;
            if (!this.contents.contains(new Long(obj.getId()))) {
                this.contents.add(new Long(obj.getId()));
            }
            if (this.layoutManager != null) {
                this.layoutManager.layoutContainer();
            }
        }
    }

    public void remove(Object bean) {
        if (bean instanceof SimpleBeanObject) {
            SimpleBeanObject obj = (SimpleBeanObject)bean;
            if (this.contents.contains(new Long(obj.getId()))) {
                this.contents.remove(new Long(obj.getId()));
            }
            if (this.layoutManager != null) {
                this.layoutManager.layoutContainer();
            }
        }
    }

    public void removeAll() {
        if (!this.contents.isEmpty()) {
            this.contents.clear();
            if (this.layoutManager != null) {
                this.layoutManager.layoutContainer();
            }
        }
    }

    public boolean contains(Object obj) {
        if (obj instanceof SimpleBeanObject) {
            return this.contains(new Long(((SimpleBeanObject)obj).getId()));
        }
        return false;
    }

    public BeanLayoutManager getLayout() {
        return this.layoutManager;
    }

    public void setLayout(BeanLayoutManager layout) {
        this.layoutManager = layout;
        if (this.layoutManager == null) {
            this.layoutManager = new NullLayout();
        }
        this.layoutClass = this.layoutManager.getClass().getName();
        this.layoutManager.setContainer(this);
        this.layoutManager.layoutContainer();
    }

    public String getLayoutClass() {
        return this.layoutClass;
    }

    public void setLayoutClass(String lc) {
        this.layoutClass = lc;
        if (this.layoutClass == null || (this.layoutClass = this.layoutClass.trim()).length() == 0) {
            System.out.println("loading null layout!");
            this.setLayout(new NullLayout());
        } else {
            try {
                Class<?> lClass = Class.forName(this.layoutClass);
                BeanLayoutManager blm = (BeanLayoutManager)lClass.newInstance();
                this.setLayout(blm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void validate() {
        if (this.layoutManager != null) {
            this.layoutManager.layoutContainer();
        }
    }

    public void setLatitude(float lat) {
        super.setLatitude(lat);
        this.validate();
    }

    public void setLongitude(float lon) {
        super.setLongitude(lon);
        this.validate();
    }

    public void setBearingInDeg(float bearingInDeg) {
        super.setBearingInDeg(bearingInDeg);
        this.validate();
    }

    public float getWidthInNM() {
        return this.widthInNM;
    }

    public void setWidthInNM(float w) {
        this.widthInNM = w;
        this.validate();
    }

    public float getHeightInNM() {
        return this.heightInNM;
    }

    public void setHeightInNM(float h) {
        this.heightInNM = h;
        this.validate();
    }

    public float getBottomLatitude() {
        return this.getLatitude() - ProjMath.radToDeg(Length.NM.toRadians(this.heightInNM / 2.0f));
    }

    public float getRightLongitude() {
        return this.getLongitude() + ProjMath.radToDeg(Length.NM.toRadians(this.widthInNM / 2.0f));
    }

    public float getTopLatitude() {
        return this.getLatitude() + ProjMath.radToDeg(Length.NM.toRadians(this.heightInNM / 2.0f));
    }

    public float getLeftLongitude() {
        return this.getLongitude() - ProjMath.radToDeg(Length.NM.toRadians(this.widthInNM / 2.0f));
    }

    public String toString() {
        return "[SBC " + this.id + " " + this.latitude + " " + this.longitude + " " + this.bearingInDeg + " " + this.customGraphicClassName + " " + this.graphicImage + " " + this.widthInNM + " " + this.heightInNM + " " + this.contents + " " + this.layoutClass + "]";
    }
}

