/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.BufferedLayerMapBean;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.gui.LayerAddPanel;
import com.bbn.openmap.gui.LayerControlButtonPanel;
import com.bbn.openmap.gui.LayerPane;
import com.bbn.openmap.gui.LayerStatusPane;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayersPanel
extends OMToolComponent
implements Serializable,
ActionListener,
LayerListener,
PropertyChangeListener {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.LayersPanel");
    public static final String LayerTopCmd = "LayerTopCmd";
    public static final String LayerBottomCmd = "LayerBottomCmd";
    public static final String LayerUpCmd = "LayerUpCmd";
    public static final String LayerDownCmd = "LayerDownCmd";
    public static final String LayerRemoveCmd = "LayerRemoveCmd";
    public static final String LayerAddCmd = "LayerAddCmd";
    public static final String LayerSelectedCmd = "LayerSelected";
    public static final String LayerDeselectedCmd = "LayerDeselected";
    public static final String ControlButtonsProperty = "controls";
    public static final String BufferedBoundaryProperty = "boundary";
    public static final String ShowStatusProperty = "showStatus";
    public static final String NO_CONTROLS = "none";
    public static final String defaultKey = "layerspanel";
    protected transient LayerHandler layerHandler = null;
    protected transient LayerAddPanel layerAddPanel = null;
    protected transient List<LayerPane> panes;
    protected transient JPanel panesPanel;
    protected transient JScrollPane scrollPane;
    protected transient ButtonGroup bg;
    protected ActionListener actionListener;
    protected LayerControlButtonPanel controls = null;
    protected Hashtable<Layer, LayerPane> paneLookUp = new Hashtable();
    protected LayerPane backgroundLayerSeparator = null;
    protected boolean bufferedBoundary = true;
    protected boolean showStatus = true;
    GridBagLayout panelGridbag;
    GridBagConstraints pgbc;

    public LayersPanel() {
        this.setKey(defaultKey);
        this.setLayout(new BorderLayout());
    }

    public LayersPanel(LayerHandler lHandler) {
        this();
        this.setLayerHandler(lHandler);
    }

    public LayersPanel(LayerHandler lHandler, boolean addLayerControls) {
        this(lHandler);
        if (addLayerControls) {
            this.addLayerControls();
        }
    }

    public void setLayerHandler(LayerHandler lh) {
        if (this.layerHandler != null) {
            this.layerHandler.removeLayerListener(this);
        }
        this.layerHandler = lh;
        if (this.layerHandler != null) {
            this.layerHandler.addLayerListener(this);
        } else {
            this.setLayers(new Layer[0]);
        }
        this.updateLayerPanes(this.layerHandler);
    }

    public LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    protected void updateLayerPanes(LayerHandler layerHandler) {
        for (LayerPane pane : this.getPanes()) {
            pane.setLayerHandler(layerHandler);
        }
    }

    @Override
    public void setLayers(LayerEvent evt) {
        Layer[] layers = evt.getLayers();
        int type = evt.getType();
        if (type == 403) {
            logger.fine("LayersPanel received layers update");
            this.setLayers(layers);
        }
    }

    @Override
    public Container getFace() {
        JButton layerButton = null;
        if (this.getUseAsTool()) {
            layerButton = new JButton(new ImageIcon(OMToolSet.class.getResource("layers.gif"), "Layer Controls"));
            layerButton.setBorderPainted(false);
            layerButton.setToolTipText(this.i18n.get(LayersPanel.class, "layerButton", 3, "Layer Controls"));
            layerButton.setMargin(new Insets(0, 0, 0, 0));
            layerButton.addActionListener(this.getActionListener());
        }
        return layerButton;
    }

    public ActionListener getActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowSupport ws = LayersPanel.this.getWindowSupport();
                if (ws == null) {
                    ws = new WindowSupport((Component)LayersPanel.this, LayersPanel.this.i18n.get(LayersPanel.class, "title", "Layers"));
                    LayersPanel.this.setWindowSupport(ws);
                }
                int w = 328;
                int h = 300;
                Dimension dim = ws.getComponentSize();
                if (dim != null) {
                    w = (int)dim.getWidth();
                    h = (int)dim.getHeight();
                }
                int x = -1;
                int y = -1;
                Point loc = ws.getComponentLocation();
                if (loc != null) {
                    x = (int)loc.getX();
                    y = (int)loc.getY();
                }
                MapHandler mh = (MapHandler)LayersPanel.this.getBeanContext();
                Frame frame = null;
                if (mh != null) {
                    frame = mh.get(Frame.class);
                }
                ws.displayInWindow(frame, x, y, w, h);
            }
        };
    }

    public void setLayers(Layer[] inLayers) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setLayersFromEDT(inLayers);
        } else {
            SwingUtilities.invokeLater(new MyWorker(inLayers));
        }
    }

    protected void setLayersFromEDT(Layer[] inLayers) {
        Layer[] layers = inLayers;
        if (inLayers == null) {
            layers = new Layer[]{};
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("LayersPanel.setLayers() with " + layers.length + " layers.");
        }
        List<LayerPane> panes = this.getPanes();
        int separatorOffset = 0;
        if (this.backgroundLayerSeparator != null && panes.contains(this.backgroundLayerSeparator)) {
            separatorOffset = 1;
        }
        if (panes.size() - separatorOffset != layers.length) {
            this.createPanel(layers);
            return;
        }
        int i = 0;
        Iterator<LayerPane> it = panes.iterator();
        while (it.hasNext() && i < layers.length) {
            LayerPane pane = it.next();
            if (pane == this.backgroundLayerSeparator) continue;
            if (pane.getLayer() != layers[i]) {
                this.createPanel(layers);
                return;
            }
            pane.updateLayerLabel();
            pane.setLayerOn(layers[i].isVisible());
            ++i;
        }
        if (it.hasNext() || i < layers.length) {
            this.createPanel(layers);
        }
    }

    protected List<LayerPane> getPanes() {
        if (this.panes == null) {
            this.panes = new LinkedList<LayerPane>();
        }
        return this.panes;
    }

    protected void setPanes(List<LayerPane> lpa) {
        this.panes = lpa;
    }

    public void createPanel(Layer[] inLayers) {
        logger.fine("creating panel");
        Layer[] layers = inLayers;
        if (layers == null) {
            layers = new Layer[]{};
        }
        if (this.panesPanel == null) {
            this.panesPanel = new JPanel();
            this.panelGridbag = new GridBagLayout();
            this.pgbc = new GridBagConstraints();
            this.panesPanel.setLayout(this.panelGridbag);
            this.pgbc.gridwidth = 0;
            this.pgbc.anchor = 18;
            this.pgbc.fill = 2;
            this.pgbc.weightx = 1.0;
        } else {
            ((GridBagLayout)this.panesPanel.getLayout()).invalidateLayout(this.panesPanel);
            this.panesPanel.removeAll();
        }
        if (this.bg == null) {
            this.bg = new ButtonGroup(){

                public void setSelected(ButtonModel m, boolean b) {
                    if (!b) {
                        for (LayerPane pane : LayersPanel.this.getPanes()) {
                            pane.setSelected(false);
                        }
                    }
                    super.setSelected(m, b);
                }
            };
        }
        LinkedList<LayerPane> panes = new LinkedList<LayerPane>();
        LinkedList<LayerPane> backgroundPanes = new LinkedList<LayerPane>();
        for (int i = 0; i < layers.length; ++i) {
            Layer layer = layers[i];
            if (layer == null) {
                logger.fine("caught null layer, " + i + " out of " + layers.length);
                continue;
            }
            LayerPane lpane = this.paneLookUp.get(layer);
            if (lpane == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating LayerPane for " + layer.getName());
                }
                lpane = this.createLayerPaneForLayer(layer, this.layerHandler, this.bg);
                lpane.addPropertyChangeListener(LayerSelectedCmd, this);
                lpane.addPropertyChangeListener(LayerDeselectedCmd, this);
                this.paneLookUp.put(layer, lpane);
            } else {
                lpane.setLayerOn(layer.isVisible());
            }
            if (layer.getAddAsBackground() && this.backgroundLayerSeparator != null) {
                backgroundPanes.add(lpane);
                continue;
            }
            panes.add(lpane);
            this.panelGridbag.setConstraints(lpane, this.pgbc);
            this.panesPanel.add(lpane);
        }
        if (!backgroundPanes.isEmpty()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding BackgroundLayerSeparator");
            }
            panes.add(this.backgroundLayerSeparator);
            this.panelGridbag.setConstraints(this.backgroundLayerSeparator, this.pgbc);
            this.panesPanel.add(this.backgroundLayerSeparator);
            panes.addAll(backgroundPanes);
            for (LayerPane lp : backgroundPanes) {
                this.panelGridbag.setConstraints(lp, this.pgbc);
                this.panesPanel.add(lp);
            }
        } else if (this.backgroundLayerSeparator != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No layers are background layers, adding separator");
            }
            panes.add(this.backgroundLayerSeparator);
            this.panelGridbag.setConstraints(this.backgroundLayerSeparator, this.pgbc);
            this.panesPanel.add(this.backgroundLayerSeparator);
        }
        this.addFillerToPanesPanel();
        this.setPanes(panes);
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.panesPanel, 20, 31);
            this.add((Component)this.scrollPane, "Center");
        }
        this.revalidate();
    }

    protected void addFillerToPanesPanel() {
        JPanel filler = new JPanel();
        this.pgbc.fill = 1;
        this.pgbc.weighty = 1.0;
        this.panelGridbag.setConstraints(filler, this.pgbc);
        this.panesPanel.add(filler);
        this.pgbc.fill = 2;
        this.pgbc.weighty = 0.0;
    }

    protected LayerPane createLayerPaneForLayer(Layer layer, LayerHandler layerHandler, ButtonGroup bg) {
        if (this.showStatus) {
            return new LayerStatusPane(layer, layerHandler, bg);
        }
        return new LayerPane(layer, layerHandler, bg);
    }

    public void deletePanes(List<LayerPane> dpanes) {
        logger.fine("deleting panes");
        if (dpanes != null) {
            this.paneLookUp.clear();
            for (LayerPane pane : dpanes) {
                if (pane == null || pane == this.backgroundLayerSeparator) continue;
                pane.removePropertyChangeListener(this);
                pane.cleanup(this.bg);
            }
        }
    }

    public void addLayerControls() {
        if (this.getControls() == null) {
            this.setControls(this.createControlButtons());
        }
    }

    public LayerControlButtonPanel createControlButtons() {
        return new LayerControlButtonPanel(this);
    }

    protected void setControlsAndNotify(LayerControlButtonPanel lcbp) {
        this.setControls(lcbp);
        if (lcbp != null) {
            lcbp.setLayersPanel(this);
        }
    }

    public void setControls(LayerControlButtonPanel lcbp) {
        this.controls = lcbp;
    }

    public LayerControlButtonPanel getControls() {
        return this.controls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(command);
        }
        try {
            LayerPane pane = this.findSelectedPane();
            if (pane != null) {
                this.moveLayer(pane, command);
            }
        }
        catch (NullPointerException npe) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveLayer(Layer layer, String command) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(command + " for " + layer.getName());
        }
        this.moveLayer(this.paneLookUp.get(layer), command);
    }

    protected void moveLayer(LayerPane lp, String command) {
        if (lp == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("LayerPane not represented on list");
            }
            if (command == LayerRemoveCmd) {
                System.gc();
            }
            return;
        }
        List<LayerPane> panes = this.getPanes();
        int row = panes.indexOf(lp);
        boolean boundary = false;
        int bls_row = -1;
        if (this.backgroundLayerSeparator != null) {
            bls_row = panes.indexOf(this.backgroundLayerSeparator);
            boundary = this.bufferedBoundary;
        }
        if (command.equals(LayerTopCmd)) {
            panes.remove(lp);
            if (boundary && bls_row > 0 && row > bls_row + 1) {
                panes.add(bls_row + 1, lp);
            } else {
                panes.add(0, lp);
            }
            this.rejiggerMapLayers();
        } else if (command.equals(LayerBottomCmd)) {
            panes.remove(lp);
            if (boundary && bls_row > 0 && row < bls_row - 1) {
                panes.add(bls_row - 1, lp);
            } else {
                panes.add(panes.size(), lp);
            }
            this.rejiggerMapLayers();
        } else if (command.equals(LayerUpCmd)) {
            if (row <= 0) {
                return;
            }
            panes.remove(row);
            panes.add(row - 1, lp);
            this.rejiggerMapLayers();
        } else if (command.equals(LayerDownCmd)) {
            if (row < 0 || row == panes.size() - 1) {
                return;
            }
            panes.remove(row);
            panes.add(row + 1, lp);
            this.rejiggerMapLayers();
        } else {
            if (command.equals(LayerRemoveCmd)) {
                if (this.layerHandler == null || !lp.getLayer().removeConfirmed()) {
                    return;
                }
                this.layerHandler.removeLayer(lp.getLayer());
                lp.cleanup(this.bg);
                return;
            }
            if (command.equals(LayerAddCmd) && this.layerAddPanel != null) {
                this.layerAddPanel.showPanel();
            }
        }
    }

    protected LayerPane findSelectedPane() {
        for (LayerPane pane : this.getPanes()) {
            if (!pane.isSelected()) continue;
            return pane;
        }
        return null;
    }

    protected void rejiggerMapLayers() {
        logger.fine("jiggering.......");
        if (this.layerHandler == null) {
            return;
        }
        int selectedRow = -1;
        this.panesPanel.removeAll();
        this.panelGridbag.invalidateLayout(this.panesPanel);
        List<LayerPane> panes = this.getPanes();
        LinkedList<Layer> layerList = new LinkedList<Layer>();
        int bufferIndex = Integer.MAX_VALUE;
        int i = 0;
        for (LayerPane pane : panes) {
            if (pane == this.backgroundLayerSeparator) {
                this.panelGridbag.setConstraints(pane, this.pgbc);
                this.panesPanel.add(this.backgroundLayerSeparator);
                bufferIndex = i++;
                continue;
            }
            Layer layer = pane.getLayer();
            layer.setAddAsBackground(i > bufferIndex);
            this.panelGridbag.setConstraints(pane, this.pgbc);
            this.panesPanel.add(pane);
            layerList.add(layer);
            if (pane.isSelected()) {
                selectedRow = i;
            }
            ++i;
        }
        this.addFillerToPanesPanel();
        this.scrollPane.revalidate();
        if (selectedRow >= 0) {
            int spheight = this.scrollPane.getHeight();
            JScrollBar sb = this.scrollPane.getVerticalScrollBar();
            int sv = sb.getValue();
            int paneheight = panes.get(selectedRow).getHeight();
            int rowvalue = selectedRow * paneheight;
            if (rowvalue <= sv || rowvalue >= spheight + sv) {
                sb.setValue(rowvalue);
            }
        }
        this.layerHandler.setLayerList(new LinkedList<Layer>(layerList));
    }

    public synchronized void updateLayerLabels() {
        for (LayerPane pane : this.getPanes()) {
            pane.updateLayerLabel();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String command = pce.getPropertyName();
        Object obj = pce.getNewValue();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("receiving PropertyChangeEvent " + command + ", " + pce.toString());
        }
        if ((command == LayerSelectedCmd || command == LayerDeselectedCmd) && obj instanceof Layer) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("layer panel notification that layer is selected: " + ((Layer)obj).getName());
            }
            this.firePropertyChange(command, null, (Layer)obj);
        } else if ((command == LayerTopCmd || command == LayerBottomCmd || command == LayerUpCmd || command == LayerDownCmd || command == LayerRemoveCmd) && obj instanceof Layer) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("layer panel notification that layer should be raised: " + ((Layer)obj).getName());
            }
            this.moveLayer((Layer)obj, command);
        }
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof LayerHandler) {
            logger.fine("LayersPanel found a LayerHandler");
            this.setLayerHandler((LayerHandler)someObj);
        }
        if (someObj instanceof BufferedLayerMapBean) {
            logger.fine("LayersPanel found BufferedLayerMapBean, creating separator panel");
            this.backgroundLayerSeparator = LayerPane.getBackgroundLayerSeparator(" --- Background Layers --- ");
        }
        if (this.controls != null && someObj != this) {
            this.controls.findAndInit(someObj);
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof LayerHandler) {
            logger.fine("LayersPanel removing LayerHandler");
            if (this.getLayerHandler() == (LayerHandler)someObj) {
                this.setLayerHandler(null);
            }
        }
        if (this.controls != null && someObj != this) {
            this.controls.findAndUndo(someObj);
        }
        if (someObj instanceof Layer) {
            this.paneLookUp.remove((Layer)someObj);
        }
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        Object obj;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String controlString = props.getProperty(prefix + ControlButtonsProperty);
        if (controlString == null) {
            this.setControls(this.createControlButtons());
        } else if (!NO_CONTROLS.equalsIgnoreCase(controlString = controlString.trim()) && (obj = ComponentFactory.create(controlString, prefix + ControlButtonsProperty, props)) instanceof LayerControlButtonPanel) {
            this.setControlsAndNotify((LayerControlButtonPanel)obj);
        }
        this.bufferedBoundary = PropUtils.booleanFromProperties(props, prefix + BufferedBoundaryProperty, this.bufferedBoundary);
        this.showStatus = PropUtils.booleanFromProperties(props, prefix + ShowStatusProperty, this.showStatus);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        LayerControlButtonPanel controls = this.getControls();
        if (controls != null) {
            props.put(prefix + ControlButtonsProperty, controls.getClass().getName());
            controls.getProperties(props);
        }
        props.put(prefix + BufferedBoundaryProperty, new Boolean(this.bufferedBoundary).toString());
        props.put(prefix + ShowStatusProperty, new Boolean(this.showStatus).toString());
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(LayersPanel.class, ControlButtonsProperty, 3, "Class to use for layer control buttons (Optional)");
        props.put(ControlButtonsProperty, interString);
        interString = this.i18n.get(LayersPanel.class, ControlButtonsProperty, "Button Panel Control");
        props.put("controls.label", interString);
        LayerControlButtonPanel controls = this.getControls();
        if (controls != null) {
            controls.getPropertyInfo(props);
        }
        interString = this.i18n.get(LayersPanel.class, BufferedBoundaryProperty, 3, "Force layer movement to respect background layer boundary.");
        props.put(BufferedBoundaryProperty, interString);
        interString = this.i18n.get(LayersPanel.class, BufferedBoundaryProperty, "Use Background Layers");
        props.put("boundary.label", interString);
        props.put("boundary.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(LayersPanel.class, ShowStatusProperty, 3, "Use Layer Panes that show layer status.");
        props.put(ShowStatusProperty, interString);
        interString = this.i18n.get(LayersPanel.class, ShowStatusProperty, "Show Layer Status");
        props.put("showStatus.label", interString);
        props.put("showStatus.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    class MyWorker
    implements Runnable {
        private Layer[] layers;

        public MyWorker(Layer[] inLayers) {
            this.layers = (Layer[])inLayers.clone();
        }

        public void run() {
            try {
                LayersPanel.this.setLayersFromEDT(this.layers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

