/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandlerChild;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.SoloMapComponentPolicy;
import com.bbn.openmap.SoloMapComponentRejectPolicy;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextServicesSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHandler
extends BeanContextServicesSupport {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.MapHandler");
    protected SoloMapComponentPolicy policy;
    protected boolean DEBUG = logger.isLoggable(Level.FINE);
    protected boolean addInProgress = false;
    protected List<Object> addLaterVector = null;

    public void setPolicy(SoloMapComponentPolicy smcp) {
        this.policy = smcp;
    }

    public SoloMapComponentPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = new SoloMapComponentRejectPolicy();
        }
        return this.policy;
    }

    protected synchronized void setAddInProgress(boolean value) {
        this.addInProgress = value;
    }

    protected synchronized boolean isAddInProgress() {
        return this.addInProgress;
    }

    protected synchronized void addLater(Object obj) {
        if (this.addLaterVector == null) {
            this.addLaterVector = new ArrayList<Object>();
        }
        if (this.DEBUG) {
            logger.fine("=== Adding " + obj.getClass().getName() + " to list for later addition");
        }
        this.addLaterVector.add(obj);
    }

    protected synchronized void purgeLaterList() {
        if (this.addLaterVector != null && !this.addInProgress) {
            Object[] objs = this.addLaterVector.toArray();
            this.addLaterVector = null;
            for (Object obj : objs) {
                if (this.DEBUG) {
                    logger.fine("+++ Adding " + obj.getClass().getName() + " to MapHandler from later list.");
                }
                this.add(obj);
            }
        }
    }

    @Override
    public synchronized boolean add(Object obj) {
        block8: {
            try {
                boolean passedSoloMapComponentTest = true;
                if (obj instanceof SoloMapComponent) {
                    try {
                        passedSoloMapComponentTest = this.getPolicy().canAdd(this, obj);
                    }
                    catch (MultipleSoloMapComponentException msmce) {
                        logger.fine(msmce.getMessage());
                        return false;
                    }
                }
                if (obj == null || !passedSoloMapComponentTest) break block8;
                if (this.addInProgress) {
                    if (this.DEBUG) {
                        logger.fine("MapHandler: Attempting to add while add in progress, adding [" + obj.getClass().getName() + "]object to list");
                    }
                    this.addLater(obj);
                    break block8;
                }
                this.addInProgress = true;
                boolean ret = super.add(obj);
                this.addInProgress = false;
                this.purgeLaterList();
                return ret;
            }
            catch (ConcurrentModificationException cme) {
                if (obj == null) break block8;
                logger.info("MapHandler caught ConcurrentModificationException when adding [" + obj.getClass().getName() + "]. The addition of this component to the MapHandler is causing some other component to attempt to be added as well, and the coping mechanism in the MapHandler is not handling it well.");
                if (this.DEBUG) {
                    cme.printStackTrace();
                }
                this.addLater(obj);
                this.addInProgress = false;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Object get(String classname) {
        Class<?> someClass = null;
        try {
            someClass = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.get(someClass);
    }

    public <T> T get(Class<T> someClass) {
        Collection<T> collection = this.getAll(someClass);
        Iterator<T> i$ = collection.iterator();
        if (i$.hasNext()) {
            T first = i$.next();
            return first;
        }
        return null;
    }

    public Collection getAll(String classname) {
        Class<?> someClass = null;
        try {
            someClass = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.getAll(someClass);
    }

    public <T> Collection<T> getAll(Class<T> someClass) {
        LinkedList<T> collection = new LinkedList<T>();
        if (someClass != null) {
            for (Object someObj : this.copyChildren()) {
                if (!someClass.isInstance(someObj)) continue;
                collection.add(someClass.cast(someObj));
            }
        }
        return collection;
    }

    @Override
    public boolean remove(Object obj) {
        boolean ret = super.remove(obj);
        if (obj instanceof BeanContextMembershipListener) {
            super.removeBeanContextMembershipListener((BeanContextMembershipListener)obj);
        }
        return ret;
    }

    public void present(Object obj) {
        for (Object someObj : this.toArray()) {
            if (!(someObj instanceof MapHandlerChild)) continue;
            ((MapHandlerChild)someObj).findAndInit(obj);
        }
    }

    @Override
    public Iterator iterator() {
        return new ArrayList(this).iterator();
    }

    public void dispose() {
        this.addLaterVector = null;
        MapBean mb = this.get(MapBean.class);
        if (mb != null) {
            this.remove(mb);
            mb.dispose();
        }
        for (Object obj : this.copyChildren()) {
            this.remove(obj);
        }
    }
}

