/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.wanderer;

import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.wanderer.TestWandererCallback;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Wanderer {
    WandererCallback callback = null;
    protected boolean exhaustiveSearch = false;
    protected boolean topToBottom = true;

    public Wanderer() {
    }

    public Wanderer(WandererCallback callback) {
        this();
        this.callback = callback;
    }

    public void setCallback(WandererCallback cb) {
        this.callback = cb;
    }

    public WandererCallback getCallback() {
        return this.callback;
    }

    public boolean handleEntry(File file) {
        boolean continueWandering = true;
        try {
            String[] filenames = file.list();
            boolean dirTest = false;
            boolean not14 = false;
            try {
                Method method = file.getClass().getDeclaredMethod("isDirectory", null);
                Object obj = method.invoke((Object)file, (Object[])null);
                if (obj instanceof Boolean) {
                    dirTest = (Boolean)obj;
                }
            }
            catch (NoSuchMethodException nsme) {
                not14 = true;
            }
            catch (SecurityException se) {
                not14 = true;
            }
            catch (IllegalAccessException iae) {
                not14 = true;
            }
            catch (IllegalArgumentException iae2) {
                not14 = true;
            }
            catch (InvocationTargetException ite) {
                not14 = true;
            }
            if (not14) {
                boolean bl = dirTest = filenames != null;
            }
            if (dirTest) {
                if (this.isTopToBottom()) {
                    continueWandering = this.callback.handleDirectory(file);
                    if (continueWandering) {
                        continueWandering = this.handleDirectory(file, filenames);
                    }
                } else {
                    this.handleDirectory(file, filenames);
                    this.callback.handleDirectory(file);
                }
            } else {
                continueWandering = this.callback.handleFile(file);
            }
        }
        catch (NullPointerException npe) {
            System.out.println("null pointer exception");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return continueWandering;
    }

    protected boolean handleDirectory(File directory, String[] contentNames) throws SecurityException {
        boolean continueWandering = true;
        for (String child : contentNames) {
            boolean keepGoing = this.handleEntry(new File(directory.getAbsolutePath() + File.separator, child));
            if (!keepGoing && !(continueWandering = this.exhaustiveSearch)) break;
        }
        return continueWandering;
    }

    public boolean isExhaustiveSearch() {
        return this.exhaustiveSearch;
    }

    public void setExhaustiveSearch(boolean exhaustiveSearch) {
        this.exhaustiveSearch = exhaustiveSearch;
    }

    public boolean isTopToBottom() {
        return this.topToBottom;
    }

    public void setTopToBottom(boolean topToBottom) {
        this.topToBottom = topToBottom;
    }

    public static void main(String[] argv) {
        Debug.init();
        ArgParser ap = new ArgParser("Wanderer");
        if (argv.length == 0) {
            ap.bail("", true);
        }
        String[] dirs = argv;
        Wanderer wanderer = new Wanderer(new TestWandererCallback());
        for (int i = 0; i < dirs.length; ++i) {
            wanderer.handleEntry(new File(dirs[i]));
        }
    }
}

