/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.http;

import com.bbn.openmap.util.http.HttpConnection;
import com.bbn.openmap.util.http.HttpRequestEvent;
import com.bbn.openmap.util.http.HttpRequestListener;
import com.bbn.openmap.util.http.ReverseListener;
import com.bbn.openmap.util.http.SeparatorListener;
import com.bbn.openmap.util.http.SieveListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class HttpServer
extends Thread {
    public static final int DEFAULT_PORT = 0;
    protected int port;
    protected ServerSocket listen_socket;
    protected Vector listeners;

    public HttpServer(int port) throws IOException {
        this(port, false);
    }

    public HttpServer(int port, boolean asDaemon) throws IOException {
        this.port = port;
        this.listeners = new Vector();
        this.listen_socket = new ServerSocket(port);
        this.setDaemon(asDaemon);
    }

    public HttpServer() throws IOException {
        this(0);
    }

    public void run() {
        try {
            while (true) {
                Socket client_socket = this.listen_socket.accept();
                HttpConnection httpConnection = new HttpConnection(client_socket, this);
                httpConnection.start();
            }
        }
        catch (IOException e) {
            System.err.println("Exception while listening for connections");
            e.printStackTrace();
            return;
        }
    }

    public int getPort() {
        return this.listen_socket.getLocalPort();
    }

    public HttpRequestEvent fireHttpRequestEvent(String request, OutputStream output) throws IOException {
        HttpRequestEvent event = new HttpRequestEvent(this, request, output);
        Vector list = (Vector)this.listeners.clone();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            HttpRequestListener listener = (HttpRequestListener)e.nextElement();
            listener.httpRequest(event);
        }
        return event;
    }

    public void addHttpRequestListener(HttpRequestListener l) {
        this.listeners.addElement(l);
    }

    public void removeHttpRequestListener(HttpRequestListener l) {
        this.listeners.removeElement(l);
    }

    public static void main(String[] args) {
        int port = 0;
        if (args.length == 1) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                port = 0;
            }
        }
        try {
            HttpServer server = new HttpServer(port);
            server.addHttpRequestListener(new SeparatorListener());
            server.addHttpRequestListener(new SieveListener());
            server.addHttpRequestListener(new SeparatorListener());
            server.addHttpRequestListener(new ReverseListener());
            server.addHttpRequestListener(new SeparatorListener());
            server.start();
            System.out.println("Server listening on port " + server.getPort());
        }
        catch (IOException e) {
            System.err.println("Unable to start http server:");
            e.printStackTrace();
        }
    }
}

